/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.handler.AsyncResponseHandlerIntf;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;

public abstract class DME2StreamReplyHandler
implements AsyncResponseHandlerIntf {
    private static final Logger logger = LoggerFactory.getLogger(DME2StreamReplyHandler.class);
    private byte[] waiter = new byte[0];
    private Exception e = null;
    private String responseCode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleException(Map<String, String> requestHeaders, Throwable e) {
        this.e = (Exception)e;
        byte[] byArray = this.waiter;
        synchronized (this.waiter) {
            this.waiter.notify();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleReply(int responseCode, String responseMessage, InputStream in, Map<String, String> requestHeaders, Map<String, String> responseHeaders) {
        this.responseCode = responseCode + "";
        byte[] byArray = this.waiter;
        synchronized (this.waiter) {
            this.waiter.notify();
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getResponse(long timeout) throws Exception {
        long start = System.currentTimeMillis();
        byte[] byArray = this.waiter;
        synchronized (this.waiter) {
            block11: {
                if (this.responseCode != null) {
                    // ** MonitorExit[var5_3] (shouldn't be in output)
                    return this.responseCode;
                }
                if (this.e != null) {
                    if (this.e instanceof DME2Exception) {
                        DME2Exception exception = new DME2Exception(((DME2Exception)this.e).getErrorCode(), ((DME2Exception)this.e).getErrorMessage(), (Throwable)this.e);
                        throw exception;
                    }
                    throw this.e;
                }
                try {
                    this.waiter.wait(timeout);
                }
                catch (InterruptedException ie) {
                    long elapsed = System.currentTimeMillis() - start;
                    logger.debug((URI)null, "getResponseCode", "DME2SimpleReplyHandler interruptedException. ElapsedTime={} ;timeoutMs={}", (Object)elapsed, (Object)timeout);
                    if (elapsed >= timeout) break block11;
                    this.waiter.wait(timeout - elapsed);
                }
            }
            if (this.responseCode != null) {
                // ** MonitorExit[var5_3] (shouldn't be in output)
                return this.responseCode;
            }
            if (this.e != null) {
                if (!(this.e instanceof Exception)) {
                    throw new RuntimeException(this.e);
                }
                throw this.e;
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            throw new DME2Exception("AFT-DME2-0999", new ErrorContext().add("timeoutMs", timeout + ""), (Throwable)new Exception("Service call timed-out"));
        }
    }

    public abstract void handleContent(byte[] var1);

    public void handleContent(byte[] bytes, int responseCode, Map<String, String> requestHeaders, Map<String, String> responseHeaders) {
        this.handleContent(bytes);
    }
}

