/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.handler.FailoverEndpoint;
import com.att.aft.dme2.handler.FailoverHandler;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.registry.accessor.BaseAccessor;
import com.att.aft.dme2.util.ErrorContext;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;

public class FailoverEndpointFactory {
    private static String failoverEndpointHandlerClassName = null;
    private static FailoverEndpoint failoverEndpointFetchingHandler = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(FailoverEndpointFactory.class.getName());
    private static FailoverEndpointFactory failoverEndpointFactory = new FailoverEndpointFactory();

    public static FailoverEndpointFactory getInstance() {
        return failoverEndpointFactory;
    }

    private static FailoverEndpoint createFailoverEndpointFetchingHandler(DME2Configuration configuration) throws DME2Exception {
        try {
            Object failoverHandlerObject = Class.forName(failoverEndpointHandlerClassName).getDeclaredConstructor(DME2Configuration.class).newInstance(configuration);
            if (null != failoverHandlerObject && failoverHandlerObject instanceof FailoverEndpoint) {
                return (FailoverEndpoint)failoverHandlerObject;
            }
            ErrorContext ec = new ErrorContext();
            ec.add("HandlerObject must implement interface - " + FailoverHandler.class.getName(), "HandlerObject must implement interface - " + FailoverHandler.class.getName());
            LOGGER.error((URI)null, "HandlerObject must implement interface - " + FailoverHandler.class.getName(), "AFT-DME2-9000", (Object)ec);
            throw new DME2Exception("AFT-DME2-9000", ec);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.error(null, "createFailoverEndpointFetchingHandler", "{} {} {}", BaseAccessor.class.getName(), " implementation Class can't be instantiated", "AFT-DME2-9000", e);
            throw new DME2Exception(BaseAccessor.class.getName() + " implementation Class can't be instantiated", e);
        }
    }

    public static FailoverEndpoint getFailoverEndpointHandler(DME2Configuration configuration) throws DME2Exception {
        if (null == failoverEndpointFetchingHandler && null != (failoverEndpointHandlerClassName = configuration.getProperty("FAILOVER_ENDPOINT_HANDLER_IMPL")) && null == failoverEndpointFetchingHandler) {
            failoverEndpointFetchingHandler = FailoverEndpointFactory.createFailoverEndpointFetchingHandler(configuration);
        }
        return failoverEndpointFetchingHandler;
    }
}

