/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.handler.FailoverHandler;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.registry.accessor.BaseAccessor;
import com.att.aft.dme2.util.ErrorContext;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;

public class FailoverFactory {
    private static String failoverHandlerClassName = null;
    private static FailoverHandler failoverHandler = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(FailoverFactory.class.getName());
    private static FailoverFactory failoverFactory = new FailoverFactory();

    public static FailoverFactory getInstance() {
        return failoverFactory;
    }

    private static FailoverHandler createFailoverHandler(DME2Configuration configuration) throws DME2Exception {
        try {
            Object failoverHandlerObject = Class.forName(failoverHandlerClassName).getDeclaredConstructor(DME2Configuration.class).newInstance(configuration);
            if (null != failoverHandlerObject && failoverHandlerObject instanceof FailoverHandler) {
                return (FailoverHandler)failoverHandlerObject;
            }
            ErrorContext ec = new ErrorContext();
            ec.add("HandlerObject must implement interface - " + FailoverHandler.class.getName(), "HandlerObject must implement interface - " + FailoverHandler.class.getName());
            LOGGER.error((URI)null, "HandlerObject must implement interface - " + FailoverHandler.class.getName(), "AFT-DME2-9000", (Object)ec);
            throw new DME2Exception("AFT-DME2-9000", ec);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.error(null, "createFailoverHandler", "{} {} {}", BaseAccessor.class.getName(), " implementation Class can't be instantiated", "AFT-DME2-9000", e);
            throw new DME2Exception(BaseAccessor.class.getName() + " implementation Class can't be instantiated", e);
        }
    }

    public static FailoverHandler getFailoverHandler(DME2Configuration configuration) throws DME2Exception {
        if (null == failoverHandler && null != (failoverHandlerClassName = configuration.getProperty("FAILOVER_HANDLER_IMPL")) && null == failoverHandler) {
            failoverHandler = FailoverFactory.createFailoverHandler(configuration);
        }
        return failoverHandler;
    }

    public static void testFailoverFactory() {
        failoverHandler = null;
    }
}

