/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api.http;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.api.DME2ReplyHandler;
import com.att.aft.dme2.api.DME2StreamReplyHandler;
import com.att.aft.dme2.api.FailoverEndpointFactory;
import com.att.aft.dme2.api.FailoverFactory;
import com.att.aft.dme2.api.RequestProcessorIntf;
import com.att.aft.dme2.api.http.DME2ExchangeRetry;
import com.att.aft.dme2.api.http.HttpResponse;
import com.att.aft.dme2.api.util.DME2ExchangeFaultContext;
import com.att.aft.dme2.api.util.DME2ExchangeReplyHandler;
import com.att.aft.dme2.api.util.DME2ExchangeResponseContext;
import com.att.aft.dme2.api.util.DME2FailoverFaultHandler;
import com.att.aft.dme2.api.util.DME2FileUploadInfo;
import com.att.aft.dme2.api.util.DME2NullReplyHandler;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.handler.AsyncResponseHandlerIntf;
import com.att.aft.dme2.handler.FailoverEndpoint;
import com.att.aft.dme2.handler.FailoverHandler;
import com.att.aft.dme2.internal.apache.commons.collections.MapUtils;
import com.att.aft.dme2.internal.apache.commons.lang.ArrayUtils;
import com.att.aft.dme2.internal.jetty.client.HttpClient;
import com.att.aft.dme2.internal.jetty.client.api.ContentResponse;
import com.att.aft.dme2.internal.jetty.client.api.Response;
import com.att.aft.dme2.internal.jetty.client.api.Result;
import com.att.aft.dme2.internal.jetty.http.HttpField;
import com.att.aft.dme2.internal.jetty.http.HttpFields;
import com.att.aft.dme2.internal.jetty.io.EofException;
import com.att.aft.dme2.internal.jetty.util.BufferUtil;
import com.att.aft.dme2.internal.jetty.util.Callback;
import com.att.aft.dme2.iterator.domain.DME2EndpointReference;
import com.att.aft.dme2.iterator.domain.IteratorMetricsEvent;
import com.att.aft.dme2.iterator.service.DME2BaseEndpointIterator;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.request.DME2Payload;
import com.att.aft.dme2.request.DME2StreamPayload;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.request.RequestContext;
import com.att.aft.dme2.util.DME2Constants;
import com.att.aft.dme2.util.DME2DateFormatAccess;
import com.att.aft.dme2.util.DME2Utils;
import com.att.aft.dme2.util.ErrorContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class DME2Exchange
implements Response.Listener {
    private static final Logger logger = LoggerFactory.getLogger(DME2Exchange.class.getName());
    private final long timeToAbandonRequest;
    private boolean returnResponseAsBytes = false;
    private DME2Configuration config;
    private DME2BaseEndpointIterator iterator;
    private DME2EndpointReference currentEndpointReference;
    private boolean markStale = true;
    private String messageID = null;
    private String correlationID = null;
    private String replyTo;
    private final StringBuffer epTraceRoute = new StringBuffer();
    private boolean checkResponseContent = true;
    private int iGNORECONTENTLENGTHVALUE = 1;
    private String iGNORECONTENTTYPEVALUE = "application/octet-stream";
    public static final String EP = "[EP=";
    public static final String EXCEPTION = "exception";
    public static final String AFT_DME2_REQ_TRACE_INFO = "AFT_DME2_REQ_TRACE_INFO";
    public static final String SERVICE = "service";
    public static final String EPREFERENCES = "[EPREFERENCES=[%s]];";
    public static final String MINACTIVEENDPOINTS = "[MINACTIVEENDPOINTS=%s];";
    public static final String JMSMESSAGEID = "JMSMessageID";
    public static final String JMSCORRELATIONID = "JMSCorrelationID";
    public static final String AFT_DME2_0702 = "AFT_DME2_0702";
    public static final String AFT_DME2_0710 = "AFT-DME2-0710";
    public static final String SERVERURL = "serverURL";
    public static final String ENDPOINT_ELAPSED_MS = "EndpointElapsedMs";
    public static final String AFT_DME2_ROUNDTRIP_TIMEOUT_MS = "AFT_DME2_ROUNDTRIP_TIMEOUT_MS";
    public static final String AFT_DME2_EP_READ_TIMEOUT_MS = "AFT_DME2_EP_READ_TIMEOUT_MS";
    public static final String REQUESTURL = ";requestUrl=";
    public static final String AFT_DME2_0712 = "AFT-DME2-0712";
    public static final String HANDLER_NAME = "handlerName";
    public static final String CHAR_SET = "; charset=";
    public static final String AFT_DME2_0715 = "AFT-DME2-0715";
    public static final String INPUTFILE = "inputFile";
    private Boolean allowAllHttpReturnCodes = false;
    private boolean retryCurrentURL = false;
    private boolean isIgnoreFailoverOnExpire = false;
    private static Set<String> globalNoticeCache = null;
    private boolean successAlready = false;
    private boolean requestHandlersInvoked = false;
    private long requestHandlersElapsedTime = 0L;
    private String preferredVersion;
    private String preferredRouteOffer;
    private boolean replyHandlersInvoked = false;
    private long executeStart;
    private String lookupURI;
    private long replyHandlersElapsedTime = 0L;
    private String currentFinalUrl = "";
    private boolean sendTraceInfo = false;
    private final int recursiveCounter = 0;
    private long sendStart;
    private String trackingID;
    private Throwable exception = null;
    private final HttpFields responseFields = new HttpFields();
    private int responseStatus = -1;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private Map<String, String> responseHeaders = new HashMap<String, String>();
    private Map<String, String> headers = new HashMap<String, String>();
    private String nonFailoverStatusCodesParam;
    private DME2Payload payloadObj;
    private AsyncResponseHandlerIntf responseHandler = null;
    private DME2Manager manager;
    private String charset = null;
    private String url = null;
    private String hostname = null;
    private int maxRecursiveCounter = 25;
    private String hostFromArgs = null;
    private boolean tRACEON = true;
    private long perEndpointTimeout = 10000L;
    private String multiPartFile = null;
    private String multiPartFileName = null;
    private final List<String> multiPartFiles;
    private final List<DME2FileUploadInfo> fileUploadInfoList;
    private Boolean checkThrottleResponseContent = true;
    private RequestContext requestContext;
    private byte[] _responseContent;
    private String roundTripTimeoutString;
    private long exchangeRoundTripTimeOut;
    private String requestPartnerName;
    private String dme2InterfaceProtocol;
    private boolean roundTripTimedout = false;
    private String timeoutString;
    private long qendpointReadTimeOut;
    private long connectTimeout;
    private static HttpClient client = null;
    private static final DME2ReplyHandler NULL_REPLY_HANDLER = new DME2NullReplyHandler();
    private DME2ReplyHandler replyHandler = NULL_REPLY_HANDLER;
    private DME2DateFormatAccess dformat;
    private boolean isPreferLocalEPs;
    private boolean strictlyEnforceRoundTripTimeout;

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
        this.responseHandler = requestContext.getRequest().getResponseHandler();
    }

    public void setPreferLocalEPs(boolean isPreferLocalEPs) {
        this.isPreferLocalEPs = isPreferLocalEPs;
        if (isPreferLocalEPs) {
            this.epTraceRoute.append(EP + this.currentFinalUrl + ":preferredLocal];");
        }
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    DME2Exchange(DME2Manager manager, String lookupURI, long perEndpointTimeout, String charset, Map<String, String> _headers) throws DME2Exception {
        logger.debug(null, "DME2Exchange", LogMessage.METHOD_ENTER);
        this.manager = manager;
        this.config = manager.getConfig();
        this.dformat = new DME2DateFormatAccess(this.config);
        this.isIgnoreFailoverOnExpire = this.config.getBoolean("AFT_DME2_IGNORE_FAILOVER_ONEXPIRE");
        this.checkResponseContent = this.config.getBoolean("AFT_DME2_CLIENT_IGNORE_CONTENT_CHECK");
        this.maxRecursiveCounter = this.config.getInt("AFT_DME2_CLIENT_MAX_RETRY_RECURSION");
        this.tRACEON = this.config.getBoolean("AFT_DME2_HTTP_EXCHANGE_TRACE_ON");
        this.iGNORECONTENTLENGTHVALUE = this.config.getInt("AFT_DME2_CLIENT_IGNORE_CONTENT_LENGTH_BYTE_SIZE");
        this.iGNORECONTENTTYPEVALUE = this.config.getProperty("AFT_DME2_CLIENT_IGNORE_RESPONSE_CONTENT_TYPE");
        this.perEndpointTimeout = perEndpointTimeout;
        this.multiPartFiles = new ArrayList<String>();
        this.fileUploadInfoList = new ArrayList<DME2FileUploadInfo>();
        this.checkThrottleResponseContent = this.config.getBoolean("AFT_DME2_THROTTLE_RESPONSE_CHECK");
        this.strictlyEnforceRoundTripTimeout = this.config.getBoolean("AFT_DME2_STRICTLY_ENFORCE_ROUNDTRIP_TIMEOUT");
        this.timeToAbandonRequest = this.config.getLong("AFT_DME2_TIME_TO_ABANDON_REQUEST");
        client = manager.getClient();
        this.lookupURI = this.stripQueryParamsFromURIString(lookupURI);
        this.currentFinalUrl = lookupURI;
        globalNoticeCache = manager.getGlobalNoticeCache();
        if (MapUtils.isNotEmpty(_headers)) {
            this.requestHeaders.putAll(_headers);
            this.headers.putAll(_headers);
        }
        try {
            this.hostname = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            logger.debug((URI)null, "DME2Exchange", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e);
        }
        this.hostFromArgs = this.config.getProperty("AFT_DME2_CONTAINER_HOST_KEY");
        this.charset = charset;
        if (this.charset == null) {
            this.charset = manager.getCharacterSet();
        }
        this.dme2InterfaceProtocol = this.headers == null || this.headers.get(JMSMESSAGEID) == null ? this.config.getProperty("AFT_DME2_INTERFACE_HTTP_PROTOCOL") : this.config.getProperty("AFT_DME2_INTERFACE_JMS_PROTOCOL");
        if ("true".equalsIgnoreCase(this.headers.get("AFT_DME2_ALLOW_ALL_HTTP_RETURN_CODES"))) {
            this.allowAllHttpReturnCodes = true;
        }
        logger.debug(null, "DME2Exchange", LogMessage.METHOD_EXIT);
    }

    public long getExchangeRoundTripTimeOut() {
        return this.exchangeRoundTripTimeOut;
    }

    public void setExchangeRoundTripTimeOut(long exchangeRoundTripTimeOut) {
        this.exchangeRoundTripTimeOut = exchangeRoundTripTimeOut;
    }

    private String stripQueryParamsFromURIString(String uriString) {
        int indexOfQuery = uriString.indexOf("?");
        if (indexOfQuery > 0) {
            return uriString.substring(0, indexOfQuery);
        }
        return uriString;
    }

    private void handleException(Map<String, String> headers, Throwable t) {
        try {
            this.responseHandler.handleException(headers, t);
        }
        catch (Exception e) {
            logger.warn(null, "handleException", LogMessage.EXCH_HANDLER_FAIL, EXCEPTION, this.replyHandler, e);
        }
    }

    @Override
    public void onBegin(Response response) {
    }

    @Override
    public boolean onHeader(Response response, HttpField field) {
        logger.debug(null, "onHeader", LogMessage.EXCH_RCV_HEADER, response, field, this.getURL());
        this.responseFields.add(field.getName(), field.getValue());
        return true;
    }

    @Override
    public void onHeaders(Response response) {
    }

    @Override
    public void onSuccess(Response response) {
        logger.debug(null, "onSuccess", LogMessage.METHOD_ENTER);
        logger.debug(null, "onSuccess", LogMessage.METHOD_EXIT);
    }

    @Override
    public void onFailure(Response response, Throwable x) {
        long executeComplete = System.currentTimeMillis();
        logger.debug(null, "onFailure", LogMessage.METHOD_ENTER);
        logger.debug((URI)null, "onFailure", "ON_FAILURE_ENTER:{}", (Object)this.recursiveCounter);
        this.currentEndpointReference = this.iterator.getCurrentEndpointReference();
        if (this.iterator != null && this.iterator.getCurrentEndpointReference() != null) {
            this.iterator.endFailure(this.createIteratorMetricsEvent(null, this.iterator.getCurrentEndpointReference()));
        }
        this.epTraceRoute.append(EP + this.currentEndpointReference.getEndpoint() != null ? this.currentEndpointReference.getEndpoint().toURLString() : this.currentFinalUrl + ":onException=" + x.getMessage() + "];");
        this.addTraceInfoToResponseHeaders();
        if (x.getMessage() != null && x.getMessage().contains("Connection refused")) {
            this.onConnectionFailed(x, response);
            return;
        }
        if (x.getMessage() != null && x.getMessage().contains("Total timeout elapsed")) {
            if (this.payloadObj instanceof DME2StreamPayload) {
                ErrorContext ec = new ErrorContext();
                ec.add(SERVICE, this.lookupURI);
                ec.add(SERVERURL, this.getURL());
                ec.add(ENDPOINT_ELAPSED_MS, String.valueOf(executeComplete - this.sendStart));
                DME2Exception exception = new DME2Exception("AFT-DME2-0718", ec);
                this.handleException(this.convertRequestHeadersAsMap(response.getRequest().getHeaders()), exception);
                return;
            }
            if (this.isIgnoreFailoverOnExpire()) {
                ErrorContext errCtx = new ErrorContext();
                errCtx.add(SERVICE, this.lookupURI);
                errCtx.add(SERVERURL, this.getURL());
                errCtx.add(ENDPOINT_ELAPSED_MS, String.valueOf(executeComplete - this.sendStart));
                this.exception = new DME2Exception("AFT-DME2-0709", errCtx);
                response.getRequest().header(AFT_DME2_REQ_TRACE_INFO, this.epTraceRoute.toString());
                this.invokeReplyHandlersFault(Integer.parseInt(this.config.getProperty("AFT_DME2_EXCH_INVOKE_FAILED_RESP_CODE", "-10")), this.iterator.getCurrentDME2EndpointRouteOffer(), response.getRequest().getURI().getQuery(), response.getHeaders(), response.getRequest().getHeaders(), this.exception);
                this.handleException(this.convertRequestHeadersAsMap(response.getRequest().getHeaders()), this.exception);
                return;
            }
        }
        this.iterator.endSuccess(this.createIteratorMetricsEvent(null, this.currentEndpointReference));
        this.exception = x;
        int responseStatus = -1;
        if (this.payloadObj instanceof DME2StreamPayload) {
            try {
                responseStatus = response.getStatus();
            }
            catch (Exception ex) {
                logger.debug((URI)null, "onFailure", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)ex);
            }
            ErrorContext ec = new ErrorContext();
            ec.add(SERVICE, this.lookupURI);
            ec.add(SERVERURL, response.getRequest().getURI().getQuery());
            ec.add(ENDPOINT_ELAPSED_MS, executeComplete - this.sendStart + "");
            ec.add("HttpResponseStatus", "" + responseStatus);
            this.epTraceRoute.append(EP + this.currentFinalUrl + ":onException=" + x.getMessage() + "];");
            this.addTraceInfoToResponseHeaders();
            DME2Exception dme2Exception = null;
            dme2Exception = responseStatus == 401 ? new DME2Exception("AFT-DME2-0707", ec) : new DME2Exception("AFT-DME2-0717", ec, x);
            Map<String, String> lheaders = this.convertResponseHeadersAsMap(response.getHeaders());
            this.handleException(lheaders, dme2Exception);
            return;
        }
        String routeOffer = null;
        if (this.currentEndpointReference != null && this.currentEndpointReference.getRouteOffer() != null && this.currentEndpointReference.getRouteOffer().getRouteOffer() != null) {
            routeOffer = this.currentEndpointReference.getRouteOffer().getRouteOffer().getName();
        }
        this.invokeReplyHandlersEndPointFault(this.config.getInt("AFT_DME2_EXCH_ON_EXCEPTION_RESP_CODE"), routeOffer, response.getRequest().getURI().getQuery(), response.getHeaders(), response.getRequest().getHeaders(), x);
        Class<?> obj = null;
        try {
            obj = Class.forName("com.att.aft.dme2.internal.jetty.io.EofException");
        }
        catch (ClassNotFoundException e) {
            logger.debug((URI)null, "onFailure", LogMessage.DEBUG_MESSAGE, (Object)"ClassNotFoundException", (Object)e);
        }
        if (this.exception instanceof EofException || this.exception.getClass().isInstance(obj)) {
            if (!this.retryCurrentURL) {
                this.retryCurrentURL = this.config.getBoolean("AFT_DME2_EXCHANGE_ALLOW_RETRY_CURR_URL");
                this.debugIt("ON_EXCEPTION_EOF_DOTRY", this.recursiveCounter + "");
                this.markStale = false;
                this.manager.getExchangeRetryThreadPool().submit(new DME2ExchangeRetry(this, response));
                return;
            }
        } else {
            this.markStale = true;
            this.retryCurrentURL = false;
            DME2Constants.setContext(this.trackingID, null);
            logger.error((URI)null, "onFailure", "AFT-DME2-0705", (Object)new ErrorContext().add("ServerURL", this.getURL()), (Object)this.exception);
            logger.debug((URI)null, "onFailure", "ON_EXCEPTION_DOTRY:{}", (Object)this.recursiveCounter);
            this.manager.getExchangeRetryThreadPool().submit(new DME2ExchangeRetry(this, response));
            return;
        }
        this.retryCurrentURL = false;
        logger.debug(null, "onFailure", LogMessage.METHOD_EXIT);
        this.markStale = true;
        this.iterator.setStale();
        this.manager.getExchangeRetryThreadPool().submit(new DME2ExchangeRetry(this, response));
    }

    protected void onConnectionFailed(Throwable x, Response response) {
        logger.debug((URI)null, "onConnectionFailed", "ON_CONNECTION_FAILED_ENTER", (Object)this.recursiveCounter);
        logger.debug(null, "onConnectionFailed", LogMessage.METHOD_ENTER);
        logger.debug((URI)null, "onConnectionFailed", AFT_DME2_0710, (Object)new ErrorContext().add("ServerURL", this.getURL()), (Object)x);
        this.exception = x;
        if (this.retryCurrentURL) {
            this.retryCurrentURL = false;
        }
        this.markStale = true;
        if (x.getMessage() != null) {
            this.debugIt("ON_CONNECTION_FAILED", x.getMessage());
            this.epTraceRoute.append(EP + (this.getUrl() == null ? this.iterator.getCurrentEndpointReference().getEndpoint().toURLString() : this.getUrl()) + ":onConnectionFailed=" + x.getMessage() + "]; ");
        } else {
            this.debugIt("ON_CONNECTION_FAILED", x.toString());
            this.epTraceRoute.append(EP + this.currentFinalUrl + ":onConnectionFailed=" + x.toString() + "]; ");
        }
        this.iterator.setStale();
        this.iterator.remove();
        if (this.iterator != null && this.iterator.getCurrentEndpointReference() != null) {
            this.iterator.endFailure(this.createIteratorMetricsEvent(null, this.iterator.getCurrentEndpointReference()));
        }
        this.invokeReplyHandlersEndPointFault(this.config.getInt("AFT_DME2_EXCH_ON_EXCEPTION_RESP_CODE"), this.currentEndpointReference.getRouteOffer() == null || this.currentEndpointReference.getRouteOffer().getRouteOffer() == null ? "" : this.currentEndpointReference.getRouteOffer().getRouteOffer().getName(), response.getRequest().getURI().getQuery(), response.getHeaders(), response.getRequest().getHeaders(), x);
        this.addTraceInfoToResponseHeaders();
        this.manager.getExchangeRetryThreadPool().submit(new DME2ExchangeRetry(this, response));
        logger.debug(null, "onConnectionFailed", LogMessage.METHOD_EXIT);
    }

    private void addTraceInfoToResponseHeaders() {
        if (this.sendTraceInfo) {
            this.addToResponseHeader(AFT_DME2_REQ_TRACE_INFO, this.epTraceRoute.toString());
            logger.debug((URI)null, "addTraceInfoToResponseHeaders", "epTraceRoute: {}", (Object)this.epTraceRoute);
        }
    }

    private void addTraceInfoToRequestHeaders() {
        if (this.sendTraceInfo) {
            this.addToRequestHeader(AFT_DME2_REQ_TRACE_INFO, this.epTraceRoute.toString());
            logger.debug((URI)null, "addTraceInfoToRequestHeaders", "epTraceRoute: {}", (Object)this.epTraceRoute);
        }
    }

    private void addToResponseHeader(String code, String message) {
        this.responseHeaders.put(code, message);
    }

    private synchronized void addToRequestHeader(String code, String message) {
        this.requestHeaders.put(code, message);
    }

    private boolean isExpired(String responseContent) {
        boolean expired = false;
        if (responseContent != null && responseContent.contains("Continuation timed out")) {
            expired = true;
        }
        return expired;
    }

    private boolean checkIfCustomFailoverHandlerExists() {
        FailoverHandler failOverHandler = null;
        try {
            failOverHandler = this.loadFailoverHandler();
        }
        catch (DME2Exception e) {
            logger.debug((URI)null, "checkIfCustomFailoverHandlerExists", "ON_RESPONSE_COMPLETE", (Object)e);
            return false;
        }
        String failoverHandlerClassName = this.config.getProperty("FAILOVER_HANDLER_IMPL");
        return null != failOverHandler && failoverHandlerClassName.equals(failOverHandler.getClass().getName());
    }

    @Override
    public void onComplete(Result result) {
        boolean hasRetried;
        boolean customFailOverHandlerExists;
        int responseStatus;
        logger.debug(null, "onComplete", LogMessage.METHOD_ENTER);
        boolean failureMetricsEventRaised = false;
        long executeComplete = System.currentTimeMillis();
        logger.debug((URI)null, "onComplete", "{}:{}", (Object)"ON_RESPONSE_STATUS", (Object)result.getResponse().getStatus());
        logger.debug((URI)null, "onComplete", "{}:{}", (Object)"ON_RESPONSE_COMPLETE", (Object)0);
        this.currentEndpointReference = this.iterator.getCurrentEndpointReference();
        if (this.currentEndpointReference != null) {
            this.iterator.endSuccess(this.createIteratorMetricsEvent(null, this.currentEndpointReference));
        }
        if (200 != (responseStatus = result.getResponse().getStatus()) && (customFailOverHandlerExists = this.checkIfCustomFailoverHandlerExists()) && (hasRetried = this.retryIfRequired(result))) {
            return;
        }
        if (result.getResponse().getStatus() < 6) {
            logger.debug((URI)null, "onResponseComplete", "{}:{}", (Object)"ON_RESPONSE_STATUS_EXIT", (Object)result.getResponse().getStatus());
            return;
        }
        String responseContent = result.getResponse().getReason();
        if (this.isExpired(responseContent) && this.isIgnoreFailoverOnExpire()) {
            ErrorContext errCtx = new ErrorContext();
            errCtx.add(SERVICE, this.lookupURI);
            errCtx.add(SERVERURL, this.getURL());
            errCtx.add(ENDPOINT_ELAPSED_MS, String.valueOf(executeComplete - this.sendStart));
            this.exception = new DME2Exception("AFT-DME2-0709", errCtx);
            result.getRequest().header(AFT_DME2_REQ_TRACE_INFO, this.epTraceRoute.toString());
            this.invokeReplyHandlersFault(Integer.parseInt(this.config.getProperty("AFT_DME2_EXCH_INVOKE_FAILED_RESP_CODE", "-10")), this.iterator.getCurrentDME2EndpointRouteOffer(), result.getRequest().getURI().getQuery(), result.getResponse().getHeaders(), result.getRequest().getHeaders(), this.exception);
            this.handleException(this.convertRequestHeadersAsMap(result.getRequest().getHeaders()), this.exception);
            return;
        }
        byte[] responseContentBytes = responseContent != null ? responseContent.getBytes() : null;
        boolean isFailoverResponseCode = this.isFailoverResponseCode(responseStatus, this.allowAllHttpReturnCodes);
        this.epTraceRoute.append(EP + this.currentFinalUrl + ":onResponseCompleteStatus=" + responseStatus + "];");
        StringBuffer buffer = new StringBuffer();
        String delim = "";
        String pattern = "[RO:%s|SEQ:%s]";
        for (DME2EndpointReference ep : this.iterator.getEndpointReferenceList()) {
            if (ep.getEndpoint() == null || ep.getEndpoint().getRouteOffer() == null || ep.getRouteOffer() == null || ep.getRouteOffer().getRouteOffer() == null) continue;
            buffer.append(delim);
            buffer.append(String.format(pattern, ep.getEndpoint().getRouteOffer(), ep.getRouteOffer().getRouteOffer().getSequence()));
            delim = ",";
        }
        this.epTraceRoute.append(String.format(EPREFERENCES, buffer));
        this.epTraceRoute.append(String.format(MINACTIVEENDPOINTS, this.iterator.getMinActiveEndPoints()));
        this.addTraceInfoToResponseHeaders();
        if (isFailoverResponseCode && this.allowAllHttpReturnCodes.booleanValue()) {
            try {
                this.doTry(result.getResponse());
            }
            catch (DME2Exception e) {
                throw new RuntimeException(e);
            }
            return;
        }
        if (responseStatus == 500 && this.config.getBoolean("AFT_DME2_PARSE_FAULT") && !isFailoverResponseCode) {
            try {
                FailoverHandler failOverHandler = this.loadFailoverHandler();
                this.parseFaultResponse(failOverHandler, responseStatus, responseContent, responseContentBytes, executeComplete, result);
                return;
            }
            catch (Throwable e) {
                logger.debug("", (URI)null, "onComplete", LogMessage.DEBUG_MESSAGE, (Object)"Parse Fault Response Failed", (Object)e);
            }
        }
        this.exception = null;
        logger.debug((URI)null, "onComplete", "allowAllHttpReturnCodes: {} sendTraceInfo: {}", (Object)this.allowAllHttpReturnCodes, (Object)this.sendTraceInfo);
        if (!this.allowAllHttpReturnCodes.booleanValue() && responseStatus == 401 && !isFailoverResponseCode) {
            this.exception = new DME2Exception("AFT-DME2-0707", new ErrorContext().add(SERVICE, this.lookupURI).add("ServerURL", result.getRequest().getURI().getQuery()));
            result.getRequest().header(AFT_DME2_REQ_TRACE_INFO, this.epTraceRoute.toString());
            this.invokeReplyHandlersFault(this.config.getInt("AFT_DME2_EXCH_INVOKE_FAILED_RESP_CODE"), this.iterator.getCurrentDME2EndpointRouteOffer(), result.getRequest().getURI().getQuery(), result.getResponse().getHeaders(), result.getRequest().getHeaders(), this.exception);
            this.handleException(this.convertRequestHeadersAsMap(result.getRequest().getHeaders()), this.exception);
            return;
        }
        logger.debug((URI)null, "onComplete", "allowAllHttpReturnCodes: {} sendTraceInfo: {}", (Object)this.allowAllHttpReturnCodes, (Object)this.sendTraceInfo);
        logger.debug((URI)null, "onComplete", "config AFT_DME2_LOOKUP_NON_FAILOVER_SC: {}", (Object)this.config.getBoolean("AFT_DME2_LOOKUP_NON_FAILOVER_SC"));
        logger.debug((URI)null, "onComplete", "isFailoverResponseCode(responseStatus): {}", (Object)isFailoverResponseCode);
        logger.debug((URI)null, "onComplete", "responseStatus: {}", (Object)responseStatus);
        if (this.allowAllHttpReturnCodes.booleanValue() || (this.config.getBoolean("AFT_DME2_LOOKUP_NON_FAILOVER_SC") ? !isFailoverResponseCode : responseStatus == 200)) {
            logger.debug((URI)null, "onResponseComplete", "{}:{}", (Object)"ON_RESPONSE_STATUS", (Object)result.getResponse().getStatus());
            DME2Constants.setContext(this.trackingID, null);
            Map<String, String> responseHeaderMap = this.convertResponseHeadersAsMap(result.getResponse().getHeaders());
            if (result.isSucceeded() && result.getResponse() instanceof ContentResponse) {
                ContentResponse contentResponse = (ContentResponse)result.getResponse();
                this._responseContent = contentResponse.getContentAsString().getBytes();
            }
            this.checkResponseContent = this.config.getBoolean("AFT_DME2_CLIENT_IGNORE_CONTENT_CHECK");
            if (this.checkResponseContent) {
                String conType = responseHeaderMap.get("Content-Type");
                if (conType == null) {
                    conType = responseHeaderMap.get("Content-type");
                }
                if (conType == null) {
                    conType = responseHeaderMap.get("content-type");
                }
                if (conType != null && this._responseContent != null) {
                    this.iGNORECONTENTLENGTHVALUE = this.config.getInt("AFT_DME2_CLIENT_IGNORE_CONTENT_LENGTH_BYTE_SIZE");
                    this.iGNORECONTENTTYPEVALUE = this.config.getProperty("AFT_DME2_CLIENT_IGNORE_RESPONSE_CONTENT_TYPE");
                    int responseContentLength = this._responseContent.length;
                    if (responseContentLength == this.iGNORECONTENTLENGTHVALUE && conType.contains(this.iGNORECONTENTTYPEVALUE)) {
                        logger.debug(null, "onResponseComplete", "ON_RESPONSE_IGNORE_CONTENT_LENGTH:" + responseContentLength);
                        logger.debug(null, "onResponseComplete", "ON_RESPONSE_IGNORE_CONTENT_TYPE:" + conType);
                        this.exception = new Exception("Request to [http://" + result.getRequest().getURI() + "] returned HTTP response, but with ignorable contentType [" + conType + "] and contentLength [" + responseContentLength + "]; validate that the endpoint is hosting a valid server port if no aother endpoints are available for failover");
                        if (this.retryCurrentURL) {
                            this.retryCurrentURL = false;
                        }
                        if (this.payloadObj instanceof DME2StreamPayload) {
                            DME2Exception dme2Exception = new DME2Exception("AFT-DME2-0717", new ErrorContext().add(SERVICE, this.lookupURI).add(SERVERURL, result.getRequest().getURI().getQuery()).add(ENDPOINT_ELAPSED_MS, executeComplete - this.sendStart + ""), this.exception);
                            Map<String, String> lheaders = this.convertRequestHeadersAsMap(result.getRequest().getHeaders());
                            this.handleException(lheaders, dme2Exception);
                            return;
                        }
                        this.retryIfRequired(result);
                        return;
                    }
                }
            }
            if (!this.successAlready) {
                logger.debug((URI)null, "onComplete", LogMessage.EXCH_SEND_URL, (Object)this.getURL(), (Object)this.timeoutString);
                if (this.iterator.getCurrentDME2EndpointRouteOffer() != null && globalNoticeCache.remove(this.lookupURI + ":" + this.iterator.getCurrentDME2RouteOffer().getService())) {
                    logger.info("", (URI)null, "onComplete", LogMessage.EXCH_OFFER_RESTORE, (Object)this.lookupURI, (Object)this.iterator.getCurrentDME2RouteOffer().getSearchFilter());
                }
                this.successAlready = true;
            }
            if (this.replyTo == null && this.getPrefixStrippedHeaderValue(responseHeaderMap, "JMSDestination") != null) {
                this.replyTo = (String)this.getPrefixStrippedHeaderValue(responseHeaderMap, "JMSDestination");
            }
            if (this.replyTo != null) {
                responseHeaderMap.put("JMSDestination", this.replyTo);
            } else {
                this.replyTo = (String)this.getPrefixStrippedHeaderValue(this.convertRequestHeadersAsMap(result.getRequest().getHeaders()), "JMSReplyTo");
                if (this.replyTo != null) {
                    responseHeaderMap.put("JMSDestination", this.replyTo);
                }
            }
            if (responseHeaderMap.get(JMSCORRELATIONID) == null) {
                if (this.correlationID != null) {
                    responseHeaderMap.put(JMSCORRELATIONID, this.correlationID);
                } else if (this.messageID != null) {
                    responseHeaderMap.put(JMSCORRELATIONID, this.messageID);
                }
            }
            if (this._responseContent != null) {
                logger.debug("", null, "onResponseComplete", "ON_RESPONSE_STATUS_200_REPLY:" + this._responseContent.length);
                HttpFields responseHeaders = result.getResponse().getHeaders();
                HttpFields requestHeaders = result.getRequest().getHeaders();
                this.invokeReplyHandlers(responseStatus, this.iterator.getCurrentDME2EndpointRouteOffer(), result.getRequest().getURI().getQuery(), responseHeaders, requestHeaders);
                if (this.replyHandlersInvoked || this.requestHandlersInvoked) {
                    logger.info(null, "onResponseComplete", LogMessage.EXCH_RECEIVE_HANDLERS, this.getURL(), responseStatus, executeComplete - this.sendStart, executeComplete - this.executeStart, this.preferredRouteOffer, this.preferredVersion, this.requestHandlersInvoked ? Long.valueOf(this.requestHandlersElapsedTime) : "", this.replyHandlersInvoked ? Long.valueOf(this.replyHandlersElapsedTime) : "", this._responseContent.length);
                } else {
                    logger.info(null, "onResponseComplete", LogMessage.EXCH_RECEIVE, this.getURL(), responseStatus, executeComplete - this.sendStart, executeComplete - this.executeStart, this._responseContent == null ? 0 : this._responseContent.length);
                }
                this.addTraceInfoToResponseHeaders();
                logger.debug((URI)null, "onComplete", "inside handleReply convertResponseHeadersAsMap(responseHeaders): {}", (Object)this.convertResponseHeadersAsMap(responseHeaders));
                this.responseHandler.handleReply(responseStatus, "", new ByteArrayInputStream(this._responseContent), this.convertRequestHeadersAsMap(requestHeaders), responseHeaderMap);
            } else {
                this.debugIt("ON_RESPONSE_STATUS_REPLY_SIZE", "0");
                logger.debug("", (URI)null, "onResponseComplete", "{}:0", (Object)"ON_RESPONSE_STATUS_REPLY_SIZE");
                logger.info(null, "onComplete", LogMessage.EXCH_RECEIVE, this.getURL(), responseStatus, executeComplete - this.sendStart, executeComplete - this.executeStart, 0);
                this.addTraceInfoToResponseHeaders();
                try {
                    this.responseHandler.handleReply(responseStatus, "", new ByteArrayInputStream("".getBytes("UTF-8")), this.requestHeaders, responseHeaderMap);
                }
                catch (UnsupportedEncodingException e) {
                    logger.warn("", null, "onComplete", LogMessage.EXCH_HANDLER_FAIL, "reply", this.replyHandler, e);
                }
            }
            this.iterator.removeStaleIteratorElement(this.currentEndpointReference.getEndpoint().getServiceEndpointID());
        } else {
            this.debugIt("ON_RESPONSE_EXCEPTION_RETURN_CODE", responseStatus);
            this.debugIt("ON_RESPONSE_EXCEPTION_RETURN_MESSAGE", this._responseContent != null ? this._responseContent.toString() : null);
            logger.debug(null, "onComplete", "ON_RESPONSE_EXCEPTION_RETURN_CODE" + responseStatus);
            logger.debug((URI)null, "onComplete", "ON_RESPONSE_EXCEPTION_RETURN_MESSAGE", (Object)(this._responseContent != null ? this._responseContent.toString() : null));
            this.exception = new Exception("Request to [http://" + result.getRequest().getURI().getQuery() + "] returned HTTP [" + responseStatus + "]; " + "validate that the endpoint is running if no aother endpoints are available for failover.");
            if (this.retryCurrentURL) {
                this.retryCurrentURL = false;
            }
            if (this.payloadObj instanceof DME2StreamPayload) {
                ErrorContext errCtx = new ErrorContext();
                errCtx.add(SERVICE, result.getRequest().getURI().getQuery());
                DME2Exception dme2Exception = new DME2Exception("AFT-DME2-0717", errCtx, this.exception);
                Map<String, String> lheaders = this.convertRequestHeadersAsMap(result.getRequest().getHeaders());
                this.responseHandler.handleException(lheaders, dme2Exception);
                return;
            }
            try {
                this.doTry(result.getResponse());
            }
            catch (DME2Exception dME2Exception) {
                // empty catch block
            }
        }
        logger.debug(null, "onComplete", LogMessage.METHOD_EXIT);
    }

    private Object getPrefixStrippedHeaderValue(Map headerMap, String headerName) {
        Object returnValue = null;
        if (headerMap.get(headerName) != null) {
            returnValue = headerMap.get(headerName);
        } else if (headerMap.get(this.config.getProperty("DME2_HEADER_PREFIX").concat(headerName)) != null) {
            returnValue = headerMap.get(this.config.getProperty("DME2_HEADER_PREFIX").concat(headerName));
        }
        return returnValue;
    }

    private String[] getExchangeReplyHandlers() {
        String replyHandlers = this.headers.get(this.config.getProperty("AFT_DME2_EXCHANGE_REPLY_HANDLERS_KEY"));
        this.debugIt("DME2Exchange.getExchangeReplyHandlers", replyHandlers);
        if (replyHandlers != null && replyHandlers.length() > 0) {
            try {
                String[] replyHandlersArr = replyHandlers.split(",");
                this.debugIt("REPLY_HANDLERS_CHAIN_HEADER_PROPERTY", replyHandlers + "");
                return replyHandlersArr;
            }
            catch (Exception e) {
                logger.debug((URI)null, "getExchangeReplyHandlers", LogMessage.EXCH_READ_HANDLER_FAIL, (Object)"getExchangeReplyHandlers", (Object)e);
                return null;
            }
        }
        replyHandlers = this.config.getProperty(this.config.getProperty("AFT_DME2_EXCHANGE_REPLY_HANDLERS_KEY"));
        if (replyHandlers != null && replyHandlers.length() > 0) {
            try {
                String[] replyHandlersArr = replyHandlers.split(",");
                this.debugIt("REPLY_HANDLERS_CHAIN_MGR_PROPERTY", replyHandlers + "");
                return replyHandlersArr;
            }
            catch (Exception e) {
                logger.debug((URI)null, "getExchangeReplyHandlers", LogMessage.EXCH_READ_HANDLER_FAIL, (Object)"getExchangeReplyHandlers", (Object)e);
                return null;
            }
        }
        return null;
    }

    private String[] getAllExchangeReplyHandlers() {
        return (String[])ArrayUtils.addAll(this.getExchangeReplyHandlers(), DME2Utils.getFailoverHandlers(this.config, this.headers));
    }

    public Map<String, String> convertRequestHeadersAsMap(HttpFields httpFields) {
        HashMap<String, String> _headers = new HashMap<String, String>();
        if (httpFields == null) {
            return _headers;
        }
        Enumeration<String> e1 = httpFields.getFieldNames();
        while (e1.hasMoreElements()) {
            String key = e1.nextElement();
            _headers.put(key, httpFields.get(key));
        }
        if (MapUtils.isNotEmpty(this.requestHeaders)) {
            _headers.putAll(this.requestHeaders);
        }
        return _headers;
    }

    public Map<String, String> convertResponseHeadersAsMap(HttpFields httpFields) {
        HashMap<String, String> _headers = new HashMap<String, String>();
        if (httpFields == null) {
            return _headers;
        }
        Enumeration<String> e1 = httpFields.getFieldNames();
        while (e1.hasMoreElements()) {
            String key = e1.nextElement();
            if (key.equalsIgnoreCase("Content-Type")) {
                String charset = httpFields.get(key).substring(httpFields.get(key).indexOf("charset=") + "charset=".length()).trim();
                if (charset == null) continue;
                String s = charset.replaceAll("'", "").replaceAll("\"", "");
                _headers.put(key, httpFields.get(key).substring(0, httpFields.get(key).indexOf("charset=") + "charset=".length()) + s);
                continue;
            }
            _headers.put(key, httpFields.get(key));
        }
        if (MapUtils.isNotEmpty(this.responseHeaders)) {
            _headers.putAll(this.responseHeaders);
        }
        return _headers;
    }

    public boolean retryIfRequired(Result result) {
        boolean isFailoverRequired = false;
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.buildResponseObject(result);
        try {
            isFailoverRequired = FailoverFactory.getFailoverHandler(this.config).isFailoverRequired(httpResponse);
            if (isFailoverRequired) {
                this.doTry(result.getResponse());
            }
        }
        catch (DME2Exception e) {
            logger.error(null, "retryIfRequired", e.getMessage());
        }
        return isFailoverRequired;
    }

    public void doTry(Response response) throws DME2Exception {
        logger.debug(null, "doTry", LogMessage.METHOD_ENTER);
        long roundTripTimeout = this.getRoundTripTimeout();
        boolean isEndpointResolved = false;
        if (!this.retryCurrentURL && !this.isThrottledResponse()) {
            this.iterator.setStale();
        }
        logger.debug((URI)null, "doTry", "iterator.isAllElementsExhausted: {} roundTripTimeout: {}", (Object)this.iterator.isAllElementsExhausted(), (Object)roundTripTimeout);
        if (this.iterator.isAllElementsExhausted()) {
            this.postStatisticsToMetrics(roundTripTimeout, response);
            this.addTraceInfoToRequestHeaders();
            String endpointsAttempted = this.epTraceRoute != null ? this.epTraceRoute.toString() : null;
            ErrorContext ec = new ErrorContext();
            ec.add(SERVICE, this.lookupURI);
            ec.add("roundTripTimeoutInMs", "" + roundTripTimeout);
            if (endpointsAttempted != null) {
                ec.add("endpointsAttempted", endpointsAttempted);
            }
            if (this.tRACEON) {
                ec.add("EndpointTrace", this.epTraceRoute.toString());
            }
            DME2Exception dme2Exception = new DME2Exception("AFT-DME2-0703", ec);
            this.invokeReplyHandlersFault(this.config.getInt("AFT_DME2_EXCH_INVOKE_FAILED_RESP_CODE"), this.iterator.getCurrentDME2EndpointRouteOffer(), response.getRequest().getURI().getQuery(), response.getHeaders(), response.getRequest().getHeaders(), dme2Exception);
            this.handleException(this.convertResponseHeadersAsMap(response.getHeaders()), dme2Exception);
            return;
        }
        logger.debug((URI)null, "doTry", "iterator.isAllElementsExhausted: {}", (Object)this.iterator.isAllElementsExhausted());
        logger.debug((URI)null, "doTry", "iterator.getCurrentEndpointReference().getEndpoint().toURLString(): {}", (Object)this.iterator.getCurrentEndpointReference().getEndpoint().toURLString());
        logger.debug((URI)null, "doTry", "roundTripTimeout: {}", (Object)roundTripTimeout);
        logger.debug((URI)null, "doTry", "ElapsedTime < roundTripTimeout? : {}", (Object)(System.currentTimeMillis() - this.executeStart < roundTripTimeout ? 1 : 0));
        if (this.iterator.hasNext() && !this.roundTripTimedout) {
            if (this.exception != null) {
                logger.debug((URI)null, "doTry", LogMessage.EXCH_ENDPT_FAIL, (Object)this.getURL(), (Object)this.exception.toString());
            }
            try {
                logger.debug(null, "doTry", "DO_TRY_RESET");
            }
            catch (Exception e) {
                logger.debug((URI)null, "doTry", "DO_TRY_RESET_FAILED", (Object)e);
            }
            RequestProcessorIntf requestProcessor = this.getRequestContext().getRequest().getRequestProcessor();
            DME2EndpointReference nextEndpoint = this.getCurrentEndpointReference();
            if (!this.retryCurrentURL) {
                logger.debug(null, "doTry", "Inside if loop (!retryCurrentURL)");
                FailoverEndpoint endpoint = null;
                try {
                    endpoint = FailoverEndpointFactory.getFailoverEndpointHandler(this.config);
                    nextEndpoint = endpoint.getNextFailoverEndpoint(this.iterator, this.retryCurrentURL);
                    this.setUrl(nextEndpoint.getEndpoint().toURLString());
                    logger.debug((URI)null, "doTry", "setUrl the while loop, nextEndpoint.getEndpoint().toURLString(): {}", (Object)nextEndpoint.getEndpoint().toURLString());
                    this.iterator.start(this.createIteratorMetricsEvent(null, nextEndpoint));
                    isEndpointResolved = requestProcessor.send(this.requestContext, nextEndpoint, this.payloadObj);
                }
                catch (DME2Exception e) {
                    logger.error((URI)null, DME2Exchange.class.getName(), "AFT-DME2-9000", (Object)e);
                    throw new DME2Exception(DME2Exchange.class.getName() + "AFT-DME2-9000", e);
                }
            }
            logger.debug((URI)null, "doTry", LogMessage.DEBUG_MESSAGE, (Object)("doTry() - Retrying current URL: " + this.getURL()));
            this.setUrl(this.getURL());
            logger.debug((URI)null, "doTry", LogMessage.EXCH_RETRY, (Object)this.getURL());
            DME2Constants.setContext(this.trackingID, null);
            if (this.strictlyEnforceRoundTripTimeout) {
                this.setReadTimeoutOnRetry();
            } else {
                this.setReadTimeout();
            }
            try {
                logger.debug(null, "doTry", "DO_TRY_CLIENT_SEND_ATTEMPT");
                this.sendStart = System.currentTimeMillis();
                this.iterator.start(this.createIteratorMetricsEvent(null, nextEndpoint));
                this.getRequestContext().getRequest().getClientHeaders().put("AFT_DME2_CLIENT_SEND_TIMESTAMP_KEY", this.dformat.convertDateToString(new Date()));
                isEndpointResolved = requestProcessor.send(this.requestContext, nextEndpoint, this.payloadObj);
                logger.debug(null, "doTry", "CLIENT_SEND_ATTEMPT_ELAPSED messageID={};correlationID={};URL={};elapsed={}", this.messageID, this.correlationID, this.getURL(), System.currentTimeMillis() - this.sendStart);
            }
            catch (IllegalStateException e) {
                logger.debug((URI)null, "doTry", "ILLEGAL_STATE_EXCEPTION_IGNORABLE" + e.toString(), (Object)e);
            }
            catch (Throwable th) {
                logger.debug((URI)null, "doTry", "DO_TRY_CLIENT_SEND_THROWABLE", (Object)th.toString());
                this.exception = th;
            }
        }
        String conversationID = this.requestContext.getLogContext().getConversationId();
        if (!isEndpointResolved) {
            ErrorContext ec = new ErrorContext();
            ec.add(SERVICE, this.requestContext.getRequest().getLookupUri());
            DME2Exception e = new DME2Exception("AFT-DME2-0702", ec);
            logger.error(conversationID, null, "AFT-DME2-0702{}", e.getErrorMessage());
            this.responseHandler.handleException(this.convertResponseHeadersAsMap(response.getHeaders()), e);
            throw e;
        }
        if (System.currentTimeMillis() - this.executeStart > roundTripTimeout) {
            logger.debug(null, "doTry", "DO_TRY_ROUNDTRIP_TIMEOUT_REACHED");
            this.roundTripTimedout = true;
        }
        if (this.roundTripTimedout) {
            logger.debug(null, "doTry", "DO_TRY_THROW_ROUNDTRIP_TIMEDOUT_EXCEPTION");
            this.addTraceInfoToResponseHeaders();
            DME2Exception dme2Exception = new DME2Exception("AFT-DME2-0713", new ErrorContext().add(SERVICE, this.lookupURI).add("roundTripTimeOutInMs", this.roundTripTimeoutString).add("timedOutAfter", "" + (System.currentTimeMillis() - this.executeStart)));
            this.invokeReplyHandlersFault(this.config.getInt("AFT_DME2_EXCH_INVOKE_FAILED_RESP_CODE"), this.iterator.getCurrentDME2EndpointRouteOffer(), this.getURL(), response.getHeaders(), response.getRequest().getHeaders(), dme2Exception);
            this.handleException(this.headers, dme2Exception);
        }
        logger.debug(null, "doTry", LogMessage.METHOD_EXIT);
    }

    private boolean isThrottledResponse() {
        if (this.checkThrottleResponseContent.booleanValue()) {
            return 429 == this.getResponseStatus();
        }
        return false;
    }

    private IteratorMetricsEvent createIteratorMetricsEvent(String conversationId, DME2EndpointReference orderedEndpointHolder) {
        String role = this.config.getProperty("AFT_DME2_INTERFACE_CLIENT_ROLE");
        IteratorMetricsEvent iteratorMetricsEvent = new IteratorMetricsEvent();
        if (orderedEndpointHolder != null && orderedEndpointHolder.getEndpoint() != null) {
            iteratorMetricsEvent.setClientIp(orderedEndpointHolder.getEndpoint().getHost());
            iteratorMetricsEvent.setProtocol(this.dme2InterfaceProtocol);
            iteratorMetricsEvent.setServiceUri(orderedEndpointHolder.getEndpoint().toURLString());
        }
        iteratorMetricsEvent.setConversationId(conversationId);
        iteratorMetricsEvent.setRole(role);
        iteratorMetricsEvent.setEventTime(System.currentTimeMillis());
        iteratorMetricsEvent.setPartner(this.getRequestPartnerName());
        return iteratorMetricsEvent;
    }

    private void postStatisticsToMetrics(long roundTripTimeout, Response response) {
        logger.debug(null, "postStatisticsToMetrics", "DO_TRY_ENDPOINTS_EXHAUSTED");
        try {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("EVENT_TIME", System.currentTimeMillis());
            props.put("FAULT_EVENT", true);
            props.put("QUEUE_NAME", this.constructDME2ServiceStatsURI(this.lookupURI));
            props.put("ELAPSED_TIME", System.currentTimeMillis() - this.executeStart);
            props.put("MESSAGE_ID", this.messageID);
            props.put("DME2_INTERFACE_PROTOCOL", this.dme2InterfaceProtocol);
            props.put("DME2_INTERFACE_ROLE", this.config.getProperty("AFT_DME2_INTERFACE_CLIENT_ROLE"));
            props.put("DME2_INTERFACE_PORT", response.getRequest().getPort() + "");
            props.put("FAULT_EVENT", true);
            if (this.getRequestPartnerName() != null) {
                props.put("DME2_REQUEST_PARTNER", this.getRequestPartnerName());
            }
            this.manager.postStatEvent(props);
            return;
        }
        catch (Exception e1) {
            ErrorContext ec = new ErrorContext();
            ec.add("Code", "DME2Client.Fault");
            ec.add("extendedMessage", e1.getMessage());
            logger.debug((URI)null, "postStatisticsToMetrics", "AFT-DME2-5101", (Object)ec);
            return;
        }
    }

    private String getURL() {
        return this.currentFinalUrl;
    }

    private void setReadTimeout() {
        String jmsPropertyEndpointTimeout = this.headers.get(AFT_DME2_EP_READ_TIMEOUT_MS);
        long timeout = 0L;
        if (jmsPropertyEndpointTimeout != null) {
            try {
                timeout = Long.parseLong(jmsPropertyEndpointTimeout);
            }
            catch (Exception e) {
                timeout = this.config.getLong(AFT_DME2_EP_READ_TIMEOUT_MS);
            }
            this.timeoutString = "JMSHeader-AFT_DME2_EP_READ_TIMEOUT_MS=" + timeout;
        } else if (this.qendpointReadTimeOut > 0L) {
            this.timeoutString = "URIQueryString-endpointReadTimeout=" + this.qendpointReadTimeOut;
            timeout = this.qendpointReadTimeOut;
        } else {
            timeout = this.config.getLong(AFT_DME2_EP_READ_TIMEOUT_MS);
            this.timeoutString = "CFG-AFT_DME2_EP_READ_TIMEOUT_MS=" + timeout;
        }
        this.debugIt("EXECUTE_SET_READ_TIMEOUT", this.timeoutString);
        if (this.getConnectTimeout() > 0L) {
            client.setConnectTimeout((int)this.getConnectTimeout());
            this.setConnectTimeout((int)this.getConnectTimeout());
        }
    }

    private void setReadTimeoutOnRetry() {
        String jmsPropertyEndpointTimeout = this.headers.get(AFT_DME2_EP_READ_TIMEOUT_MS);
        long timeout = 0L;
        if (jmsPropertyEndpointTimeout != null) {
            try {
                timeout = Long.parseLong(jmsPropertyEndpointTimeout);
            }
            catch (Exception e) {
                timeout = this.config.getLong(AFT_DME2_EP_READ_TIMEOUT_MS);
            }
            this.timeoutString = "JMSHeader-AFT_DME2_EP_READ_TIMEOUT_MS=" + timeout;
        } else if (this.qendpointReadTimeOut > 0L) {
            this.timeoutString = "URIQueryString-endpointReadTimeout=" + this.qendpointReadTimeOut;
        }
        long timeLeft = this.getRoundTripTimeout() - (System.currentTimeMillis() - this.executeStart);
        long minTimeout = Math.min(timeout, timeLeft);
        if (minTimeout < timeout) {
            this.debugIt("EXECUTE_SET_READ_TIMEOUT_ON_RETRY_TIME_LEFT {}", String.valueOf(timeLeft));
            if (minTimeout > this.timeToAbandonRequest) {
                if (this.getConnectTimeout() > 0L) {
                    this.debugIt("EXECUTE_CLIENT_SPECIFIED_CONNECT_TIMEOUT {}", this.getConnectTimeout() + "");
                    long finalConnectTimeout = Math.min(this.getConnectTimeout(), minTimeout);
                    if (minTimeout > finalConnectTimeout) {
                        minTimeout -= finalConnectTimeout;
                    }
                    this.debugIt("EXECUTE_SET_CONNECT_TIMEOUT_ON_RETRY {}", String.valueOf(finalConnectTimeout));
                    client.setConnectTimeout((int)finalConnectTimeout);
                    this.setConnectTimeout((int)finalConnectTimeout);
                }
                this.addToRequestHeader(AFT_DME2_EP_READ_TIMEOUT_MS, minTimeout + "");
                client.setConnectTimeout(minTimeout);
                this.setConnectTimeout(minTimeout);
                this.debugIt("EXECUTE_SET_READ_TIMEOUT_ON_RETRY", minTimeout + "");
            } else {
                this.debugIt("EXECUTE_NEXT_RETRY_HAS_TOO_LITTLE_TIME", String.valueOf(minTimeout));
                this.roundTripTimedout = true;
                this.debugIt("EXECUTE_SET_ROUNDTRIP_TIMEOUT_AS_TRUE");
            }
        } else {
            this.setReadTimeout();
        }
    }

    public String getRequestPartnerName() {
        if (this.requestPartnerName != null) {
            return this.requestPartnerName;
        }
        String partner = this.headers.get("com.att.aft.dme2.partner");
        if (partner == null) {
            partner = this.headers.get("com.att.aft.dme2.jms.partner");
        }
        if (partner == null) {
            partner = this.requestContext.getRequest().getClientHeaders().get("DME2_REQUEST_PARTNER");
        }
        this.requestPartnerName = partner;
        return partner;
    }

    private long getRoundTripTimeout() {
        String jmsPropertyRTTimeout = this.headers.get(AFT_DME2_ROUNDTRIP_TIMEOUT_MS);
        long timeout = 0L;
        if (jmsPropertyRTTimeout != null) {
            try {
                timeout = Long.parseLong(jmsPropertyRTTimeout);
            }
            catch (Exception e) {
                timeout = this.config.getLong(AFT_DME2_ROUNDTRIP_TIMEOUT_MS);
            }
            this.roundTripTimeoutString = "JMSHeader-AFT_DME2_ROUNDTRIP_TIMEOUT_MS=" + timeout;
        } else if (this.exchangeRoundTripTimeOut > 0L) {
            this.roundTripTimeoutString = "URIQueryString-roundTripTimeout=" + this.exchangeRoundTripTimeOut;
            timeout = this.exchangeRoundTripTimeOut;
        } else {
            timeout = this.config.getLong(AFT_DME2_ROUNDTRIP_TIMEOUT_MS);
            this.roundTripTimeoutString = "CFG-AFT_DME2_ROUNDTRIP_TIMEOUT_MS=" + timeout;
        }
        this.debugIt("EXECUTE_SET_ROUNDTRIP_TIMEOUT", this.roundTripTimeoutString);
        return timeout;
    }

    @Override
    public void onContent(Response response, ByteBuffer content) {
    }

    private byte[] mergeChunkData(ByteBuffer content) {
        ByteArrayOutputStream outputStream = null;
        try {
            outputStream = new ByteArrayOutputStream();
            if (this._responseContent != null && this._responseContent.length > 0) {
                outputStream.write(this._responseContent);
            }
            outputStream.write(BufferUtil.toArray(content));
            return outputStream.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public void onContent(Response response, ByteBuffer content, Callback callback) {
        logger.debug(null, "onContent", LogMessage.METHOD_ENTER);
        logger.debug((URI)null, "onContent", "!isReturnResponseAsBytes(): {}", (Object)(!this.isReturnResponseAsBytes() ? 1 : 0));
        if (!this.isReturnResponseAsBytes()) {
            logger.debug(null, "onContent", "Content1");
            String disableIngressResponseStream = this.config.getProperty("AFT_DME2_DISABLE_INGRESS_REPLY_STREAM");
            if (disableIngressResponseStream != null && disableIngressResponseStream.equalsIgnoreCase("true")) {
                this._responseContent = this.mergeChunkData(content);
            } else if (!(this.replyHandler instanceof DME2StreamReplyHandler)) {
                this._responseContent = this.mergeChunkData(content);
            }
        } else {
            logger.debug(null, "onContent", "Content2");
            if (response.getStatus() == 200) {
                if (this.responseStatus == -1) {
                    this.responseStatus = response.getStatus();
                    this.requestHeaders = this.convertRequestHeadersAsMap(response.getRequest().getHeaders());
                    this.responseHeaders = this.convertResponseHeadersAsMap(response.getHeaders());
                }
                byte[] bytes = new byte[content.remaining()];
                content.get(bytes);
                if (this.responseHandler instanceof DME2StreamReplyHandler) {
                    ((DME2StreamReplyHandler)this.responseHandler).handleContent(bytes, this.responseStatus, this.requestHeaders, this.responseHeaders);
                }
            } else {
                this._responseContent = BufferUtil.toArray(content);
            }
        }
        callback.succeeded();
    }

    private boolean isFailoverResponseCode(int responseStatus, boolean isRestfulCall) {
        if (!this.config.getBoolean("AFT_DME2_LOOKUP_NON_FAILOVER_SC")) {
            logger.debug((URI)null, "isFailoverResponseCode", "{}:false", (Object)"AFT_DME2_LOOKUP_NON_FAILOVER_SC");
            return false;
        }
        String scCodes = this.getNonFailoverStatusCodes(isRestfulCall);
        if (scCodes != null) {
            String[] scCodesArr = scCodes.split(",");
            String rs = responseStatus + "";
            for (int i = 0; i < scCodesArr.length; ++i) {
                String sc = scCodesArr[i].trim();
                if (sc.equalsIgnoreCase(rs)) {
                    return false;
                }
                if (!sc.contains("-")) continue;
                try {
                    String[] range = sc.split("-");
                    int low = Integer.parseInt(range[0]);
                    int high = Integer.parseInt(range[1]);
                    if (low <= responseStatus && responseStatus <= high) {
                        return false;
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return true;
    }

    private String getNonFailoverStatusCodes(boolean isRestfulCall) {
        String nonFailoverStatusCodes = this.headers.get("AFT_DME2_NON_FAILOVER_HTTP_SCS");
        if (nonFailoverStatusCodes != null) {
            logger.debug((URI)null, "getSuccessStatusCodes", "{}:{}", (Object)"AFT_DME2_NON_FAILOVER_HTTP_SCS_HEADER", (Object)nonFailoverStatusCodes);
            return nonFailoverStatusCodes;
        }
        if (this.getNonFailoverStatusCodesParam() != null) {
            logger.debug((URI)null, "getSuccessStatusCodes", "{}:{}", (Object)"AFT_DME2_NON_FAILOVER_HTTP_SCS_QUERYPARAM", (Object)this.getNonFailoverStatusCodesParam());
            return this.getNonFailoverStatusCodesParam();
        }
        if (isRestfulCall) {
            nonFailoverStatusCodes = this.config.getProperty("AFT_DME2_NON_FAILOVER_HTTP_REST_SCS");
            logger.debug((URI)null, "getNonFailoverStatusCodes", "{}:{}", (Object)"AFT_DME2_NON_FAILOVER_HTTP_SCS_DEFAULT(REST)", (Object)nonFailoverStatusCodes);
        } else {
            nonFailoverStatusCodes = this.config.getProperty("AFT_DME2_NON_FAILOVER_HTTP_SCS");
            logger.debug((URI)null, "getSuccessStatusCodes", "{}:{}", (Object)"AFT_DME2_NON_FAILOVER_HTTP_SCS_DEFAULT", (Object)nonFailoverStatusCodes);
        }
        return nonFailoverStatusCodes;
    }

    public String getNonFailoverStatusCodesParam() {
        return this.nonFailoverStatusCodesParam;
    }

    public void setNonFailoverStatusCodesParam(String nonFailoverStatusCodesParam) {
        this.nonFailoverStatusCodesParam = nonFailoverStatusCodesParam;
    }

    public Boolean getAllowAllHttpReturnCodes() {
        return this.allowAllHttpReturnCodes;
    }

    public void setAllowAllHttpReturnCodes(Boolean allowAllHttpReturnCodes) {
        this.allowAllHttpReturnCodes = allowAllHttpReturnCodes;
    }

    private boolean invokeReplyHandlersEndPointFault(int responseCode, String cOffer, String requestUrl, HttpFields responseHeaders, HttpFields requestHeaders, Throwable e) {
        if (!this.config.getBoolean("AFT_DME2_ALLOW_INVOKE_HANDLERS")) {
            return false;
        }
        this.currentEndpointReference = this.iterator.getCurrentEndpointReference();
        String[] replyHandlers = this.getAllExchangeReplyHandlers();
        if (replyHandlers != null) {
            String routeOffer = null;
            String version = null;
            if (this.currentEndpointReference != null && this.currentEndpointReference.getEndpoint() != null) {
                routeOffer = this.currentEndpointReference.getEndpoint().getRouteOffer();
                version = this.currentEndpointReference.getEndpoint().getServiceVersion();
            }
            DME2ExchangeFaultContext ctxData = new DME2ExchangeFaultContext(this.lookupURI, responseCode, this.convertRequestHeadersAsMap(requestHeaders), routeOffer, version, this.lookupURI, e);
            logger.debug(null, "invokeReplyHandlersEndPointFault", "ResponseCode={};routeOffer={}{}{}", responseCode, routeOffer, REQUESTURL, requestUrl);
            for (int i = 0; i < replyHandlers.length; ++i) {
                long start = System.currentTimeMillis();
                String handlerName = replyHandlers[i];
                try {
                    Object handler;
                    Object obj = DME2Utils.loadClass(this.config, this.getURL(), handlerName);
                    if (obj instanceof DME2ExchangeReplyHandler) {
                        handler = (DME2ExchangeReplyHandler)obj;
                        handler.handleEndpointFault(ctxData);
                        logger.debug(null, "invokeReplyHandlersEndPointFault" + handlerName, LogMessage.EXCH_INVOKE_HANDLER);
                        continue;
                    }
                    if (!(obj instanceof DME2FailoverFaultHandler)) continue;
                    handler = (DME2FailoverFaultHandler)obj;
                    handler.handleEndpointFailover(ctxData);
                    logger.debug(null, "handleEndpointFailover" + handlerName, LogMessage.EXCH_INVOKE_HANDLER);
                    continue;
                }
                catch (Throwable e1) {
                    logger.warn((URI)null, handlerName, "handleEndpointFault" + LogMessage.EXCH_INVOKE_FAIL, (Object)e1);
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean invokeReplyHandlersFault(int responseCode, String cOffer, String requestUrl, HttpFields responseHeaders, HttpFields requestHeaders, Throwable e) {
        if (!this.config.getBoolean("AFT_DME2_ALLOW_INVOKE_HANDLERS")) {
            return false;
        }
        String[] replyHandlers = this.getExchangeReplyHandlers();
        if (replyHandlers != null) {
            String routeOffer = null;
            String version = null;
            if (this.currentEndpointReference != null && this.currentEndpointReference.getEndpoint() != null) {
                routeOffer = this.currentEndpointReference.getEndpoint().getRouteOffer();
                version = this.currentEndpointReference.getEndpoint().getServiceVersion();
            }
            DME2ExchangeFaultContext ctxData = new DME2ExchangeFaultContext(this.lookupURI, responseCode, this.convertRequestHeadersAsMap(requestHeaders), routeOffer, version, requestUrl, e);
            logger.debug(null, "invokeReplyHandlersFault", "ResponseCode={};routeOffer={}{}{}", responseCode, routeOffer, REQUESTURL, requestUrl);
            long start = System.currentTimeMillis();
            for (int i = 0; i < replyHandlers.length; ++i) {
                String handlerName = replyHandlers[i];
                try {
                    Object obj = DME2Utils.loadClass(this.config, this.getURL(), handlerName);
                    if (!(obj instanceof DME2ExchangeReplyHandler)) continue;
                    DME2ExchangeReplyHandler handler = (DME2ExchangeReplyHandler)obj;
                    handler.handleFault(ctxData);
                    logger.debug(null, "invokeReplyHandlersFault", LogMessage.EXCH_INVOKE_HANDLER, "handleFault", handlerName, System.currentTimeMillis() - start);
                    continue;
                }
                catch (Throwable e1) {
                    logger.warn(null, "invokeReplyHandlersFault", LogMessage.EXCH_INVOKE_FAIL, "handleFault", handlerName, e1);
                }
            }
        } else {
            return false;
        }
        return true;
    }

    private boolean invokeReplyHandlers(int responseCode, String cOffer, String requestUrl, HttpFields responseHeaders, HttpFields requestHeaders) {
        if (!this.config.getBoolean("AFT_DME2_ALLOW_INVOKE_HANDLERS")) {
            return false;
        }
        String[] replyHandlers = this.getExchangeReplyHandlers();
        if (replyHandlers != null) {
            String version = null;
            String routeOffer = null;
            if (this.currentEndpointReference != null && this.currentEndpointReference.getEndpoint() != null) {
                routeOffer = this.currentEndpointReference.getEndpoint().getRouteOffer();
                version = this.currentEndpointReference.getEndpoint().getServiceVersion();
            }
            DME2ExchangeResponseContext ctxData = new DME2ExchangeResponseContext(this.lookupURI, responseCode, this.convertRequestHeadersAsMap(requestHeaders), this.convertResponseHeadersAsMap(responseHeaders), routeOffer, version, requestUrl);
            logger.debug(null, "invokeReplyHandlers", "ResponseCode={};routeOffer={};version={}{}{}", responseCode, routeOffer, version, REQUESTURL, requestUrl);
            long start = System.currentTimeMillis();
            for (int i = 0; i < replyHandlers.length; ++i) {
                String handlerName = replyHandlers[i];
                try {
                    Object obj = DME2Utils.loadClass(this.config, this.getURL(), handlerName);
                    if (!(obj instanceof DME2ExchangeReplyHandler)) continue;
                    DME2ExchangeReplyHandler handler = (DME2ExchangeReplyHandler)obj;
                    handler.handleReply(ctxData);
                    this.replyHandlersInvoked = true;
                    logger.debug(null, "invokeReplyHandlers", LogMessage.EXCH_INVOKE_HANDLER, "handleReply", handlerName, System.currentTimeMillis() - start);
                    this.debugIt(handlerName, "handleResponse invoked");
                    continue;
                }
                catch (Throwable e) {
                    logger.warn(null, "invokeReplyHandlers", LogMessage.EXCH_INVOKE_FAIL, "handleReply", handlerName, e);
                }
            }
            if (this.replyHandlersInvoked) {
                this.replyHandlersElapsedTime = System.currentTimeMillis() - start;
            }
        } else {
            return false;
        }
        return true;
    }

    private FailoverHandler loadFailoverHandler() throws DME2Exception {
        FailoverHandler failoverHandler = FailoverFactory.getFailoverHandler(this.config);
        return failoverHandler;
    }

    private void parseFaultResponse(FailoverHandler handler, int responseStatus, String responseContent, byte[] responseContentBytes, long executeComplete, Result result) throws Exception {
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.buildResponseObject(result);
        HttpFields responseHeaders = result.getResponse().getHeaders();
        HttpFields requestHeaders = result.getRequest().getHeaders();
        boolean isFailoverRequired = handler.isFailoverRequired(httpResponse);
        if (!isFailoverRequired) {
            this.addTraceInfoToResponseHeaders();
            boolean repHandlersInvoked = this.invokeReplyHandlers(responseStatus, this.iterator.getCurrentDME2EndpointRouteOffer(), this.getURL(), result.getResponse().getHeaders(), result.getRequest().getHeaders());
            if (repHandlersInvoked || this.requestHandlersInvoked) {
                logger.debug(null, "parseFaultResponse", LogMessage.EXCH_RECEIVE_HANDLERS, this.getURL(), responseStatus, executeComplete - this.sendStart, executeComplete - this.executeStart, this.preferredRouteOffer, this.preferredVersion, this.requestHandlersInvoked ? Long.valueOf(this.requestHandlersElapsedTime) : "", repHandlersInvoked ? Long.valueOf(this.replyHandlersElapsedTime) : "", responseContentBytes.length);
            } else {
                logger.debug(null, "parseFaultResponse", LogMessage.EXCH_RECEIVE, this.getURL(), responseStatus, executeComplete - this.sendStart, executeComplete - this.executeStart, responseContentBytes == null ? 0 : responseContentBytes.length);
            }
            if (responseContentBytes != null) {
                this.handleReply(responseStatus, responseContent, new ByteArrayInputStream(responseContentBytes), this.convertRequestHeadersAsMap(requestHeaders), this.convertResponseHeadersAsMap(responseHeaders));
            } else {
                if (this.payloadObj instanceof DME2StreamPayload) {
                    DME2Exception dme2Exception = new DME2Exception("AFT-DME2-0717", new ErrorContext().add(SERVICE, this.lookupURI).add(SERVERURL, this.getURL()).add(ENDPOINT_ELAPSED_MS, executeComplete - this.sendStart + ""), this.exception);
                    Map<String, String> lheaders = this.convertResponseHeadersAsMap(responseHeaders);
                    this.handleException(lheaders, dme2Exception);
                    return;
                }
                this.handleReply(responseStatus, responseContent, null, this.convertRequestHeadersAsMap(requestHeaders), this.convertResponseHeadersAsMap(responseHeaders));
            }
        } else {
            this.doTry(result.getResponse());
        }
    }

    private void handleReply(int code, String message, InputStream in, Map<String, String> requestHeaders, Map<String, String> responseHeaders) {
        try {
            this.replyHandler.handleReply(code, message, in, requestHeaders, responseHeaders);
        }
        catch (Exception e) {
            logger.warn(null, "handleReply", LogMessage.EXCH_HANDLER_FAIL, "reply", this.replyHandler, e);
        }
    }

    public boolean isReturnResponseAsBytes() {
        return this.returnResponseAsBytes;
    }

    public void setReturnResponseAsBytes(boolean returnResponseAsBytes) {
        this.returnResponseAsBytes = returnResponseAsBytes;
    }

    public DME2Configuration getConfig() {
        return this.config;
    }

    public void setConfig(DME2Configuration config) {
        this.config = config;
    }

    public DME2BaseEndpointIterator getIterator() {
        return this.iterator;
    }

    public void setIterator(DME2BaseEndpointIterator iterator) {
        this.iterator = iterator;
    }

    public DME2EndpointReference getCurrentEndpointReference() {
        return this.currentEndpointReference;
    }

    public void setCurrentEndpointReference(DME2EndpointReference currentEndpointReference) {
        this.currentEndpointReference = currentEndpointReference;
    }

    public boolean isMarkStale() {
        return this.markStale;
    }

    public void setMarkStale(boolean markStale) {
        this.markStale = markStale;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public String getCorrelationID() {
        return this.correlationID;
    }

    public void setCorrelationID(String correlationID) {
        this.correlationID = correlationID;
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public boolean isCheckResponseContent() {
        return this.checkResponseContent;
    }

    public void setCheckResponseContent(boolean checkResponseContent) {
        this.checkResponseContent = checkResponseContent;
    }

    public int getiGNORECONTENTLENGTHVALUE() {
        return this.iGNORECONTENTLENGTHVALUE;
    }

    public void setiGNORECONTENTLENGTHVALUE(int iGNORECONTENTLENGTHVALUE) {
        this.iGNORECONTENTLENGTHVALUE = iGNORECONTENTLENGTHVALUE;
    }

    public String getiGNORECONTENTTYPEVALUE() {
        return this.iGNORECONTENTTYPEVALUE;
    }

    public void setiGNORECONTENTTYPEVALUE(String iGNORECONTENTTYPEVALUE) {
        this.iGNORECONTENTTYPEVALUE = iGNORECONTENTTYPEVALUE;
    }

    public boolean isRetryCurrentURL() {
        return this.retryCurrentURL;
    }

    public void setRetryCurrentURL(boolean retryCurrentURL) {
        this.retryCurrentURL = retryCurrentURL;
    }

    public boolean isIgnoreFailoverOnExpire() {
        String jmsPropertyIgnoreFailoverOnExpire = this.headers.get("com.att.aft.dme2.jms.ignoreFailOverOnExpire");
        if (jmsPropertyIgnoreFailoverOnExpire != null) {
            try {
                this.isIgnoreFailoverOnExpire = Boolean.parseBoolean(jmsPropertyIgnoreFailoverOnExpire);
            }
            catch (Exception e) {
                this.isIgnoreFailoverOnExpire = this.config.getBoolean("AFT_DME2_IGNORE_FAILOVER_ONEXPIRE", false);
            }
        }
        this.debugIt("IS_IGNORE_FAILOVER_ONEXPIRE:", String.valueOf(this.isIgnoreFailoverOnExpire));
        return this.isIgnoreFailoverOnExpire;
    }

    public void setIgnoreFailoverOnExpire(boolean isIgnoreFailoverOnExpire) {
        this.isIgnoreFailoverOnExpire = isIgnoreFailoverOnExpire;
    }

    public static Set<String> getGlobalNoticeCache() {
        return globalNoticeCache;
    }

    public static void setGlobalNoticeCache(Set<String> globalNoticeCache) {
        DME2Exchange.globalNoticeCache = globalNoticeCache;
    }

    public boolean isSuccessAlready() {
        return this.successAlready;
    }

    public void setSuccessAlready(boolean successAlready) {
        this.successAlready = successAlready;
    }

    public boolean isRequestHandlersInvoked() {
        return this.requestHandlersInvoked;
    }

    public void setRequestHandlersInvoked(boolean requestHandlersInvoked) {
        this.requestHandlersInvoked = requestHandlersInvoked;
    }

    public long getRequestHandlersElapsedTime() {
        return this.requestHandlersElapsedTime;
    }

    public void setRequestHandlersElapsedTime(long requestHandlersElapsedTime) {
        this.requestHandlersElapsedTime = requestHandlersElapsedTime;
    }

    public String getPreferredRouteOffer() {
        return this.preferredRouteOffer;
    }

    public void setPreferredRouteOffer(String preferredRouteOffer) {
        this.preferredRouteOffer = preferredRouteOffer;
    }

    public boolean isReplyHandlersInvoked() {
        return this.replyHandlersInvoked;
    }

    public void setReplyHandlersInvoked(boolean replyHandlersInvoked) {
        this.replyHandlersInvoked = replyHandlersInvoked;
    }

    public long getExecuteStart() {
        return this.executeStart;
    }

    public void setExecuteStart(long executeStart) {
        this.executeStart = executeStart;
    }

    public String getLookupURI() {
        return this.lookupURI;
    }

    public void setLookupURI(String lookupURI) {
        this.lookupURI = lookupURI;
    }

    public long getReplyHandlersElapsedTime() {
        return this.replyHandlersElapsedTime;
    }

    public void setReplyHandlersElapsedTime(long replyHandlersElapsedTime) {
        this.replyHandlersElapsedTime = replyHandlersElapsedTime;
    }

    public String getCurrentFinalUrl() {
        return this.currentFinalUrl;
    }

    public void setCurrentFinalUrl(String currentFinalUrl) {
        this.currentFinalUrl = currentFinalUrl;
    }

    public boolean isSendTraceInfo() {
        return this.sendTraceInfo;
    }

    public void setSendTraceInfo(boolean sendTraceInfo) {
        this.sendTraceInfo = sendTraceInfo;
    }

    public long getSendStart() {
        return this.sendStart;
    }

    public void setSendStart(long sendStart) {
        this.sendStart = sendStart;
    }

    public String getTrackingID() {
        return this.trackingID;
    }

    public void setTrackingID(String trackingID) {
        this.trackingID = trackingID;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public void setResponseStatus(int responseStatus) {
        this.responseStatus = responseStatus;
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public void setRequestHeaders(Map<String, String> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public void setResponseHeaders(Map<String, String> responseHeaders) {
        this.responseHeaders = responseHeaders;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public DME2Payload getPayloadObj() {
        return this.payloadObj;
    }

    public void setPayloadObj(DME2Payload payloadObj) {
        this.payloadObj = payloadObj;
    }

    public AsyncResponseHandlerIntf getResponseHandler() {
        return this.responseHandler;
    }

    public void setResponseHandler(AsyncResponseHandlerIntf responseHandler) {
        this.responseHandler = responseHandler;
    }

    public DME2Manager getManager() {
        return this.manager;
    }

    public void setManager(DME2Manager manager) {
        this.manager = manager;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
        this.currentFinalUrl = url;
    }

    public void setLookupUrl(String lookupURI) {
        this.lookupURI = this.stripQueryParamsFromURIString(lookupURI);
        this.currentFinalUrl = lookupURI;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getMaxRecursiveCounter() {
        return this.maxRecursiveCounter;
    }

    public void setMaxRecursiveCounter(int maxRecursiveCounter) {
        this.maxRecursiveCounter = maxRecursiveCounter;
    }

    public String getHostFromArgs() {
        return this.hostFromArgs;
    }

    public void setHostFromArgs(String hostFromArgs) {
        this.hostFromArgs = hostFromArgs;
    }

    public boolean istRACEON() {
        return this.tRACEON;
    }

    public void settRACEON(boolean tRACEON) {
        this.tRACEON = tRACEON;
    }

    public long getPerEndpointTimeout() {
        return this.perEndpointTimeout;
    }

    public void setPerEndpointTimeout(long perEndpointTimeout) {
        this.perEndpointTimeout = perEndpointTimeout;
    }

    public String getMultiPartFile() {
        return this.multiPartFile;
    }

    public void setMultiPartFile(String multiPartFile) {
        this.multiPartFile = multiPartFile;
    }

    public String getMultiPartFileName() {
        return this.multiPartFileName;
    }

    public void setMultiPartFileName(String multiPartFileName) {
        this.multiPartFileName = multiPartFileName;
    }

    public Boolean getCheckThrottleResponseContent() {
        return this.checkThrottleResponseContent;
    }

    public void setCheckThrottleResponseContent(Boolean checkThrottleResponseContent) {
        this.checkThrottleResponseContent = checkThrottleResponseContent;
    }

    public StringBuffer getEpTraceRoute() {
        return this.epTraceRoute;
    }

    public static String getEp() {
        return EP;
    }

    public static String getAftDmeReqTraceInfo() {
        return AFT_DME2_REQ_TRACE_INFO;
    }

    public static String getEpreferences() {
        return EPREFERENCES;
    }

    public static String getAftDme20702() {
        return AFT_DME2_0702;
    }

    public static String getAftDme20710() {
        return AFT_DME2_0710;
    }

    public static String getEndpointElapsedMs() {
        return ENDPOINT_ELAPSED_MS;
    }

    public static String getAftDme2EpReadTimeoutMs() {
        return AFT_DME2_EP_READ_TIMEOUT_MS;
    }

    public static String getAftDme20712() {
        return AFT_DME2_0712;
    }

    public static String getCharSet() {
        return CHAR_SET;
    }

    public static String getAftDme20715() {
        return AFT_DME2_0715;
    }

    public int getRecursiveCounter() {
        return 0;
    }

    public HttpFields getResponseFields() {
        return this.responseFields;
    }

    public List<String> getMultiPartFiles() {
        return this.multiPartFiles;
    }

    public List<DME2FileUploadInfo> getFileUploadInfoList() {
        return this.fileUploadInfoList;
    }

    private String generateUniqueTransactionReference() {
        StringBuffer uniqueReference = new StringBuffer();
        uniqueReference.append(this.hashCode());
        uniqueReference.append("-");
        uniqueReference.append(UUID.randomUUID().toString());
        return uniqueReference.toString();
    }

    private void debugIt(String key, String i) {
        if (this.tRACEON) {
            this.debugIt(key + ":" + i);
        }
    }

    private void debugIt(String key, int i) {
        if (this.tRACEON) {
            this.debugIt(key + ":" + i);
        }
    }

    private void debugIt(String message) {
        if (this.tRACEON) {
            System.out.println("[" + new Date() + "] - ThreadID:" + Thread.currentThread().getName() + " - ExchangeObjReference:" + this.hashCode() + "  {" + this.messageID + " - " + this.correlationID + "} - " + message);
        }
    }

    private void debugIt(String key, Exception e) {
        if (this.tRACEON) {
            this.debugIt(key, e.toString());
        }
    }

    private String constructDME2ServiceStatsURI(String lookupURI) {
        if (this.requestContext.getUniformResource().getUrlType() == DmeUniformResource.DmeUrlType.STANDARD) {
            String returnString = this.requestContext.getUniformResource().getOriginalURL().getProtocol() + "://" + this.requestContext.getUniformResource().getHost() + (this.currentEndpointReference.getEndpoint().getContextPath().startsWith("/") ? "" : "/") + this.currentEndpointReference.getEndpoint().getContextPath() + "?version=" + this.requestContext.getUniformResource().getVersion() + "&envcontext=" + this.requestContext.getUniformResource().getEnvContext();
            returnString = null != this.requestContext.getUniformResource().getRouteOffer() ? returnString + "&routeoffer=" + this.requestContext.getUniformResource().getRouteOffer() : returnString + "&partner=" + this.requestContext.getUniformResource().getPartner();
            return returnString;
        }
        return lookupURI;
    }
}

