/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api.http;

import com.att.aft.dme2.api.ActionType;
import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.RequestInvokerIntf;
import com.att.aft.dme2.api.SimpleRealm;
import com.att.aft.dme2.api.http.DME2Exchange;
import com.att.aft.dme2.api.http.DmeBasicAuthentication;
import com.att.aft.dme2.api.http.MessageHeaderUtils;
import com.att.aft.dme2.api.util.DME2DateFormatAccess;
import com.att.aft.dme2.api.util.DME2DateTimeFormatUtil;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.handler.DefaultNullAsyncResponseHandler;
import com.att.aft.dme2.internal.apache.commons.lang.StringUtils;
import com.att.aft.dme2.internal.google.common.collect.Maps;
import com.att.aft.dme2.internal.jetty.client.HttpClient;
import com.att.aft.dme2.internal.jetty.client.api.Request;
import com.att.aft.dme2.internal.jetty.client.util.ByteBufferContentProvider;
import com.att.aft.dme2.internal.jetty.client.util.InputStreamContentProvider;
import com.att.aft.dme2.internal.jetty.http.HttpField;
import com.att.aft.dme2.internal.jetty.http.HttpHeader;
import com.att.aft.dme2.internal.jetty.http.HttpMethod;
import com.att.aft.dme2.internal.jetty.util.B64Code;
import com.att.aft.dme2.iterator.service.DME2BaseEndpointIterator;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.request.BinaryPayload;
import com.att.aft.dme2.request.DME2Payload;
import com.att.aft.dme2.request.DME2StreamPayload;
import com.att.aft.dme2.request.DME2TextPayload;
import com.att.aft.dme2.request.FilePayload;
import com.att.aft.dme2.request.HttpRequest;
import com.att.aft.dme2.request.RequestContext;
import com.att.aft.dme2.util.ErrorContext;
import com.att.aft.dme2.util.InternalConnectionFailedException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.zip.GZIPOutputStream;

public class HttpRequestInvoker
implements RequestInvokerIntf {
    public static final String AFT_DME2_0712 = "AFT-DME2-0712";
    private static final String AFT_DME2_0715 = "AFT-DME2-0715";
    public static final String INPUTFILE = "inputFile";
    public static final String HANDLER_NAME = "handlerName";
    public static final String contentDispositionHeaderName = "Content-Disposition: form-data; name=\"";
    public static final String contentDispositionHeaderFile = "\"; filename=\"";
    public static final String SERVICE = "service";
    private DME2Exchange exchange;
    public static final String CHAR_SET = "; charset=";
    private static final Logger logger = LoggerFactory.getLogger(HttpRequestInvoker.class.getName());
    private static HttpClient client = null;
    private static final DefaultNullAsyncResponseHandler NULL_REPLY_HANDLER = new DefaultNullAsyncResponseHandler();
    private DME2Configuration config;
    private DME2DateFormatAccess dformat;

    public HttpRequestInvoker(RequestContext context) {
        this.config = context.getMgr().getConfig();
    }

    @Override
    public void createExchange(String resolvedUrl, RequestContext context, DME2BaseEndpointIterator iterator) throws DME2Exception {
        try {
            this.exchange = new DME2Exchange(context.getMgr(), resolvedUrl, context.getRequest().getReadTimeout(), context.getRequest().getCharset(), context.getRequest().getClientHeaders());
            this.exchange.setIterator(iterator);
            this.exchange.setRequestContext(context);
            this.exchange.setReturnResponseAsBytes(context.getRequest().isReturnResponseAsBytes());
            if (context.getRequest().getUniformResource() == null) {
                throw new DME2Exception("AFT-DME2-0016", "Invalid DmeUniformResource object", new Object[0]);
            }
            this.exchange.setExchangeRoundTripTimeOut(context.getRequest().getUniformResource().getRoundTripTimeout());
            if (context.getRequest().getUniformResource().isIgnoreFailoverOnExpire()) {
                this.exchange.setIgnoreFailoverOnExpire(true);
            }
            this.exchange.setPreferLocalEPs(context.getRequest().getUniformResource().isPreferLocalEPs());
            this.dformat = new DME2DateFormatAccess(context.getMgr().getConfig());
        }
        catch (DME2Exception e) {
            logger.error(null, "createExchange", e.getMessage());
            throw new DME2Exception("AFT-DME2-0007", e.getMessage(), new Object[0]);
        }
    }

    private void copyClientHeaders(HttpRequest request) {
        logger.info(null, "copyClientHeaders", "start");
        if (request != null && request.getClientHeaders() != null) {
            logger.info(null, "copyClientHeaders", "found headers to copy");
            if (request.getClientHeaders() == null) {
                request.setHeaders(new HashMap<String, String>());
            }
            for (Map.Entry<String, String> entry : request.getClientHeaders().entrySet()) {
                if (entry == null || entry.getKey() == null || entry.getValue() == null || request.getClientHeaders() == null) continue;
                logger.info((URI)null, "copyClientHeaders", "copied header: {}={}", (Object)entry.getKey(), (Object)entry.getValue());
                request.getClientHeaders().put(entry.getKey(), entry.getValue());
            }
        }
        logger.info(null, "copyClientHeaders", "complete");
    }

    @Override
    public void init(RequestContext context, ActionType action, DME2Payload payload) throws DME2Exception {
        HttpRequest request = (HttpRequest)context.getRequest();
        if (context.getRequest().getRealm() != null) {
            try {
                DmeBasicAuthentication dmeBasicAuthentication = new DmeBasicAuthentication(context.getRequest().getRealm());
            }
            catch (IOException e) {
                throw new DME2Exception("AFT-DME2-0997", "Error occured while establishing authentication.", (Throwable)e);
            }
        }
        if (request.getResponseHandler() == null) {
            logger.debug(context.getLogContext().getConversationId(), null, "", "NO_REPLY_HANDLER_SET");
            request.setResponseHandler(NULL_REPLY_HANDLER);
        } else if (request.getClientHeaders() == null || request.getClientHeaders().get("JMSReplyTo") == null) {
            logger.debug(context.getLogContext().getConversationId(), null, "", "NO_JMS_REPLY_TO_SET");
            request.getClientHeaders().put("JMSReplyTo", "http://DME2LOCAL/" + UUID.randomUUID().toString());
        }
        if (request.getClientHeaders() == null || request.getClientHeaders().get("JMSMessageID") == null) {
            if (request.getClientHeaders() == null) {
                request.setHeaders(new HashMap<String, String>());
            }
            request.getClientHeaders().put("JMSMessageID", "ID:" + UUID.randomUUID().toString());
            if (request.getUniformResource().getPartner() != null) {
                request.getClientHeaders().put("com.att.aft.dme2.partner", request.getUniformResource().getPartner());
                request.getClientHeaders().put("DME2_REQUEST_PARTNER", request.getUniformResource().getPartner());
            } else if (request.getPartner() != null) {
                request.getClientHeaders().put("com.att.aft.dme2.partner", request.getPartner());
                request.getClientHeaders().put("DME2_REQUEST_PARTNER", request.getPartner());
            }
        } else if (request.getUniformResource().getPartner() != null) {
            request.getClientHeaders().put("com.att.aft.dme2.partner", request.getUniformResource().getPartner());
            request.getClientHeaders().put("DME2_REQUEST_PARTNER", request.getUniformResource().getPartner());
        } else if (request.getPartner() != null) {
            request.getClientHeaders().put("com.att.aft.dme2.jms.partner", request.getPartner());
            request.getClientHeaders().put("DME2_JMS_REQUEST_PARTNER", request.getPartner());
        }
        MessageHeaderUtils.addHeaderPrefix(this.config, request);
    }

    private long getReadTimeout(HttpRequest request) {
        long readTimeoutMs = request.getPerEndpointTimeoutMs();
        logger.debug((URI)null, "getReadTimeout", "Request getPerEndpointTimoutMs: {}", (Object)readTimeoutMs);
        if (readTimeoutMs == 0L) {
            readTimeoutMs = request.getReadTimeout();
            logger.debug((URI)null, "getReadTimeout", "Request getReadTimeout: {}", (Object)readTimeoutMs);
        }
        if (readTimeoutMs == 0L) {
            readTimeoutMs = this.config.getLong("AFT_DME2_EP_READ_TIMEOUT_MS");
            logger.debug((URI)null, "getReadTimeout", "Config value for {}: {}", (Object)"AFT_DME2_EP_READ_TIMEOUT_MS", (Object)readTimeoutMs);
        }
        return readTimeoutMs;
    }

    @Override
    public void execute(ActionType action, RequestContext context, DME2Payload payload) throws InternalConnectionFailedException, DME2Exception {
        HttpRequest request = (HttpRequest)context.getRequest();
        long readtimeout = request.getReadTimeout();
        Map<String, String> httpFields = request.getClientHeaders();
        String headerTimeoutValue = httpFields.get("AFT_DME2_EP_READ_TIMEOUT_MS");
        if (StringUtils.isBlank(headerTimeoutValue)) {
            httpFields.put("AFT_DME2_EP_READ_TIMEOUT_MS", new Long(readtimeout).toString());
        }
        HttpClient client = context.getMgr().getClient();
        try {
            Request jettyRequest = client.newRequest(request.getLookupUri());
            jettyRequest.timeout(this.getReadTimeout(request), TimeUnit.MILLISECONDS);
            logger.debug((URI)null, "execute", "Set CONNECTION timeout to {}", (Object)this.getReadTimeout(request));
            this.populateHeaders(payload, context, jettyRequest);
            this.populatePayload(payload, context, jettyRequest);
            this.exchange.setLookupUrl(request.getLookupUri());
            if (context.getLogContext() != null) {
                this.exchange.setSendTraceInfo(context.getLogContext().isSendTraceInfo());
            }
            logger.debug((URI)null, "execute", "Exchange.getCurrentFinalUrl : {} request.getLookupUri: {} ", (Object)this.exchange.getCurrentFinalUrl(), (Object)request.getLookupUri());
            this.exchange.setExecuteStart(System.currentTimeMillis());
            this.exchange.setSendStart(System.currentTimeMillis());
            jettyRequest.send(this.exchange);
        }
        catch (DME2Exception e) {
            throw e;
        }
        catch (Exception e) {
            throw new DME2Exception("AFT-DME2-0000", e);
        }
    }

    private void populatePayload(DME2Payload payload, RequestContext context, Request jettyRequest) throws DME2Exception {
        if (payload != null) {
            this.exchange.setPayloadObj(payload);
            if (payload instanceof DME2TextPayload) {
                DME2TextPayload textPayload = (DME2TextPayload)payload;
                this.processTextPayload(context, textPayload, jettyRequest);
            } else if (payload instanceof DME2StreamPayload) {
                DME2StreamPayload streamPayload = (DME2StreamPayload)payload;
                this.processStreamPayload(context, streamPayload, jettyRequest);
            } else if (payload instanceof FilePayload) {
                FilePayload filePayload = (FilePayload)payload;
                this.processFilePayload(context, filePayload, jettyRequest);
            } else if (payload instanceof BinaryPayload) {
                BinaryPayload binaryPayload = (BinaryPayload)payload;
                jettyRequest.content(new InputStreamContentProvider(new ByteArrayInputStream(binaryPayload.getPayload())));
            }
        }
    }

    public void populateHeaders(DME2Payload payload, RequestContext context, Request jettyRequest) {
        Set<String> keySet;
        String contentType = payload.getContentType();
        String charset = context.getRequest().getCharset();
        String ctypeHeader = this.config.getProperty("AFT_DME2_CTYPE_HEADER");
        Map<String, String> headers = context.getRequest().getClientHeaders();
        Map<String, String> reqHeaders = context.getRequest().getClientHeaders();
        if (headers == null) {
            headers = Maps.newHashMap();
        }
        if (charset == null) {
            if (contentType != null) {
                headers.put(ctypeHeader, contentType);
            }
        } else if (contentType != null) {
            headers.put(ctypeHeader, contentType + CHAR_SET + charset);
        } else {
            headers.put(ctypeHeader, "text/plain; charset=" + charset);
        }
        if (context.getMgr().getConfig().getBoolean("AFT_DME2_SSL_ENABLE", Boolean.FALSE)) {
            jettyRequest.scheme("https");
        } else {
            jettyRequest.scheme("http");
        }
        jettyRequest.header(this.config.getProperty("AFT_DME2_CLIENT_SEND_TIMESTAMP_KEY", "AFT_DME2_CLIENT_REQ_SEND_TIMESTAMP"), DME2DateTimeFormatUtil.convertDateTimeToString(ZonedDateTime.now(), this.config));
        if ("GET".equalsIgnoreCase(((HttpRequest)context.getRequest()).getHttpMethod())) {
            jettyRequest.method(HttpMethod.GET);
        } else {
            jettyRequest.method(HttpMethod.POST);
        }
        SimpleRealm realm = context.getRequest().getRealm();
        if (realm != null && realm.getPrincipal() != null && realm.getCredentials() != null) {
            headers.put(HttpHeader.AUTHORIZATION.asString(), "Basic " + B64Code.encode(realm.getPrincipal() + ":" + realm.getCredentials(), "utf-8"));
        }
        if ((keySet = reqHeaders.keySet()) != null) {
            for (String key : keySet) {
                headers.put(key, reqHeaders.get(key));
            }
        }
        for (String key : headers.keySet()) {
            jettyRequest.header(key, headers.get(key));
        }
    }

    private void processFilePayload(RequestContext context, FilePayload payload, Request request) throws DME2Exception {
        List<String> uploadFiles = payload.getMultipartFileNamesWithPaths();
        if (payload.isMultipart() && uploadFiles != null && uploadFiles.size() > 0) {
            for (String fileInfo : uploadFiles) {
                File file = new File(fileInfo);
                if (file.exists()) continue;
                throw new DME2Exception("AFT-DME2-0720", new ErrorContext().add(SERVICE, context.getRequest().getUniformResource().getUrl().toString()).add("uploadfilepath", file.getPath()).add("uploadfilename", file.getName()));
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            String boundary = Long.toHexString(System.currentTimeMillis());
            Object byteBuffer = null;
            try {
                for (String fileName : uploadFiles) {
                    if (payload.isBinaryFile()) {
                        String requestStr = this.createMultiPartString(fileName, boundary, context.getRequest().getCharset(), payload.getMultiPartFileName());
                        byteArrayOutputStream.write(requestStr.getBytes());
                        continue;
                    }
                    byte[] requestBytes = this.createMultiPartBytes(fileName, boundary, context.getRequest().getCharset(), payload.getMultiPartFileName());
                    byteArrayOutputStream.write(requestBytes);
                }
                StringBuffer tail = new StringBuffer();
                tail.append("--").append(boundary).append("--").append(this.config.getProperty("AFT_DME2_CRLF"));
                tail.append(this.config.getProperty("AFT_DME2_CRLF"));
                byteArrayOutputStream.write(tail.toString().getBytes());
                ByteArrayInputStream contentStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                logger.debug((URI)null, "processFilePayload", "Config AFT_DME2_CLEN_HEADER: {}", (Object)this.config.getProperty("AFT_DME2_CLEN_HEADER"));
                logger.debug((URI)null, "processFilePayload", "Config AFT_DME2_CTYPE_HEADER: {}", (Object)this.config.getProperty("AFT_DME2_CTYPE_HEADER"));
                logger.debug((URI)null, "processFilePayload", "Config AFT_DME2_CLIENT_IGNORE_RESPONSE_CONTENT_TYPE: {}", (Object)this.config.getProperty("AFT_DME2_CLIENT_IGNORE_RESPONSE_CONTENT_TYPE"));
                request.getHeaders().add(new HttpField(this.config.getProperty("AFT_DME2_CLEN_HEADER"), String.valueOf(byteArrayOutputStream.toByteArray().length)));
                request.getHeaders().add(new HttpField(this.config.getProperty("AFT_DME2_CTYPE_HEADER"), "multipart/form-data;boundary=" + boundary));
                request.content(new InputStreamContentProvider(contentStream));
            }
            catch (Exception e) {
                this.handleException((HttpRequest)context.getRequest(), e);
            }
        } else {
            try {
                File file = new File(payload.getFileName());
                if (!file.exists()) {
                    throw new DME2Exception("AFT-DME2-0720", new ErrorContext().add(SERVICE, context.getRequest().getUniformResource().getUrl().toString()).add("uploadfilepath", file.getPath()).add("uploadfilename", file.getName()));
                }
                request.content(new InputStreamContentProvider(new FileInputStream(file)));
            }
            catch (Exception e) {
                this.handleException((HttpRequest)context.getRequest(), e);
            }
        }
    }

    private void processStreamPayload(RequestContext context, DME2StreamPayload payload, Request request) throws DME2Exception {
        request.content(new InputStreamContentProvider(payload.getPayload()));
    }

    private void processBinaryPayload(RequestContext context, BinaryPayload payload, Request request) throws DME2Exception {
        request.content(new ByteBufferContentProvider(ByteBuffer.wrap(payload.getPayload())), payload.getContentType());
    }

    private void processTextPayload(RequestContext context, DME2TextPayload payload, Request request) throws DME2Exception {
        String encodingType = request.getHeaders().get(this.config.getProperty("AFT_DME2_CONTENT_ENCODING_KEY"));
        if (encodingType != null && this.config.getBoolean("AFT_DME2_ALLOW_COMPRESS_ENCODING")) {
            try {
                GZIPOutputStream gzipOutputStream = null;
                ByteArrayOutputStream bos = null;
                bos = new ByteArrayOutputStream();
                gzipOutputStream = new GZIPOutputStream(bos);
                gzipOutputStream.write(payload.getPayload().getBytes());
                logger.debug((URI)null, "processTextPayload", "Inside Text Payload Process: {}", (Object)payload.getPayload());
                gzipOutputStream.close();
                request.content(new InputStreamContentProvider(new ByteArrayInputStream(bos.toByteArray())));
            }
            catch (IOException e) {
                throw new DME2Exception("AFT-DME2-0711", new ErrorContext().add(SERVICE, context.getRequest().getLookupUri()).add("AFT_DME2_CONTENT_ENCODING_KEY", encodingType));
            }
        }
        if (payload != null && payload.getPayload() != null) {
            String charset = context.getRequest().getCharset();
            if (charset == null) {
                request.content(new InputStreamContentProvider(new ByteArrayInputStream(payload.getPayload().getBytes())), payload.getContentType());
            } else {
                try {
                    request.content(new InputStreamContentProvider(new ByteArrayInputStream(payload.getPayload().getBytes(charset))));
                }
                catch (UnsupportedEncodingException e) {
                    throw new DME2Exception("AFT-DME2-0711", new ErrorContext().add(SERVICE, context.getRequest().getLookupUri()).add("AFT_DME2_CHARSET", charset));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createMultiPartString(String fileName, String boundary, String charset, String multiPartFileName) throws DME2Exception {
        StringBuffer writer = new StringBuffer();
        File textFile = new File(fileName);
        String name = textFile.getName();
        writer.append("--" + boundary).append(this.config.getProperty("AFT_DME2_CRLF"));
        if (multiPartFileName != null && multiPartFileName.trim().length() != 0) {
            writer.append(contentDispositionHeaderName + multiPartFileName + contentDispositionHeaderFile + textFile.getName() + "\"").append(this.config.getProperty("AFT_DME2_CRLF"));
        } else {
            writer.append(this.config.getProperty("AFT_DME2_CONTENT_DISP_HEADER") + textFile.getName() + "\"").append(this.config.getProperty("AFT_DME2_CRLF"));
        }
        if (charset == null) {
            writer.append(this.config.getProperty("AFT_DME2_CLIENT_IGNORE_RESPONSE_CONTENT_TYPE")).append(this.config.getProperty("AFT_DME2_CRLF")).append(this.config.getProperty("AFT_DME2_CRLF"));
        } else {
            writer.append(this.config.getProperty("AFT_DME2_CLIENT_IGNORE_RESPONSE_CONTENT_TYPE") + CHAR_SET + charset).append(this.config.getProperty("AFT_DME2_CRLF")).append(this.config.getProperty("AFT_DME2_CRLF"));
        }
        BufferedReader reader = null;
        try {
            try {
                String line;
                reader = charset == null ? new BufferedReader(new InputStreamReader(new FileInputStream(textFile))) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(textFile), charset));
                while ((line = reader.readLine()) != null) {
                    writer.append(line).append(this.config.getProperty("AFT_DME2_CRLF"));
                }
            }
            catch (IOException e) {
                if (this.config.getBoolean("DME2.DEBUG")) {
                    logger.error((URI)null, "createMultiPartString", AFT_DME2_0715, (Object)new ErrorContext().add("ServerURL", "???").add(INPUTFILE, textFile.getName()), (Object)e);
                }
                logger.debug((URI)null, "createMultiPartString", "ERROR_PARSING_INPUT_FILE_FOR_UPLOAD", (Object)e);
            }
        }
        finally {
            block17: {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException logOrIgnore) {
                        if (!this.config.getBoolean("DME2.DEBUG")) break block17;
                        logger.error((URI)null, "createMultiPartString", "AFT-DME2-0716", (Object)new ErrorContext().add("ServerURL", "???").add(INPUTFILE, textFile.getName()), (Object)logOrIgnore);
                    }
                }
            }
        }
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] createMultiPartBytes(String fileName, String boundary, String charset, String multiPartFileName) throws DME2Exception {
        StringBuffer header = new StringBuffer();
        File binaryFile = new File(fileName);
        String name = binaryFile.getName();
        header.append("--" + boundary).append(this.config.getProperty("AFT_DME2_CRLF"));
        if (multiPartFileName != null && multiPartFileName.trim().length() != 0) {
            header.append(contentDispositionHeaderName + multiPartFileName + contentDispositionHeaderFile + binaryFile.getName() + "\"").append(this.config.getProperty("AFT_DME2_CRLF"));
        } else {
            header.append(this.config.getProperty("AFT_DME2_CONTENT_DISP_HEADER") + binaryFile.getName() + "\"").append(this.config.getProperty("AFT_DME2_CRLF"));
        }
        if (charset == null) {
            header.append(this.config.getProperty("AFT_DME2_MULTIPART_TYPE")).append(this.config.getProperty("AFT_DME2_CRLF")).append(this.config.getProperty("AFT_DME2_CRLF"));
        } else {
            header.append(this.config.getProperty("AFT_DME2_MULTIPART_TYPE") + CHAR_SET + charset).append(this.config.getProperty("AFT_DME2_CRLF")).append(this.config.getProperty("AFT_DME2_CRLF"));
        }
        byte[] headerBytes = header.toString().getBytes();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        FileInputStream input = null;
        try {
            try {
                input = new FileInputStream(fileName);
                byte[] buffer = new byte[1024];
                int length = 0;
                while ((length = input.read(buffer)) > 0) {
                    bos.write(buffer, 0, length);
                }
                bos.write(this.config.getProperty("AFT_DME2_CRLF").getBytes());
                bos.flush();
                bos.close();
            }
            catch (IOException e) {
                if (this.config.getBoolean("DME2.DEBUG")) {
                    logger.error((URI)null, "createMultiPartBytes", AFT_DME2_0715, (Object)new ErrorContext().add("ServerURL", "???").add(INPUTFILE, binaryFile.getName()), (Object)e);
                }
                logger.debug((URI)null, "createMultiPartBytes", "ERROR_PARSING_INPUT_FILE_FOR_UPLOAD", (Object)e);
            }
        }
        finally {
            block20: {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException logOrIgnore) {
                        if (!this.config.getBoolean("DME2.DEBUG")) break block20;
                        logger.error((URI)null, "createMultiPartBytes", "AFT-DME2-0716", (Object)new ErrorContext().add("ServerURL", "???").add(INPUTFILE, binaryFile.getName()), (Object)logOrIgnore);
                    }
                }
            }
        }
        StringBuffer tail = new StringBuffer();
        ByteArrayOutputStream mpData = new ByteArrayOutputStream();
        try {
            mpData.write(headerBytes);
            mpData.write(bos.toByteArray());
            mpData.write(tail.toString().getBytes());
        }
        catch (IOException e) {
            if (this.config.getBoolean("DME2.DEBUG")) {
                logger.error((URI)null, "createMultiPartBytes", AFT_DME2_0715, (Object)new ErrorContext().add("ServerURL", "???").add(INPUTFILE, binaryFile.getName()), (Object)e);
            }
            logger.debug((URI)null, "createMultiPartBytes", "ERROR_BUILDING_MULTIPART_FOR_UPLOAD", (Object)e);
        }
        return mpData.toByteArray();
    }

    private void handleException(HttpRequest request, Throwable t) {
        try {
            this.exchange.getResponseHandler().handleException(request.getClientHeaders(), t);
        }
        catch (Exception e) {
            logger.warn((URI)null, Level.WARNING.getName(), LogMessage.EXCH_HANDLER_FAIL, (Object)e);
        }
    }
}

