/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api.http;

import com.att.aft.dme2.api.DME2Response;
import com.att.aft.dme2.internal.apache.commons.collections.MapUtils;
import com.att.aft.dme2.internal.jetty.client.api.Result;
import com.att.aft.dme2.internal.jetty.http.HttpFields;
import com.att.aft.dme2.request.DME2Payload;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class HttpResponse
extends DME2Response {
    private Map<String, String> responseHeaders = new HashMap<String, String>();
    private Integer respCode;
    private Map<String, String> respHeaders;

    @Override
    public String getReplyMessage() {
        return super.getReplyMessage();
    }

    @Override
    public void setReplyMessage(String replyMessage) {
        super.setReplyMessage(replyMessage);
    }

    @Override
    public Integer getRespCode() {
        return this.respCode;
    }

    @Override
    public void setRespCode(Integer respCode) {
        this.respCode = respCode;
    }

    @Override
    public Map<String, String> getRespHeaders() {
        return this.respHeaders;
    }

    @Override
    public void setRespHeaders(Map<String, String> respHeaders) {
        this.respHeaders = respHeaders;
    }

    public void buildResponseObject(Result result) {
        this.setReplyMessage(result.getResponse().toString());
        this.setRespCode(result.getResponse().getStatus());
        HttpFields httpFields = result.getResponse().getHeaders();
        Map<String, String> headersMap = this.convertResponseHeadersAsMap(httpFields);
        this.setRespHeaders(headersMap);
        this.respCode = result.getResponse().getStatus();
    }

    public Map<String, String> convertResponseHeadersAsMap(HttpFields httpFields) {
        HashMap<String, String> _headers = new HashMap<String, String>();
        if (httpFields == null) {
            return _headers;
        }
        Enumeration<String> e1 = httpFields.getFieldNames();
        while (e1.hasMoreElements()) {
            String key = e1.nextElement();
            _headers.put(key, httpFields.get(key));
        }
        if (MapUtils.isNotEmpty(this.responseHeaders)) {
            _headers.putAll(this.responseHeaders);
        }
        return _headers;
    }

    public void setPayLoad(DME2Payload payload) {
        this.payload = payload;
    }
}

