/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api.http;

import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.google.common.base.Splitter;
import com.att.aft.dme2.internal.jetty.client.HttpExchange;
import com.att.aft.dme2.internal.jetty.util.Fields;
import com.att.aft.dme2.request.HttpRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MessageHeaderUtils {
    public static void addHeaderPrefix(DME2Configuration config, HttpExchange exchange) {
        if (!config.getBoolean("DME2_OVERRIDE_HEADERS")) {
            return;
        }
        Fields requestField = exchange.getRequest().getParams();
        Set<String> names = requestField.getNames();
        ArrayList<String> keyList = new ArrayList<String>();
        for (String key : names) {
            keyList.add(key);
        }
        String key1 = null;
        Iterator it1 = keyList.iterator();
        while (it1.hasNext()) {
            if (key1 != null) {
                String value = requestField.get(key1).getValue();
                if (key1.startsWith("com.att.aft.DME2") || key1.startsWith("JMS")) {
                    exchange.getRequest().header(config.getProperty("DME2_HEADER_PREFIX") + key1, value);
                    requestField.remove(key1);
                }
            }
            key1 = (String)it1.next();
        }
    }

    public static void addHeaderPrefix(DME2Configuration config, HttpRequest request) {
        if (!config.getBoolean("DME2_OVERRIDE_HEADERS")) {
            return;
        }
        String queryParam = request.getQueryParams();
        if (queryParam != null) {
            Iterable<String> params = Splitter.on('&').trimResults().omitEmptyStrings().split(queryParam);
            HashMap<String, String> pMap = new HashMap<String, String>();
            for (String param : params) {
                List<String> keyValues = Splitter.on('=').trimResults().omitEmptyStrings().splitToList(queryParam);
                pMap.put(keyValues.get(0), keyValues.get(1));
            }
            for (String key : pMap.keySet()) {
                if (key == null) continue;
                String value = (String)pMap.get(key);
                if (!key.startsWith("com.att.aft.DME2") && !key.startsWith("JMS")) continue;
                request.getClientHeaders().put(config.getProperty("DME2_HEADER_PREFIX") + key, value);
                request.getClientHeaders().remove(key);
            }
        }
    }

    public static Map<String, String> removeHeaderPrefix(DME2Configuration config, Map<String, String> headers) {
        if (!config.getBoolean("DME2_OVERRIDE_HEADERS")) {
            return headers;
        }
        HashMap<String, String> modHeaders = new HashMap<String, String>();
        if (headers.keySet() != null) {
            for (String key : headers.keySet()) {
                if (key == null) continue;
                String value = headers.get(key);
                if (key.startsWith(config.getProperty("DME2_HEADER_PREFIX") + "com.att.aft.DME2") || key.startsWith(config.getProperty("DME2_HEADER_PREFIX") + "JMS")) {
                    String modKey = key.replace(config.getProperty("DME2_HEADER_PREFIX"), "");
                    modHeaders.put(modKey, value);
                    continue;
                }
                modHeaders.put(key, value);
            }
        }
        return modHeaders;
    }
}

