/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api.proxy;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.api.DME2ServiceHolder;
import com.att.aft.dme2.api.quick.QuickServer;
import com.att.aft.dme2.api.quick.QuickServletConfig;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.net.URI;
import java.util.Properties;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;

public class DME2IngressProxy {
    private static final Logger logger = LoggerFactory.getLogger(DME2IngressProxy.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws DME2Exception, InstantiationException, IllegalAccessException, ClassNotFoundException, ServletException {
        String skipExit = "false";
        try {
            try {
                String port = null;
                String env = null;
                for (int i = 0; i < args.length; ++i) {
                    if (!args[i].equals("-p")) continue;
                    port = args[i + 1];
                }
                Properties props = new Properties();
                skipExit = DME2IngressProxy.getProperty(props, "AFT_DME2_PROXY_SKIPEXIT", "false");
                String clzName = DME2IngressProxy.getProperty(props, "AFT_DME2_QUICKSERVER_SERVLET", "com.att.aft.dme2.api.proxy.DME2IngressProxyServlet");
                if (port == null) {
                    port = DME2IngressProxy.getProperty(props, "AFT_DME2_PORT", "21210");
                }
                String realm = DME2IngressProxy.getProperty(props, "AFT_DME2_QUICKSTART_REALM", null);
                String aftEnv = DME2IngressProxy.getProperty(props, "AFT_ENVIRONMENT", null);
                if (aftEnv == null) {
                    logger.error(null, "main", "AFT_ENVIRONMENT property is required");
                    System.exit(1);
                }
                if (aftEnv.equals("AFTUAT")) {
                    env = "UAT";
                } else if (aftEnv.equals("AFTPRD")) {
                    env = "PROD";
                } else {
                    logger.error((URI)null, "main", "AFT_ENVIRONMENT value {} is not valid", (Object)aftEnv);
                    System.exit(1);
                }
                String service = DME2IngressProxy.getProperty(props, "AFT_DME2_QUICKSTART_SERVICE", "service=com.att.aft.DME2IngressProxy/version=1.0.0/envContext=" + env + "/routeOffer=DEFAULT");
                logger.debug((URI)null, "main", " service = {}", (Object)service);
                String[] allowedRoles = null;
                String loginMethod = null;
                if (realm != null) {
                    String allowedRolesStr = DME2IngressProxy.getProperty(props, "AFT_DME2_QUICKSTART_ALLOWEDROLES", null);
                    if (allowedRolesStr == null) {
                        logger.error(null, "main", "AFT_DME2_QUICKSTART_ALLOWEDROLES is required when AFT_DME2_QUICKSTART_REALM is set");
                        System.exit(1);
                    }
                    allowedRoles = allowedRolesStr.split(",");
                    loginMethod = DME2IngressProxy.getProperty(props, "AFT_DME2_QUICKSTART_LOGINMETHOD", "BASIC");
                }
                if (service != null) {
                    props.put("AFT_DME_QUICKSTART_SERVICE", service);
                } else {
                    logger.error(null, "main", "AFT_DME_QUICKSTART_SERVICE must be set");
                    System.exit(1);
                }
                if (port == null) {
                    logger.error(null, "main", "Usage: DME2IngressProxy -p <port>");
                    System.exit(1);
                }
                props.put("AFT_DME2_PORT", port);
                DME2Configuration config2 = new DME2Configuration("DME2IngressProxyManager" + port, props);
                DME2Manager manager = new DME2Manager("DME2IngressProxyManager" + port, config2, props);
                Class<?> clz = QuickServer.class.getClassLoader().loadClass(clzName);
                logger.debug((URI)null, "main", " clzName******************************************************** = {}", (Object)clzName);
                Servlet listenerServlet = (Servlet)clz.getDeclaredConstructor(DME2Manager.class).newInstance(manager);
                QuickServletConfig config = new QuickServletConfig(service, null, props);
                listenerServlet.init((ServletConfig)config);
                DME2ServiceHolder holder = new DME2ServiceHolder();
                holder.setContext("/");
                holder.setManager(manager);
                holder.setSecurityRealm(realm);
                holder.setAllowedRoles(allowedRoles);
                holder.setLoginMethod(loginMethod);
                holder.setServiceURI(service);
                holder.setServlet(listenerServlet);
                manager.bindService(holder);
                manager.start();
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(60000L);
                        }
                    }
                    catch (InterruptedException e) {
                        if (!skipExit.equals("false")) continue;
                        System.exit(0);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (skipExit.equals("false")) {
                    System.exit(1);
                }
                if (skipExit.equals("false")) {
                    System.exit(0);
                }
            }
        }
        catch (Throwable throwable) {
            if (skipExit.equals("false")) {
                System.exit(0);
            }
            throw throwable;
        }
    }

    private static final String getProperty(Properties props, String key, String defaultValue) {
        String value = props.getProperty(key);
        if (value == null) {
            value = System.getProperty(key, defaultValue);
        }
        return value;
    }
}

