/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api.proxy;

import com.att.aft.dme2.api.DME2ReplyHandler;
import com.att.aft.dme2.api.DME2StreamReplyHandler;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.handler.AsyncResponseHandlerIntf;
import com.att.aft.dme2.internal.jetty.continuation.Continuation;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletResponse;

public class DME2IngressProxyReplyHandler
extends DME2StreamReplyHandler
implements DME2ReplyHandler,
AsyncResponseHandlerIntf {
    private String service;
    private static final Logger logger = LoggerFactory.getLogger(DME2IngressProxyReplyHandler.class);
    private Continuation continuation;
    private String correlationId;
    private OutputStream responseStream;
    private boolean streamMode;
    private String DME2_STREAM_HEADER_INFO = "X-DME2_PROXY_STREAM";
    private DME2Configuration config;

    public DME2IngressProxyReplyHandler(String service, Continuation continuation, String correlationId, boolean streamMode, DME2Configuration config) {
        this.service = service;
        this.continuation = continuation;
        this.correlationId = correlationId;
        this.streamMode = streamMode;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleException(Map<String, String> requestHeaders, Throwable e) {
        HttpServletResponse resp = (HttpServletResponse)this.continuation.getServletResponse();
        try {
            resp = (HttpServletResponse)this.continuation.getServletResponse();
            resp.sendError(500, e.toString());
            resp.flushBuffer();
        }
        catch (IOException x) {
            try {
                resp.sendError(500, x.toString());
                resp.flushBuffer();
            }
            catch (IOException e1) {
                logger.debug((URI)null, "handleException", LogMessage.DEBUG_MESSAGE, (Object)"IOException", (Object)e1);
            }
            return;
        }
        finally {
            this.continuation.complete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleReply(int responseCode, String responseMessage, InputStream in, Map<String, String> requestHeaders, Map<String, String> responseHeaders) {
        HttpServletResponse resp = (HttpServletResponse)this.continuation.getServletResponse();
        String response = null;
        BufferedReader reader = null;
        GZIPInputStream gis = null;
        try {
            String charset;
            resp = (HttpServletResponse)this.continuation.getServletResponse();
            String contentEncoding = responseHeaders.get(this.config.getProperty("DME2_CONTENT_ENCODING_KEY"));
            if (contentEncoding != null && contentEncoding.equalsIgnoreCase(this.config.getProperty("DME2_CLIENT_COMPRESS_TYPE")) && Boolean.parseBoolean(this.config.getProperty("DME2_CLIENT_ALLOW_COMPRESS"))) {
                try {
                    gis = new GZIPInputStream(in);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        resp.sendError(500, e.toString());
                        resp.flushBuffer();
                    }
                    catch (IOException e1) {
                        logger.debug((URI)null, "handleReply", LogMessage.DEBUG_MESSAGE, (Object)"IOException", (Object)e1);
                    }
                    try {
                        if (reader != null) {
                            reader.close();
                        }
                    }
                    catch (IOException e2) {
                        logger.debug((URI)null, "handleReply", LogMessage.DEBUG_MESSAGE, (Object)"IOException", (Object)e2);
                    }
                    this.continuation.complete();
                    return;
                }
            }
            reader = (charset = this.findCharSet(responseHeaders)) != null ? (gis == null ? new BufferedReader(new InputStreamReader(in, charset)) : new BufferedReader(new InputStreamReader(gis, charset))) : (gis == null ? new BufferedReader(new InputStreamReader(in)) : new BufferedReader(new InputStreamReader(gis)));
            char[] buffer = new char[8096];
            StringBuilder inputText = new StringBuilder(8096);
            int n = -1;
            while ((n = reader.read(buffer)) != -1) {
                inputText.append(buffer, 0, n);
            }
            response = inputText.toString();
            if (response != null) {
                logger.info((URI)null, "handleReply", "AFT-DME2-6610", (Object)new ErrorContext().add("requestURI", this.service).add("correlationId", this.correlationId).add("responseSize", response.getBytes().length + ""));
                for (String key : responseHeaders.keySet()) {
                    String value = responseHeaders.get(key);
                    resp.addHeader(key, value);
                }
                if (this.streamMode) {
                    resp.addHeader(this.DME2_STREAM_HEADER_INFO, "true");
                }
                resp.setStatus(responseCode);
                resp.getOutputStream().write(response.getBytes());
                resp.flushBuffer();
            }
        }
        catch (IOException e) {
            try {
                resp.sendError(500, e.toString());
                resp.flushBuffer();
            }
            catch (IOException e1) {
                logger.debug((URI)null, "handleReply", LogMessage.DEBUG_MESSAGE, (Object)"IOException", (Object)e1);
            }
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                logger.debug((URI)null, "handleReply", LogMessage.DEBUG_MESSAGE, (Object)"IOException", (Object)e);
            }
            this.continuation.complete();
        }
    }

    private String findCharSet(Map<String, String> parameterMap) {
        String charset = parameterMap.get("Content-Type");
        if (charset == null) {
            charset = parameterMap.get("content-type");
        }
        if (charset != null) {
            String[] toks = charset.split(";");
            if (toks.length > 1) {
                charset = toks[1];
                String[] toks2 = toks[1].split("=");
                charset = toks2.length > 1 ? toks2[1] : null;
            } else {
                charset = null;
            }
        }
        return charset;
    }

    @Override
    public void handleContent(byte[] bytes) {
        try {
            if (this.continuation != null) {
                HttpServletResponse servletResp = (HttpServletResponse)this.continuation.getServletResponse();
                servletResp.setHeader("X-DME2_PROXY_RESPONSE_STREAM", "true");
                this.responseStream = servletResp.getOutputStream();
                this.responseStream.write(bytes);
            }
        }
        catch (IOException e) {
            logger.error((URI)null, "handleContent", LogMessage.EXCH_READ_HANDLER_FAIL, (Object)new ErrorContext().add("requestURI", this.service).add("correlationId", this.correlationId), (Object)e);
            return;
        }
    }

    @Override
    public String getResponse(long timeoutMs) throws Exception {
        return null;
    }
}

