/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api.util;

import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.net.URI;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class DME2DateFormatAccess {
    final String ISO_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS zzz";
    final String GMT = "GMT";
    private static Logger logger = LoggerFactory.getLogger(DME2DateFormatAccess.class);
    private DME2Configuration config = null;
    private ThreadLocal<DateFormat> df = new ThreadLocal<DateFormat>(){

        @Override
        public DateFormat get() {
            return (DateFormat)super.get();
        }

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS zzz");
            if (DME2DateFormatAccess.this.config.getBoolean("AFT_DME2_ALLOW_CLIENT_SEND_TZ_OVERRIDE", false)) {
                sdf.setTimeZone(TimeZone.getTimeZone(DME2DateFormatAccess.this.config.getProperty("AFT_DME2_CLIENT_SEND_TIMESTAMP_TZ_KEY", "GMT")));
            }
            return sdf;
        }

        @Override
        public void remove() {
            super.remove();
        }

        @Override
        public void set(DateFormat value) {
            super.set(value);
        }
    };

    public DME2DateFormatAccess(DME2Configuration config) {
        this.config = config;
    }

    public Date convertStringToDate(String dateString) {
        try {
            return this.df.get().parse(dateString);
        }
        catch (Exception e) {
            logger.warn((URI)null, "convertStringToDate", "Error in formatting string to date", (Object)e);
            return null;
        }
    }

    public String convertDateToString(Date date) {
        try {
            return this.df.get().format(date);
        }
        catch (Exception e) {
            logger.warn((URI)null, "convertDateToString", "Error in formatting date to string", (Object)e);
            return null;
        }
    }
}

