/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api.util;

import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class DME2ThreadPoolConfig {
    private static final Logger logger = LoggerFactory.getLogger(DME2ThreadPoolConfig.class);
    private DME2Configuration dme2Config;
    private static Map<DME2Manager, DME2ThreadPoolConfig> thrPoolConfigMap = new HashMap<DME2Manager, DME2ThreadPoolConfig>();
    private transient ThreadFactory retryThreadFactory;
    private transient ThreadPoolExecutor retryThreadpool;
    private int retryThreadCorePoolSize;
    private int retryThreadMaxPoolSize;
    private long retryThreadTTL;
    private transient DME2Manager manager;
    private transient ThreadPoolExecutor webSocketThreadpool;
    private transient ThreadFactory wsThreadFactory;
    private int wsFactoryThreadCorePoolSize;
    private int wsFactoryThreadMaxPoolSize;
    private long wsFactoryThreadTTL;
    private transient ThreadFactory wsRetryThreadFactory;
    private transient ThreadPoolExecutor wsRetryThreadpool;
    private int wsRetryThreadCorePoolSize;
    private int wsRetryThreadMaxPoolSize;
    private long wsRetryThreadTTL;

    DME2ThreadPoolConfig(DME2Manager manager) {
        this.dme2Config = manager.getConfig();
        this.manager = manager;
        this.retryThreadCorePoolSize = this.dme2Config.getInt("DME2_EXCHANGE_RETRY_TPOOL_CORESIZE");
        this.retryThreadMaxPoolSize = this.dme2Config.getInt("DME2_EXCHANGE_RETRY_TPOOL_MAXSIZE");
        this.retryThreadTTL = this.dme2Config.getInt("DME2_EXCHANGE_RETRY_TPOOL_TTL");
        this.wsFactoryThreadCorePoolSize = this.dme2Config.getInt("DME2_WS_FACTORY_TPOOL_CORESIZE");
        this.wsFactoryThreadMaxPoolSize = this.dme2Config.getInt("DME2_WS_FACTORY_TPOOL_MAXSIZE");
        this.wsFactoryThreadTTL = this.dme2Config.getInt("DME2_WS_FACTORY_TPOOL_TTL");
        this.wsRetryThreadCorePoolSize = this.dme2Config.getInt("DME2_WS_RETRY_TPOOL_CORESIZE");
        this.wsRetryThreadMaxPoolSize = this.dme2Config.getInt("DME2_WS_RETRY_TPOOL_MAXSIZE");
        this.wsRetryThreadTTL = this.dme2Config.getInt("DME2_WS_RETRY_TPOOL_TTL");
    }

    public static DME2ThreadPoolConfig getInstance(DME2Manager manager) {
        DME2ThreadPoolConfig config = thrPoolConfigMap.get(manager);
        if (config == null) {
            config = new DME2ThreadPoolConfig(manager);
            thrPoolConfigMap.put(manager, config);
        }
        return config;
    }

    public ThreadFactory createThreadFactory() {
        if (this.retryThreadFactory == null) {
            this.retryThreadFactory = new ThreadFactory(){
                private int counter = 0;

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    String name = "";
                    try {
                        name = Thread.currentThread().getName();
                    }
                    catch (Exception e) {
                        logger.debug((URI)null, "createThreadFactory", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e);
                    }
                    t.setName("DME2::ExchangeRetryThread[" + name + "] - " + this.counter++);
                    t.setDaemon(true);
                    return t;
                }
            };
        }
        return this.retryThreadFactory;
    }

    public ThreadPoolExecutor createExchangeRetryThreadPool() {
        if (this.retryThreadpool == null) {
            this.retryThreadpool = new ThreadPoolExecutor(this.retryThreadCorePoolSize, this.retryThreadMaxPoolSize, this.retryThreadTTL, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(true), this.createThreadFactory());
        }
        return this.retryThreadpool;
    }

    public void setManager(DME2Manager manager) {
        this.manager = manager;
    }

    public ThreadPoolExecutor createWebSocketFactoryThreadPool() {
        if (this.webSocketThreadpool == null) {
            this.webSocketThreadpool = new ThreadPoolExecutor(this.wsFactoryThreadCorePoolSize, this.wsFactoryThreadMaxPoolSize, this.wsFactoryThreadTTL, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(true), this.createWsThreadFactory());
        }
        return this.webSocketThreadpool;
    }

    private ThreadFactory createWsThreadFactory() {
        if (this.wsThreadFactory == null) {
            this.wsThreadFactory = new ThreadFactory(){
                private int counter = 0;

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    String name = "";
                    try {
                        name = Thread.currentThread().getName();
                    }
                    catch (Exception e) {
                        logger.debug((URI)null, "createWsThreadFactory", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e);
                    }
                    t.setName("DME2::WebSocketThread[" + name + "] - " + this.counter++);
                    t.setDaemon(true);
                    return t;
                }
            };
        }
        return this.wsThreadFactory;
    }

    public ThreadPoolExecutor createWebSocketRetryFactoryThreadPool() {
        if (this.wsRetryThreadpool == null) {
            this.wsRetryThreadpool = new ThreadPoolExecutor(this.wsRetryThreadCorePoolSize, this.wsRetryThreadMaxPoolSize, this.wsRetryThreadTTL, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(true), this.createWsRetryThreadFactory());
        }
        return this.wsRetryThreadpool;
    }

    private ThreadFactory createWsRetryThreadFactory() {
        if (this.wsRetryThreadFactory == null) {
            this.wsRetryThreadFactory = new ThreadFactory(){
                private int counter = 0;

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    String name = "";
                    try {
                        name = Thread.currentThread().getName();
                    }
                    catch (Exception e) {
                        logger.debug((URI)null, "createWsRetryThreadFactory", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e);
                    }
                    t.setName("DME2::WebSocketRetryThread[" + name + "] - " + this.counter++);
                    t.setDaemon(true);
                    return t;
                }
            };
        }
        return this.wsRetryThreadFactory;
    }
}

