/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api.util;

import com.att.aft.dme2.api.DME2ServiceHolder;
import com.att.aft.dme2.api.util.DME2ThrottleServletResponseWrapper;
import com.att.aft.dme2.api.util.PartnerActiveRequestCounter;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.apache.commons.lang.StringUtils;
import com.att.aft.dme2.internal.jetty.continuation.Continuation;
import com.att.aft.dme2.internal.jetty.continuation.ContinuationListener;
import com.att.aft.dme2.internal.jetty.continuation.ContinuationSupport;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.DME2Constants;
import java.io.IOException;
import java.net.URI;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DME2ThrottleFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(DME2ThrottleFilter.class);
    private PartnerActiveRequestCounter partnerActiveRequestCounter;
    private DME2ServiceHolder dme2ServiceHolder;
    public static final String MAX_REQUESTS_FOR_PARTNER_MSG = "Application is currently processing maximum allocated request processors for partner.";
    private DME2Configuration config;

    public DME2ThrottleFilter(DME2ServiceHolder dme2ServiceHolder) {
        this.dme2ServiceHolder = dme2ServiceHolder;
        this.partnerActiveRequestCounter = new PartnerActiveRequestCounter(dme2ServiceHolder);
        this.config = dme2ServiceHolder.getManager().getConfig();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        logger.debug((URI)null, "doFilter", LogMessage.DEBUG_MESSAGE, (Object)"DME2ThrottleFilter doFilter called");
        String partnerName = this.getPartnerName(servletRequest);
        if (this.isFilterDisabled() || partnerName == null) {
            logger.debug((URI)null, "doFilter", LogMessage.DEBUG_MESSAGE, (Object)"DME2ThrottleFilter is disabled");
            filterChain.doFilter(servletRequest, servletResponse);
            logger.debug((URI)null, "doFilter", LogMessage.DEBUG_MESSAGE, (Object)"DME2ThrottleFilter after chain.doFilter called");
        } else {
            logger.debug((URI)null, "doFilter", LogMessage.DEBUG_MESSAGE, (Object)"DME2ThrottleFilter is enabled");
            boolean partnerWithinMaxAllowedRequests = this.partnerActiveRequestCounter.isPartnerWithinMaxAllowedActiveRequests(partnerName);
            if (partnerWithinMaxAllowedRequests) {
                logger.debug((URI)null, "doFilter", LogMessage.DEBUG_MESSAGE, (Object)"DME2ThrottleFilter partner within allowed and hence continuing");
                DME2ThrottleServletResponseWrapper wrapper = new DME2ThrottleServletResponseWrapper((HttpServletResponse)servletResponse, partnerName);
                filterChain.doFilter(servletRequest, (ServletResponse)wrapper);
                Continuation continuation = ContinuationSupport.getContinuation(servletRequest);
                logger.debug((URI)null, "doFilter", "DME2ThrottleFilter continuation suspended = {}  cont resp wrapp={}", (Object)continuation.isSuspended(), (Object)continuation.isResponseWrapped());
                if (continuation.isSuspended() && continuation.isResponseWrapped()) {
                    continuation.addContinuationListener(new ContinuationListenerWaitingForWrappedResponseToFinish(wrapper, this.partnerActiveRequestCounter));
                } else {
                    logger.debug((URI)null, "doFilter", LogMessage.DEBUG_MESSAGE, (Object)"DME2ThrottleFilter decrementing right after message received!!!!!!!!!!");
                    this.partnerActiveRequestCounter.decrementPartnerRequestCount(partnerName);
                }
            } else {
                logger.error((URI)null, "doFilter", LogMessage.THROTTLE_FILTER_FAILED, (Object)this.dme2ServiceHolder.getServiceURI(), (Object)this.getPartnerName(servletRequest));
                HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
                httpServletResponse.setContentType("text/plain");
                httpServletResponse.setCharacterEncoding("UTF-8");
                httpServletResponse.setStatus(429);
                ServletOutputStream outputMsg = httpServletResponse.getOutputStream();
                outputMsg.print(MAX_REQUESTS_FOR_PARTNER_MSG);
                return;
            }
        }
    }

    private boolean isFilterDisabled() {
        Boolean userSetQueryParam = null;
        try {
            userSetQueryParam = this.dme2ServiceHolder.getThrottleFilterDisabled();
        }
        catch (Exception exception) {
            logger.error((URI)null, "isFilterDisabled", LogMessage.DEBUG_MESSAGE, (Object)exception.getMessage());
        }
        logger.debug((URI)null, "isFilterDisabled", "userSetQueryParam: {} config: {}", (Object)userSetQueryParam, (Object)this.config.getBoolean(DME2Constants.AFT_DME2_DISABLE_THROTTLE_FILTER, true));
        if (userSetQueryParam == null) {
            return this.config.getBoolean(DME2Constants.AFT_DME2_DISABLE_THROTTLE_FILTER, true);
        }
        return userSetQueryParam;
    }

    private String getPartnerName(ServletRequest servletRequest) {
        String requestPartnerName = null;
        if (servletRequest instanceof HttpServletRequest && StringUtils.isBlank(requestPartnerName = ((HttpServletRequest)servletRequest).getHeader("DME2_REQUEST_PARTNER"))) {
            requestPartnerName = ((HttpServletRequest)servletRequest).getHeader("DME2_JMS_REQUEST_PARTNER");
        }
        logger.debug((URI)null, "getPartnerName", LogMessage.DEBUG_MESSAGE, (Object)("DME2ThrottleFilter partner name is " + requestPartnerName));
        return requestPartnerName;
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    private class ContinuationListenerWaitingForWrappedResponseToFinish
    implements ContinuationListener {
        private DME2ThrottleServletResponseWrapper dme2ThrottleServletResponseWrapper;
        private PartnerActiveRequestCounter partnerActiveRequestCounter;

        public ContinuationListenerWaitingForWrappedResponseToFinish(DME2ThrottleServletResponseWrapper dme2ThrottleServletResponseWrapper, PartnerActiveRequestCounter partnerActiveRequestCounter) {
            this.dme2ThrottleServletResponseWrapper = dme2ThrottleServletResponseWrapper;
            this.partnerActiveRequestCounter = partnerActiveRequestCounter;
        }

        @Override
        public void onComplete(Continuation continuation) {
            logger.debug((URI)null, "onComplete", LogMessage.DEBUG_MESSAGE, (Object)"DME2ThrottleFilter got continutation complete hence decrementing");
            this.decrementPartnerRequestCount();
        }

        @Override
        public void onTimeout(Continuation continuation1) {
            logger.debug((URI)null, "onTimeout", LogMessage.DEBUG_MESSAGE, (Object)"DME2ThrottleFilter got continutation timeout !!!!!! hence decrementing");
            this.decrementPartnerRequestCount();
        }

        private void decrementPartnerRequestCount() {
            try {
                String partnerName = this.dme2ThrottleServletResponseWrapper.getPartnerName();
                this.partnerActiveRequestCounter.decrementPartnerRequestCount(partnerName);
            }
            catch (Exception e) {
                logger.error((URI)null, "decrementPartnerRequestCount", LogMessage.DEBUG_MESSAGE, (Object)e.getMessage());
            }
        }
    }
}

