/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.api.util;

import com.att.aft.dme2.api.util.LockFailedException;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.HashMap;
import java.util.Map;

public class PortFileLockManager {
    private static final Logger logger = LoggerFactory.getLogger(PortFileLockManager.class);
    private static Map<String, PortFileLockManager> map = new HashMap<String, PortFileLockManager>();
    private final long MAXWAITTIME = 25L;
    private long sleepInterval = 5L;
    private long waitIterations = 5L;
    private static String lockDir = null;
    private FileChannel channel = null;
    private FileLock lock = null;
    private String name = null;
    private String portFileToLock = null;
    private String LOCKFILE = null;

    private PortFileLockManager(String fileName, long waitIterations, long sleepInterval) throws IOException {
        this.name = fileName;
        this.waitIterations = waitIterations;
        this.sleepInterval = sleepInterval;
        File portFile = new File(fileName);
        if (portFile.exists()) {
            lockDir = portFile.getParent();
            this.portFileToLock = portFile.getName();
        } else {
            lockDir = fileName.substring(0, fileName.lastIndexOf(File.separator));
            this.portFileToLock = fileName.substring(fileName.lastIndexOf(File.separator) + 1);
        }
        this.LOCKFILE = lockDir + File.separator + "." + this.portFileToLock + ".lock";
        FileOutputStream stream = PortFileLockManager.getNewFileOutputStream(this.LOCKFILE);
        this.channel = stream.getChannel();
    }

    public static synchronized PortFileLockManager getInstance(String fileName, long waitIterations, long sleepInterval) throws IOException {
        PortFileLockManager lock = map.get(fileName);
        if (lock == null) {
            lock = new PortFileLockManager(fileName, waitIterations, sleepInterval);
            map.put(fileName, lock);
        }
        return lock;
    }

    private static FileOutputStream getNewFileOutputStream(String filename) throws IOException {
        File file = new File(filename);
        file.createNewFile();
        FileOutputStream stream = new FileOutputStream(file);
        return stream;
    }

    public synchronized void acquire() throws LockFailedException {
        this.acquire(25L);
    }

    public synchronized void acquire(long timeout) throws LockFailedException {
        if (this.lock != null) {
            return;
        }
        try {
            long startTime = System.currentTimeMillis();
            long elapsedTime = 0L;
            int i = 0;
            while ((long)i < this.waitIterations) {
                this.lock = this.channel.tryLock();
                if (this.lock != null) {
                    return;
                }
                this.sleep(this.sleepInterval);
                elapsedTime = System.currentTimeMillis() - startTime;
                logger.debug((URI)null, "acquire", "PortFileLockManager waiting to acquire lock after waiting [{}] ms", (Object)elapsedTime);
                ++i;
            }
            logger.debug((URI)null, "acquire", "PortFileLockManager could not acquire after waiting [{}] ms", (Object)elapsedTime);
            throw new LockFailedException(this.name, "Could not acquire after waiting [" + elapsedTime + "] ms");
        }
        catch (ClosedChannelException e) {
            throw new LockFailedException(this.name, e);
        }
        catch (OverlappingFileLockException e) {
            logger.debug(null, "acquire", "WARNING: Lock is already held by another thread");
        }
        catch (IOException e) {
            throw new LockFailedException(this.name, e);
        }
    }

    public synchronized void release() {
        if (this.lock != null) {
            try {
                this.lock.release();
                this.lock = null;
            }
            catch (IOException e) {
                logger.debug((URI)null, "release", "WARNING: While releasing lock caught [{}]", (Object)e.toString());
            }
        }
    }

    private void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

