/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.cache;

import com.att.aft.dme2.cache.domain.CacheTypeElement;
import com.att.aft.dme2.cache.domain.CacheTypes;
import com.att.aft.dme2.cache.service.CacheTaskScheduler;
import com.att.aft.dme2.cache.service.DME2Cache;
import com.att.aft.dme2.cache.service.DME2CacheManager;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractCacheManager
implements DME2CacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCacheManager.class);
    protected final Map<String, CacheTaskScheduler> cacheManagerScheduleTaskRegister = new HashMap<String, CacheTaskScheduler>();
    protected static final Set<String> globalCacheRegister = new HashSet<String>();
    protected final Map<String, DME2Cache> instanceCacheManagerRegister = new HashMap<String, DME2Cache>();
    protected DME2Configuration config = null;

    public AbstractCacheManager() {
    }

    public AbstractCacheManager(DME2Configuration config) {
        this.config = config;
    }

    protected DME2Configuration getConfig() {
        return this.config;
    }

    public boolean registerScheduledTask(CacheTaskScheduler schedule) {
        if (schedule != null) {
            this.cacheManagerScheduleTaskRegister.put(schedule.getTaskName().concat(":").concat(String.valueOf(System.currentTimeMillis())), schedule);
        }
        return true;
    }

    private void startAllCaches(DME2Configuration config) {
        for (CacheTypeElement cacheTypeElement : CacheTypes.getCacheTypes(config)) {
        }
    }

    @Override
    public void shutdown() {
        this.shutdownCacheManagerRegisteredTimers();
        this.shutdownCacheRegisteredTimers();
    }

    private void shutdownCacheManagerRegisteredTimers() {
        for (Map.Entry<String, CacheTaskScheduler> entry : this.cacheManagerScheduleTaskRegister.entrySet()) {
            entry.getValue().cancel();
        }
    }

    private void shutdownCacheRegisteredTimers() {
        for (Map.Entry<String, DME2Cache> cacheEntry : this.instanceCacheManagerRegister.entrySet()) {
            this.getCache(cacheEntry.getKey()).shutdownTimerTask();
            globalCacheRegister.remove(cacheEntry.getKey());
        }
        this.instanceCacheManagerRegister.clear();
    }
}

