/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.cache;

import com.att.aft.dme2.cache.DME2CacheStats;
import com.att.aft.dme2.config.DME2Configuration;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class DME2CacheStatsHolder {
    private String serviceName;
    DME2CacheStats stats = null;
    private final Map<Integer, DME2CacheStats> hourlyStats = Collections.synchronizedMap(new HashMap());
    private transient DME2Configuration config;

    public DME2CacheStatsHolder(String serviceName, DME2Configuration config) {
        this.serviceName = serviceName;
        this.stats = new DME2CacheStats(this.serviceName);
        this.config = config;
    }

    public void recordRefreshSuccess(long elapsedTimeInMs, boolean cacheStatsEnabled) {
        boolean configStatsEnabled = this.config.getBoolean("AFT_DME2_DISABLE_CACHE_STATS", false);
        if (!cacheStatsEnabled || configStatsEnabled) {
            return;
        }
        Calendar cal = Calendar.getInstance();
        int currentHr = 11;
        boolean hourRolled = this.stats.lastRefreshHour != (long)currentHr;
        ++this.stats.refreshCount;
        this.stats.refreshSuccessAvgElapsedTimeInMs = (this.stats.refreshSuccessAvgElapsedTimeInMs * this.stats.refreshCount + elapsedTimeInMs) / (this.stats.refreshCount + 1L);
        ++this.stats.refreshSuccessCount;
        this.stats.lastSuccessAt = System.currentTimeMillis();
        this.stats.lastRefreshElapsedTimeInMs = elapsedTimeInMs;
        this.stats.lastRefreshHour = currentHr;
        this.recordCurrentHourStats(true, hourRolled, currentHr, elapsedTimeInMs);
    }

    public void recordRefreshFailure(long elapsedTimeInMs, boolean cacheStatsEnabled) {
        boolean configStatsEnabled = this.config.getBoolean("AFT_DME2_DISABLE_CACHE_STATS", false);
        if (!cacheStatsEnabled || configStatsEnabled) {
            return;
        }
        Calendar cal = Calendar.getInstance();
        int currentHr = 11;
        boolean hourRolled = this.stats.lastRefreshHour != (long)currentHr;
        ++this.stats.refreshCount;
        this.stats.refreshFailedAvgElapsedTimeInMs = (this.stats.refreshFailedAvgElapsedTimeInMs * this.stats.refreshCount + elapsedTimeInMs) / (this.stats.refreshCount + 1L);
        ++this.stats.refreshFailedCount;
        this.stats.lastExceptionAt = System.currentTimeMillis();
        this.stats.lastRefreshElapsedTimeInMs = elapsedTimeInMs;
        this.stats.lastRefreshHour = currentHr;
        this.recordCurrentHourStats(false, hourRolled, currentHr, elapsedTimeInMs);
    }

    public String toString() {
        return "CacheRefreshStats for service\t" + this.serviceName + "initialized at=\t" + new Date(this.stats.initTime) + "stats retrieved at=\t" + new Date() + "refreshCount=\t" + this.stats.refreshCount + "refreshSuccessCount=\t" + this.stats.refreshSuccessCount + "refreshFailureCount=\t" + this.stats.refreshFailedCount + "lastSuccessAt=\t" + new Date(this.stats.lastSuccessAt) + "lastExceptionAt=\t" + new Date(this.stats.lastExceptionAt) + "refreshSuccessAvgElapsedTimeInMs=\t" + this.stats.refreshSuccessAvgElapsedTimeInMs + "refreshFailureAvgElapsedTimeInMs=\t" + this.stats.refreshFailedAvgElapsedTimeInMs + "lastRefreshElapsedTimeInMs=\t" + this.stats.lastRefreshElapsedTimeInMs + "lastRefreshWas=\t" + (this.stats.lastExceptionAt > this.stats.lastSuccessAt ? "FAILED" : "SUCCESSFUL");
    }

    public DME2CacheStats getHourlyStats(int hourOfDay) {
        if (hourOfDay == 24) {
            return this.getLastDayStats();
        }
        DME2CacheStats stats = this.hourlyStats.get(hourOfDay);
        if (stats != null) {
            return stats;
        }
        return null;
    }

    public DME2CacheStats getStats() {
        return this.stats;
    }

    private DME2CacheStats getLastDayStats() {
        DME2CacheStats lastDayStats = null;
        try {
            Set<Integer> keys = this.hourlyStats.keySet();
            if (keys != null && keys.iterator() != null) {
                while (keys.iterator().hasNext()) {
                    Iterator<Integer> it = keys.iterator();
                    DME2CacheStats stats = this.hourlyStats.get(it.next());
                    if (lastDayStats == null) {
                        lastDayStats = stats;
                        continue;
                    }
                    this.addStats(stats);
                }
            }
            if (lastDayStats != null) {
                return lastDayStats;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private void recordCurrentHourStats(boolean successful, boolean hourRolledOver, int hourOfDay, long elapsedTimeInMs) {
        DME2CacheStats stats = null;
        if (hourRolledOver) {
            stats = new DME2CacheStats(this.serviceName);
            this.hourlyStats.put(hourOfDay, stats);
        } else {
            stats = this.hourlyStats.get(hourOfDay);
        }
        if (stats == null) {
            return;
        }
        stats.setRefreshSuccessAvgElapsedTimeInMs((stats.getRefreshSuccessAvgElapsedTimeInMs() * stats.getRefreshCount() + elapsedTimeInMs) / (stats.getRefreshCount() + 1L));
        stats.setRefreshCount(stats.getRefreshCount() + 1L);
        stats.setLastRefreshElapsedTimeInMs(elapsedTimeInMs);
        stats.setLastRefreshHour(hourOfDay);
        if (successful) {
            stats.setRefreshSuccessCount(stats.getRefreshSuccessCount() + 1L);
            stats.setLastSuccessAt(System.currentTimeMillis());
        } else {
            stats.setRefreshFailedCount(stats.getRefreshFailedCount() + 1L);
            stats.setLastExceptionAt(System.currentTimeMillis());
        }
    }

    private DME2CacheStats addStats(DME2CacheStats other) {
        DME2CacheStats lstats = null;
        if (other == null) {
            return null;
        }
        lstats = new DME2CacheStats(other.getServiceName());
        lstats.refreshCount = this.stats.refreshCount + other.getRefreshCount();
        lstats.refreshSuccessCount = this.stats.refreshSuccessCount + other.getRefreshSuccessCount();
        lstats.refreshFailedCount = this.stats.refreshFailedCount + other.getRefreshFailedCount();
        lstats.lastSuccessAt = 0L;
        lstats.refreshSuccessAvgElapsedTimeInMs = (this.stats.refreshSuccessAvgElapsedTimeInMs + other.getRefreshSuccessAvgElapsedTimeInMs()) / 2L;
        lstats.refreshFailedAvgElapsedTimeInMs = (this.stats.refreshFailedAvgElapsedTimeInMs + other.getRefreshFailedAvgElapsedTimeInMs()) / 2L;
        lstats.lastRefreshElapsedTimeInMs = 0L;
        return lstats;
    }
}

