/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.cache.handler.cacheabledata;

import com.att.aft.dme2.cache.domain.CacheElement;
import com.att.aft.dme2.cache.handler.cacheabledata.AbstractCacheDataHandler;
import com.att.aft.dme2.cache.service.DME2CacheableCallback;
import com.att.aft.dme2.internal.apache.commons.lang3.tuple.Pair;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class EndpointCacheDataHandler<K, V>
extends AbstractCacheDataHandler<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointCacheDataHandler.class.getName());

    @Override
    public Map<CacheElement.Key<K>, Pair<CacheElement, Exception>> getFreshDataToReloadAllEntries(Set<CacheElement.Key> keySet, DME2CacheableCallback source) {
        LOGGER.debug(null, "getFreshDataToReloadAllEntries", "retreving data by endpointdatahandler for all keys");
        Map<CacheElement.Key<K>, Pair<CacheElement, Exception>> dataMap = new TreeMap<CacheElement.Key<K>, Pair<CacheElement, Exception>>();
        HashSet keysToFetchData = new HashSet();
        if (keySet != null) {
            ArrayList<CacheElement.Key> keys = new ArrayList<CacheElement.Key>();
            for (CacheElement.Key key : keySet) {
                keys.add(key);
            }
            Collections.shuffle(keys);
            LOGGER.debug((URI)null, "getFreshDataToReloadAllEntries", LogMessage.REFRESH_ENDPOINTS, (Object)new Date());
            for (CacheElement.Key<Object> key : keys) {
                keysToFetchData.add(key);
            }
            dataMap = source.fetchFromSource(keysToFetchData);
            LOGGER.info(null, "getFreshDataToReloadAllEntries", "end");
        }
        return dataMap;
    }

    @Override
    public CacheElement getFreshDataToReloadCacheEntry(CacheElement.Key key, DME2CacheableCallback source) {
        LOGGER.info((URI)null, "EndpointCacheDataHandler.getFreshDataToReloadCacheEntry()", "start: [{}]", (Object)key);
        long start = System.currentTimeMillis();
        CacheElement returnValue = null;
        try {
            if (key != null && source != null) {
                returnValue = source.fetchFromSource(key);
            }
            LOGGER.info((URI)null, "EndpointCacheDataHandler.getFreshDataToReloadCacheEntry", "serviceUri [{}]; return value [{}]", key != null ? key : "null", returnValue != null ? returnValue : "null");
        }
        catch (Exception e) {
            LOGGER.error((String)null, (URI)null, "EndpointCacheDataHandler.getFreshDataToReloadCacheEntry", "exception while retreving data by endpointdatahandler for serviceUri [{}]; time taken [{}]", (Object)key, (Object)(System.currentTimeMillis() - start));
        }
        LOGGER.info((URI)null, "EndpointCacheDataHandler.getFreshDataToReloadCacheEntry", "retreving data by datahandler for serviceUri [{}]; time taken [{}]", (Object)key, (Object)(System.currentTimeMillis() - start));
        return returnValue;
    }
}

