/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.cache.handler.cacheabledata;

import com.att.aft.dme2.cache.domain.CacheElement;
import com.att.aft.dme2.cache.handler.cacheabledata.AbstractCacheDataHandler;
import com.att.aft.dme2.cache.service.DME2CacheableCallback;
import com.att.aft.dme2.internal.apache.commons.lang3.tuple.Pair;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.net.URI;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class RouteInfoCacheDataHandler<K, V>
extends AbstractCacheDataHandler<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteInfoCacheDataHandler.class.getName());

    @Override
    public Map<CacheElement.Key<K>, Pair<CacheElement, Exception>> getFreshDataToReloadAllEntries(Set<CacheElement.Key> keySet, DME2CacheableCallback source) {
        LOGGER.debug(null, "RouteInfoCacheDataHandler.getFreshDataToReloadAllEntries", "start - retreving data by RouteInfoCacheDataHandler for all keys");
        TreeMap<CacheElement.Key<K>, Pair<CacheElement, Exception>> registryCacheDataMap = new TreeMap();
        try {
            registryCacheDataMap = source.fetchFromSource(keySet);
        }
        catch (Exception e) {
            LOGGER.debug((URI)null, "RouteInfoCacheDataHandler.getFreshDataToReloadAllEntries", "error - retreiving routeinfo cacheable data: {}", (Object)e.getMessage());
            throw e;
        }
        LOGGER.info(null, "EndpointCacheDataHandler.getFreshDataToReloadAllEntries", "end");
        return registryCacheDataMap;
    }

    @Override
    public CacheElement getFreshDataToReloadCacheEntry(CacheElement.Key key, DME2CacheableCallback source) {
        LOGGER.debug((URI)null, "RouteInfoCacheDataHandler.getFreshDataToReloadCacheEntry", "start retreving data by RouteInfoCacheDataHandler serviceUri [{}]", (Object)key);
        long start = System.currentTimeMillis();
        CacheElement returnValue = null;
        try {
            if (key != null && source != null) {
                returnValue = source.fetchFromSource(key);
            }
            LOGGER.info((URI)null, "getFreshDataToReloadCacheEntry", "serviceUri [{}]; return value [{}]", key != null ? key : "null", returnValue != null ? returnValue : "null");
        }
        catch (Exception e) {
            LOGGER.error((String)null, (URI)null, "RouteInfoCacheDataHandler.getFreshDataToReloadCacheEntry", "exception while retreving data by RouteInfoCacheDataHandler for serviceUri [{}]; time taken [{}]", (Object)key, (Object)(System.currentTimeMillis() - start));
        }
        LOGGER.debug((URI)null, "RouteInfoCacheDataHandler.getFreshDataToReloadCacheEntry", "end - retrieving data by datahandler for serviceUri [{}]; time taken [{}]", (Object)key, (Object)(System.currentTimeMillis() - start));
        return returnValue;
    }
}

