/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.cache.hz;

import com.att.aft.dme2.cache.AbstractCache;
import com.att.aft.dme2.cache.domain.CacheConfiguration;
import com.att.aft.dme2.cache.domain.CacheElement;
import com.att.aft.dme2.cache.exception.CacheException;
import com.att.aft.dme2.cache.hz.HzCacheEntryView;
import com.att.aft.dme2.cache.service.CacheEntryView;
import com.att.aft.dme2.cache.service.DME2CacheableCallback;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.Fork;
import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IMap;
import java.io.InputStream;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class HzCache
extends AbstractCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(HzCache.class.getName());
    private static String configFilenameWithPath = null;
    private static long LOCK_TIMEOUT_MS;
    private IMap<CacheElement.Key, CacheElement> cacheMap = null;
    private static int lockCount;
    private static HazelcastInstance hz;
    private boolean isRefreshInProgress = false;
    private String cacheName = null;
    private ExecutorService PUT_ASYNC_SERVICE = Fork.createFixedThreadExecutorPool("PUT_ASYNC_SERVICE", 10);
    private CacheEntryView cacheEntryView = null;

    public HzCache(String cacheName, String cacheType, DME2CacheableCallback source, DME2Configuration config) throws CacheException {
        super(cacheName, cacheType, source, config);
        this.cacheName = cacheName;
        this.initialize();
    }

    public HzCache(CacheConfiguration cacheConfig) {
        super(cacheConfig);
        this.cacheConfig = cacheConfig;
        this.initialize();
    }

    @Override
    public CacheEntryView getEntryView() {
        return this.cacheEntryView;
    }

    private static Config loadHzConfig() {
        LOGGER.info(null, "HzCache.loadHzConfig", "start");
        Config local_config = null;
        try {
            InputStream hzConfigXMLInputStream = HzCache.class.getResourceAsStream("/hazelcast-config.xml");
            if (hzConfigXMLInputStream == null) {
                throw new CacheException(CacheException.ErrorCatalogue.CACHE_021, "/hazelcast-config.xml");
            }
            local_config = new XmlConfigBuilder(hzConfigXMLInputStream).build();
            local_config.setInstanceName("DME_CACHE_INSTANCE");
        }
        catch (Exception e) {
            LOGGER.warn(null, "HzCache.loadHzConfig", "exception");
            throw new CacheException(CacheException.ErrorCatalogue.CACHE_010, (Throwable)e, "/hazelcast-config.xml");
        }
        LOGGER.info(null, "HzCache.loadHzConfig", "complete");
        return local_config;
    }

    private static HazelcastInstance startHzContainer() {
        LOGGER.info(null, "HzCache.startHzContainer", "creating new Hazelcast container");
        return Hazelcast.newHazelcastInstance(HzCache.loadHzConfig());
    }

    public static HazelcastInstance getHzRunningInstance() {
        LOGGER.info(null, "HzCache.getHzRunningInstance", "start");
        if (hz == null) {
            LOGGER.info(null, "HzCache.getHzRunningInstance", "cache container is not running");
            hz = HzCache.startHzContainer();
            LOGGER.info(null, "HzCache.getHzRunningInstance", "cache container started");
        }
        LOGGER.info(null, "HzCache.getHzRunningInstance", "complete");
        return hz;
    }

    private HazelcastInstance getHz() {
        return hz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        LOGGER.info((URI)null, "HzCache.initialize", "start - cache: {}", (Object)this.getCacheName());
        this.cacheMap = HzCache.getHzRunningInstance().getMap(this.getCacheName());
        this.cacheEntryView = new HzCacheEntryView(this.cacheMap);
        configFilenameWithPath = this.getConfig().getProperty("CACHE_CONFIG_FILE_PATH_WITH_NAME");
        LOCK_TIMEOUT_MS = this.getConfig().getLong("LOCK_TIMEOUT_MS");
        HzCache hzCache = this;
        synchronized (hzCache) {
            if (hz == null) {
                hz = HzCache.startHzContainer();
            }
        }
        super.init();
        LOGGER.info((URI)null, "HzCache.initialize", "completed - cache: [{}]", (Object)this.getCacheName());
    }

    public boolean isContainerRunning() {
        if (hz == null || !hz.getLifecycleService().isRunning()) {
            LOGGER.info((URI)null, "HzCache.isRunning", "completed; hz[{}].getLifecycleService.isRunning: [{}]", (Object)hz, (Object)(hz != null ? hz.getLifecycleService().isRunning() : false));
        }
        return hz != null ? hz.getLifecycleService().isRunning() : false;
    }

    public IMap<CacheElement.Key, CacheElement> getCacheMap() {
        return this.cacheMap;
    }

    @Override
    public void put(CacheElement.Key k, CacheElement element) {
        LOGGER.info((URI)null, "AbstractCache.put(k,element)", "start put cache: [{}]", (Object)this.getCacheName());
        try {
            this.getCacheMap().put(k, element);
        }
        catch (Exception e) {
            LOGGER.warn((URI)null, "AbstractCache.put(k,element)", "cache:[{}] put operation encountered exception:[{}] ", (Object)this.getCacheName(), (Object)e.getMessage());
        }
        LOGGER.info((URI)null, "AbstractCache.put(k,element)", "completed put cache: [{}]", (Object)this.getCacheName());
    }

    private void putAsync(final CacheElement.Key k, final CacheElement element) {
        this.PUT_ASYNC_SERVICE.execute(new Runnable(){

            @Override
            public void run() {
                HzCache.this.put(k, element);
            }
        });
    }

    private void updateLastAccessedTime(CacheElement.Key key, CacheElement element) {
        element.setLastAccessedTime(this.getCurrentTimeMS());
        this.putAsync(key, element);
    }

    private CacheElement.Value get(CacheElement.Key key, boolean updateLastAccess) {
        LOGGER.info((URI)null, "HzCache.get", "start - cache: [{}] ,[{}]", (Object)this.getCacheName(), (Object)key);
        CacheElement.Value v = null;
        CacheElement element = null;
        try {
            element = (CacheElement)this.getCacheMap().get(key);
            if (updateLastAccess && element != null && !element.isMarkedForRemoval()) {
                this.updateLastAccessedTime(key, element);
            }
        }
        catch (HazelcastInstanceNotActiveException hze) {
            LOGGER.warn(null, "HzCache.get", "hazelcast is probably down!!!");
        }
        if (element != null && !element.isMarkedForRemoval()) {
            v = element.getValue();
        }
        LOGGER.info(null, "HzCache.get", "completed - cache: [{}] ,[{}], [{}]", this.getCacheName(), key, v);
        return v;
    }

    @Override
    public CacheElement.Value get(CacheElement.Key key) {
        return this.get(key, true);
    }

    @Override
    public void remove(CacheElement.Key key) {
        LOGGER.info((URI)null, "HzCache.remove", "start - cache: [{}] ,[{}]", (Object)this.getCacheName(), (Object)key);
        try {
            CacheElement element = (CacheElement)this.getCacheMap().get(key);
            if (element != null) {
                element.setMarkedForRemoval(true);
                this.getCacheMap().set(key, element);
                this.getCacheMap().removeAsync(key);
            }
        }
        catch (HazelcastInstanceNotActiveException hze) {
            LOGGER.warn(null, "HzCache.remove", "hazelcast is probably down!!!");
        }
        LOGGER.info((URI)null, "HzCache.remove", "completed- cache: [{}] ,[{}]", (Object)this.getCacheName(), (Object)key);
    }

    @Override
    public void shutdownTimerTask() {
        LOGGER.info(null, "shutdownTimerTask", "start");
        super.shutdownTimerTask();
        HzCache.shutdown();
        LOGGER.info(null, "shutdownTimerTask", "exit");
    }

    public static void shutdown() {
        LOGGER.info(null, "HzCache.shutdown", "start");
        if (hz != null && hz.getLifecycleService().isRunning()) {
            HzCache.getHzRunningInstance().shutdown();
        }
        hz = null;
        LOGGER.info(null, "HzCache.shutdown", "completed");
    }

    @Override
    public void lock(CacheElement.Key key) {
        LOGGER.info((URI)null, "HzCache.lock", "start - cache: [{}], [{}]", (Object)this.getCacheName(), (Object)key);
        if (this.getCacheMap().isLocked(key)) {
            LOGGER.info((URI)null, "HzCache.lock", "exception - cache: [{}], [{}]", (Object)this.getCacheName(), (Object)key);
            throw new CacheException(CacheException.ErrorCatalogue.CACHE_005, this.getCacheName(), key);
        }
        LOGGER.info(null, "HzCache.lock", "acquiring lock with [{}], [{}], lock count [{}]", this.getCacheName(), key, ++lockCount);
        this.getCacheMap().lock(key, LOCK_TIMEOUT_MS, TimeUnit.MILLISECONDS);
        LOGGER.info((URI)null, "HzCache.lock", "complete - cache: [{}], [{}]", (Object)this.getCacheName(), (Object)key);
    }

    @Override
    public void unlock(CacheElement.Key key) {
        LOGGER.info((URI)null, "HzCache.unlock", "start - cache: [{}], [{}]", (Object)this.getCacheName(), (Object)key);
        if (this.getCacheMap().isLocked(key)) {
            LOGGER.info(null, "HzCache.unlock", "releasing lock with  [{}], [{}], lock count [{}]", this.getCacheName(), key, --lockCount);
            this.getCacheMap().unlock(key);
        }
        LOGGER.info((URI)null, "HzCache.unlock", "complete - cache: [{}], [{}]", (Object)this.getCacheName(), (Object)key);
    }

    @Override
    public void clear() {
        LOGGER.info((URI)null, "HzCache.clear", "start - cache: [{}]", (Object)this.getCacheName());
        if (this.isContainerRunning()) {
            try {
                this.getCacheMap().clear();
            }
            catch (HazelcastInstanceNotActiveException hze) {
                LOGGER.warn(null, "HzCache.clear", "hazelcast is probably down!!!");
            }
        } else {
            LOGGER.info((URI)null, "HzCache.clear", "container not running [{}]", (Object)this.getCacheName());
        }
        LOGGER.info((URI)null, "HzCache.clear", "end - cache: [{}]", (Object)this.getCacheName());
    }

    @Override
    public int getCurrentSize() {
        LOGGER.info((URI)null, "HzCache.getCurrentSize", "start - cache: [{}]", (Object)this.getCacheName());
        int size = -1;
        if (this.isContainerRunning()) {
            try {
                size = this.getKeySet().size();
            }
            catch (HazelcastInstanceNotActiveException hze) {
                LOGGER.error(null, "HzCache.getCurrentSize", "error encountered, hazelcast is probably down!!!");
            }
        } else {
            LOGGER.info((URI)null, "HzCache.getCurrentSize", "container not running [{}]", (Object)this.getCacheName());
        }
        LOGGER.info((URI)null, "HzCache.getCurrentSize", "end - cache: [{}]", (Object)this.getCacheName());
        return size;
    }

    @Override
    public long getExpirationTime(String key) {
        return this.getExpirationTime(new CacheElement.Key<String>(key));
    }

    public long getCacheTTLValue(CacheElement.Key key) {
        long ttl;
        block5: {
            LOGGER.info((URI)null, "HzCache.getCacheEntryTTLValue", "start - cache: [{}]", (Object)this.getCacheName());
            ttl = -1L;
            if (this.isContainerRunning()) {
                try {
                    if (this.getCacheMap() == null) break block5;
                    if (this.getCacheMap().getEntryView(key) != null) {
                        ttl = this.getCacheMap().getEntryView(key).getTtl();
                        break block5;
                    }
                    LOGGER.warn(null, "HzCache.getCacheEntryTTLValue", "key: {} does not exist");
                }
                catch (HazelcastInstanceNotActiveException hze) {
                    LOGGER.warn(null, "HzCache.getCacheEntryTTLValue", "hazelcast is probably down!!!");
                }
            } else {
                LOGGER.info((URI)null, "HzCache.getCacheEntryTTLValue", "container not running [{}]", (Object)this.getCacheName());
            }
        }
        LOGGER.info((URI)null, "HzCache.getCacheEntryTTLValue", "end - cache: [{}], cache entry ttl: [{}]", (Object)this.getCacheName(), (Object)ttl);
        return ttl;
    }

    public long getExpirationTime(CacheElement.Key key) {
        long expirationTime;
        block5: {
            LOGGER.info((URI)null, "HzCache.getCacheEntryExpirationTime", "start - cache: [{}]", (Object)this.getCacheName());
            expirationTime = -1L;
            if (this.isContainerRunning()) {
                try {
                    if (this.getCacheMap() == null) break block5;
                    if (this.getCacheMap().getEntryView(key) != null) {
                        expirationTime = this.getCacheMap().getEntryView(key).getExpirationTime();
                        break block5;
                    }
                    LOGGER.warn(null, "HzCache.getExpirationTime", "key: {} does not exist");
                }
                catch (HazelcastInstanceNotActiveException hze) {
                    LOGGER.warn(null, "HzCache.getCacheEntryTTLValue", "hazelcast is probably down!!!");
                }
            } else {
                LOGGER.info((URI)null, "HzCache.getCacheEntryExpirationTime", "container not running [{}]", (Object)this.getCacheName());
            }
        }
        LOGGER.info((URI)null, "HzCache.getCacheEntryExpirationTime", "end - cache: [{}], cache entry expiration time: [{}]", (Object)this.getCacheName(), (Object)expirationTime);
        return expirationTime;
    }

    @Override
    public Set<CacheElement.Key> getKeySet() {
        HashSet<CacheElement.Key> keys = new HashSet<CacheElement.Key>();
        try {
            for (CacheElement.Key k : this.getCacheMap().keySet()) {
                if (this.getCacheMap().get(k) == null || ((CacheElement)this.getCacheMap().get(k)).isMarkedForRemoval()) continue;
                keys.add(k);
            }
        }
        catch (HazelcastInstanceNotActiveException hze) {
            LOGGER.warn(null, "HzCache.getCacheEntryTTLValue", "hazelcast is probably down!!!");
        }
        return keys;
    }

    @Override
    public boolean isPutAllow(CacheElement.Key key, CacheElement.Value value) {
        return true;
    }

    @Override
    public void refresh() {
        super.refresh();
    }

    @Override
    public void checkNRemoveUnusedEndpoints() {
        super.checkNRemoveUnusedEndpoints();
    }

    @Override
    public void setRefreshInProgress(boolean refreshInProgress) {
        this.isRefreshInProgress = refreshInProgress;
    }

    @Override
    public boolean isRefreshing() {
        return this.isRefreshInProgress;
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public long getCacheTTLValue(String key) {
        return this.getCacheTTLValue(new CacheElement.Key<String>(key));
    }

    static {
        lockCount = 0;
        hz = null;
    }
}

