/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.cache.hz;

import com.att.aft.dme2.cache.AbstractCacheManager;
import com.att.aft.dme2.cache.domain.CacheConfiguration;
import com.att.aft.dme2.cache.exception.CacheException;
import com.att.aft.dme2.cache.hz.HzCache;
import com.att.aft.dme2.cache.service.DME2Cache;
import com.att.aft.dme2.cache.service.DME2CacheableCallback;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.mbean.DME2CacheJMXBean;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class HzCacheManager
extends AbstractCacheManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HzCacheManager.class.getName());
    private static Map<String, HzCacheManager> globalCacheManagerRegister = new HashMap<String, HzCacheManager>();

    public static HzCacheManager getInstance(DME2Configuration config) {
        String managerName = config.getManagerName() != null ? config.getManagerName() : "--default--";
        HzCacheManager hzCacheManager = globalCacheManagerRegister.get(managerName);
        if (hzCacheManager == null) {
            hzCacheManager = new HzCacheManager(config);
            globalCacheManagerRegister.put(managerName, hzCacheManager);
        }
        return hzCacheManager;
    }

    public HzCacheManager() {
    }

    public HzCacheManager(DME2Configuration config) {
        super(config);
    }

    @Override
    public DME2Cache createCache(String cacheName, String cacheType, DME2CacheableCallback source) {
        LOGGER.info((URI)null, "createCache", "creating cache instance for [{}]", (Object)cacheName);
        if (cacheName == null) {
            throw new CacheException(CacheException.ErrorCatalogue.CACHE_015, new Object[0]);
        }
        if (cacheType == null) {
            throw new CacheException(CacheException.ErrorCatalogue.CACHE_016, new Object[0]);
        }
        if (globalCacheRegister.contains(cacheName)) {
            throw new CacheException(CacheException.ErrorCatalogue.CACHE_014, cacheName);
        }
        HzCache cache = new HzCache(cacheName, cacheType, source, this.config);
        globalCacheRegister.add(cacheName);
        this.instanceCacheManagerRegister.put(cacheName, cache);
        LOGGER.info((URI)null, "createCache", "created cache instance for [{}]", (Object)cacheName);
        return cache;
    }

    @Override
    public DME2Cache createCache(CacheConfiguration cacheConfig) {
        if (cacheConfig == null) {
            throw new CacheException(CacheException.ErrorCatalogue.CACHE_017, new Object[0]);
        }
        if (cacheConfig.getCacheName() == null) {
            throw new CacheException(CacheException.ErrorCatalogue.CACHE_015, new Object[0]);
        }
        if (!globalCacheRegister.contains(cacheConfig.getCacheName())) {
            throw new CacheException(CacheException.ErrorCatalogue.CACHE_014, cacheConfig.getCacheName());
        }
        HzCache cache = new HzCache(cacheConfig);
        globalCacheRegister.add(cacheConfig.getCacheName());
        this.instanceCacheManagerRegister.put(cacheConfig.getCacheName(), cache);
        LOGGER.info((URI)null, "createCache", "created cache instance for [{}]", (Object)cacheConfig.getCacheName());
        return cache;
    }

    @Override
    public DME2Cache getCache(String cacheName) {
        return (DME2Cache)this.instanceCacheManagerRegister.get(cacheName);
    }

    @Override
    public void shutdown() {
        super.shutdown();
        globalCacheManagerRegister.remove(this.getConfig().getManagerName());
    }

    @Override
    public boolean isCacheContainerRunning() {
        LOGGER.debug((URI)null, "isCacheContainerRunning", "cacheRegister is [{}]", (Object)globalCacheRegister);
        return !globalCacheRegister.isEmpty();
    }

    @Override
    public DME2CacheJMXBean getCacheBean(String name) {
        return (DME2CacheJMXBean)((Object)this.getCache(name));
    }
}

