/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.cache.persistence;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.cache.domain.CacheElement;
import com.att.aft.dme2.cache.exception.CacheException;
import com.att.aft.dme2.cache.service.CacheSerialization;
import com.att.aft.dme2.cache.service.DME2Cache;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.apache.commons.codec.digest.DigestUtils;
import com.att.aft.dme2.internal.jackson.JsonGenerationException;
import com.att.aft.dme2.internal.jackson.JsonGenerator;
import com.att.aft.dme2.internal.jackson.map.DeserializationConfig;
import com.att.aft.dme2.internal.jackson.map.JsonMappingException;
import com.att.aft.dme2.internal.jackson.map.ObjectMapper;
import com.att.aft.dme2.internal.jackson.type.TypeReference;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2RouteInfo;
import com.att.aft.dme2.manager.registry.DME2ServiceEndpointData;
import com.att.aft.dme2.util.DME2Utils;
import com.att.aft.dme2.util.ErrorContext;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class CacheSerializationToFile
implements CacheSerialization {
    private static final Logger LOGGER = LoggerFactory.getLogger(CacheSerializationToFile.class.getName());
    private int persistAttemptsCounter = 0;
    private static final long DEFAULT_WAIT_TIME_MS = 2000L;
    private boolean removePersistedEndpointsOnStartup;
    private ObjectMapper mapper = new ObjectMapper();
    private Object lock = new Object();
    private boolean isEndpointCache = false;

    public CacheSerializationToFile(DME2Cache cache, DME2Configuration config, boolean isEndpointCache) {
        this.removePersistedEndpointsOnStartup = Boolean.parseBoolean(System.getProperty("AFT_DME2_REMOVE_PERSISTENT_CACHE_ON_STARTUP")) || config.getBoolean("AFT_DME2_REMOVE_PERSISTENT_CACHE_ON_STARTUP", false);
        LOGGER.debug((URI)null, "CacheSerializationToFile", LogMessage.DEBUG_MESSAGE, (Object)("Removing persisted Endpoints on startup: " + this.removePersistedEndpointsOnStartup));
        if (this.removePersistedEndpointsOnStartup) {
            this.removePersistedEndpointCacheAtStartUp(cache, config);
        }
        this.isEndpointCache = isEndpointCache;
    }

    public void removePersistedEndpointCacheAtStartUp(DME2Cache cache, DME2Configuration config) {
        LOGGER.debug(null, "removePersistedEndpointCacheAtStartUp", LogMessage.METHOD_ENTER);
        File cachePersistentFile = null;
        try {
            cachePersistentFile = this.resolveCachePersistenceFile(cache, config, false);
            if (cachePersistentFile.exists()) {
                cachePersistentFile.delete();
                LOGGER.debug((URI)null, "removePersistedEndpointCacheAtStartUp", LogMessage.DEBUG_MESSAGE, (Object)"Successfully removed Endpoints from persistent cache on application startup.");
            }
        }
        catch (Exception e) {
            ErrorContext ec = new ErrorContext();
            ec.add("persistentCacheFileName: ", cachePersistentFile != null ? cachePersistentFile.getAbsolutePath() : "null");
            DME2Exception exception = new DME2Exception("AFT-DME2-0616", ec);
            LOGGER.warn((URI)null, "removePersistedEndpointCacheAtStartUp", LogMessage.DEBUG_MESSAGE, (Object)"Error occurred while attempted to remove Endpoints from persistent cache on application startup.", (Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean persist(DME2Cache cache, DME2Configuration config) {
        File cachePersistentFile = null;
        LOGGER.debug((URI)null, "persist", LogMessage.METHOD_ENTER, (Object)" for cache: {}", (Object)(cache != null ? cache.getCacheName() : "cache is null"));
        try {
            if (Boolean.valueOf(System.getProperty("AFT_DME2_DISABLE_PERSISTENT_CACHE")).booleanValue() || config.getBoolean("DME3_DISABLE_PERSISTENT_CACHE", false)) {
                LOGGER.debug(null, "persist", "Persistence cache feature is disabled, skipping operation.");
                return false;
            }
            if (cache.getKeySet().isEmpty()) {
                LOGGER.debug(null, "persist", "Cache is empty, skipping persistence operation.");
                return true;
            }
            this.waitForRefresh(cache, config);
            cachePersistentFile = this.resolveCachePersistenceFile(cache, config, true);
            Object object = this.lock;
            synchronized (object) {
                if (cachePersistentFile != null) {
                    Map<CacheElement.Key, CacheElement> cacheMapToPersist = Collections.synchronizedMap(new HashMap());
                    for (CacheElement.Key key : cache.getKeySet()) {
                        cacheMapToPersist.put(key, this.createCachePersistingElement(key, cache));
                    }
                    try {
                        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(cachePersistentFile.getAbsolutePath(), true)));
                        JsonGenerator g = this.mapper.getJsonFactory().createJsonGenerator(out);
                        this.mapper.writeValue(cachePersistentFile, cacheMapToPersist.values());
                    }
                    catch (JsonGenerationException mapGenEx) {
                        throw new CacheException(CacheException.ErrorCatalogue.CACHE_023, (Throwable)mapGenEx, mapGenEx.getMessage());
                    }
                    catch (JsonMappingException mapEx) {
                        throw new CacheException(CacheException.ErrorCatalogue.CACHE_023, (Throwable)mapEx, mapEx.getMessage());
                    }
                    catch (IOException ioex) {
                        throw new CacheException(CacheException.ErrorCatalogue.CACHE_023, (Throwable)ioex, ioex.getMessage());
                    }
                    LOGGER.debug((URI)null, "persist", LogMessage.DEBUG_MESSAGE, (Object)("Successfully persisted endpoints to file: " + cachePersistentFile + "Number of endpoints persisted: " + cacheMapToPersist.values().size()));
                    return true;
                }
            }
        }
        catch (Exception ex) {
            LOGGER.debug(null, "persist", LogMessage.DEBUG_MESSAGE, "Error occured while persisting cache {} entries to file: {}", cache != null ? cache.getCacheName() : "null", cachePersistentFile);
        }
        LOGGER.debug(null, "persist", LogMessage.METHOD_EXIT);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean load(DME2Cache cache, DME2Configuration config) {
        boolean loaded;
        block13: {
            LOGGER.debug((URI)null, "load", LogMessage.METHOD_ENTER, (Object)" for cache: {}", (Object)(cache != null ? cache.getCacheName() : "cache is null"));
            loaded = false;
            File cachePersistentFile = null;
            List persistedData = null;
            try {
                if (!this.removePersistedEndpointsOnStartup) {
                    if (!config.getBoolean("AFT_DME2_DISABLE_PERSISTENT_CACHE_LOAD")) {
                        LOGGER.debug((URI)null, "load", LogMessage.DEBUG_MESSAGE, (Object)"[] = false. Persisted Endpoints will NOT be loaded from file. Skipping operation.", (Object)"AFT_DME2_DISABLE_PERSISTENT_CACHE_LOAD");
                        break block13;
                    }
                    cachePersistentFile = this.resolveCachePersistenceFile(cache, config, false);
                    if (cachePersistentFile == null) {
                        LOGGER.warn((URI)null, "load", LogMessage.DEBUG_MESSAGE, (Object)"persistent store reference was not provided to warm up cache []. Skipping cache warm up operation.", (Object)(cache != null ? cache.getCacheName() : "null"));
                        break block13;
                    }
                    ObjectMapper mapper = new ObjectMapper();
                    mapper.configure(DeserializationConfig.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
                    mapper.configure(DeserializationConfig.Feature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                    try {
                        Iterator iterator = this.lock;
                        synchronized (iterator) {
                            persistedData = (List)mapper.readValue(cachePersistentFile, (TypeReference)new TypeReference<List<CacheElement>>(){});
                            loaded = true;
                        }
                    }
                    catch (JsonGenerationException mapGenEx) {
                        throw new CacheException(CacheException.ErrorCatalogue.CACHE_023, (Throwable)mapGenEx, mapGenEx.getMessage());
                    }
                    catch (JsonMappingException mapEx) {
                        throw new CacheException(CacheException.ErrorCatalogue.CACHE_023, (Throwable)mapEx, mapEx.getMessage());
                    }
                    catch (IOException ioex) {
                        throw new CacheException(CacheException.ErrorCatalogue.CACHE_023, (Throwable)ioex, ioex.getMessage());
                    }
                    LOGGER.debug((URI)null, "load", "Successfully loaded persisted endpoints from file: {}", (Object)cachePersistentFile.getAbsolutePath());
                    for (CacheElement data : persistedData) {
                        CacheElement.Value v = null;
                        v = data.getValue().getValue() instanceof Map ? this.convertMapToJson(cache, (Map)data.getValue().getValue()) : data.getValue();
                        cache.put(data.getKey(), v);
                    }
                    LOGGER.debug((URI)null, "load", "Cache warmed with #data: {}", (Object)cache.getCurrentSize());
                    break block13;
                }
                LOGGER.debug((URI)null, "load", "Ignoring loading as its been specified to delete the cache persistence file on startup: cache :{}", (Object)(cachePersistentFile != null ? cachePersistentFile.getAbsolutePath() : "NULL"));
            }
            catch (Exception e) {
                LOGGER.debug((URI)null, "load", "Ignoring error while loading persisted endpoints from file:{} ", (Object)(cachePersistentFile != null ? cachePersistentFile.getAbsolutePath() : "NULL"), (Object)e);
            }
        }
        LOGGER.debug(null, "load", LogMessage.METHOD_EXIT);
        return loaded;
    }

    private CacheElement createCachePersistingElement(CacheElement.Key k, DME2Cache cache) {
        LOGGER.debug(null, "createElement", "start");
        CacheElement element = new CacheElement().setKey(k).setValue(cache.getEntryView().getEntry(k).getValue());
        LOGGER.debug((URI)null, "createElement", "completed element: [{}]", (Object)element);
        return element;
    }

    private void waitForRefresh(DME2Cache cache, DME2Configuration config) {
        if (cache.isRefreshing()) {
            String waitSchedule;
            String string = waitSchedule = this.isEndpointCache ? config.getProperty("DME2_PERSIST_CACHED_ENDPOINTS_DELAY_MS") : config.getProperty("DME2_PERSIST_CACHED_ROUTEINFO_DELAY_MS");
            if (waitSchedule != null && !waitSchedule.isEmpty()) {
                this.threadWait(Integer.parseInt(waitSchedule));
            } else {
                waitSchedule = config.getProperty("CACHE_PERSISTENCE_WAIT_SCHEDULE_FOR_REFRESH_MS");
                if (waitSchedule != null) {
                    try {
                        StringTokenizer tokens = new StringTokenizer(waitSchedule);
                        while (tokens.hasMoreTokens()) {
                            LOGGER.warn((URI)null, "waitForRefresh", "Delaying peristCachedEndpoints operation for {}ms so that the refeshEndpoints operation can complete. Attempt# {}", (Object)true, (Object)this.persistAttemptsCounter);
                            this.threadWait(Integer.parseInt(tokens.nextToken()));
                        }
                    }
                    catch (NullPointerException | NumberFormatException ex) {
                        LOGGER.warn((URI)null, "waitForRefresh", "Cache persistence wait schedule has not been configured properly, {}", (Object)waitSchedule);
                        this.cachePersistenceDefaultWaitForRefresh();
                    }
                } else {
                    this.cachePersistenceDefaultWaitForRefresh();
                }
            }
        }
    }

    private void threadWait(long waitTime) {
        try {
            Thread.sleep(waitTime);
        }
        catch (InterruptedException e) {
            LOGGER.warn(null, "waitForRefresh", "Cache persistence wait was interrupted.");
            this.cachePersistenceDefaultWaitForRefresh();
        }
    }

    private void cachePersistenceDefaultWaitForRefresh() {
        LOGGER.warn((URI)null, "waitForRefresh", "Waiting for default time {}ms for refresh to complete", (Object)2000L);
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            LOGGER.warn(null, "waitForRefresh", "Cache persistence default wait was interrupted.");
        }
    }

    private String getCachePersistenceFileNameWithAbsolutePath(DME2Configuration config, DME2Cache cache) {
        String instanceName = DME2Utils.getRunningInstanceName(config);
        String cachedEndpointsFile = null;
        if (instanceName != null) {
            String cachePersistenceDirName;
            if (!instanceName.startsWith(File.separator)) {
                instanceName = File.separator + instanceName;
            }
            if ((cachePersistenceDirName = this.resolveCachePersistenceDirName(config)) != null) {
                LOGGER.debug((URI)null, "getCachePersistenceFileNameWithAbsolutePath", "directory name = {}", (Object)cachePersistenceDirName);
                cachedEndpointsFile = this.buildCachePeristenceFileName(cachePersistenceDirName, instanceName, cache.getCacheConfig().getCacheType().getName());
            } else {
                cachedEndpointsFile = null;
                LOGGER.warn(null, "getCachePersistenceFileNameWithAbsolutePath", "cannot find any directory name for cache persistence");
            }
        }
        if (cachedEndpointsFile == null) {
            cachedEndpointsFile = this.getCacheFileNameFromUserConfig(cache, config);
        }
        return cachedEndpointsFile;
    }

    private String buildCachePeristenceFileName(String cachePersistenceDirName, String instanceName, String cacheType) {
        String cachedEndpointsFile = null;
        String endpointCacheExt = cachePersistenceDirName + ".aft" + File.separator + instanceName + File.separator + ".cached-endpoints.ser";
        String routeInfoCacheExt = cachePersistenceDirName + ".aft" + File.separator + instanceName + File.separator + ".cached-routeinfo.ser";
        switch (cacheType) {
            case "EndpointCache": {
                cachedEndpointsFile = endpointCacheExt;
                break;
            }
            case "RouteInfoCache": {
                cachedEndpointsFile = routeInfoCacheExt;
            }
        }
        return cachedEndpointsFile;
    }

    private String getCacheFileNameFromUserConfig(DME2Cache cache, DME2Configuration config) {
        String cachePersistenceFilePropName = null;
        String cachedPersistenceFileName = null;
        switch (cache.getCacheConfig().getCacheType().getName()) {
            case "EndpointCache": {
                cachePersistenceFilePropName = "AFT_DME2_CACHED_ENDPOINTS_FILE";
                break;
            }
            case "RouteInfoCache": {
                cachePersistenceFilePropName = "AFT_DME2_CACHED_ROUTEINFO_FILE";
            }
        }
        if (cachePersistenceFilePropName != null && (cachedPersistenceFileName = System.getProperty(cachePersistenceFilePropName)) == null) {
            cachedPersistenceFileName = config.getProperty(cachePersistenceFilePropName, null);
            LOGGER.debug((URI)null, "resolvePersistedEndpointsFile", LogMessage.DEBUG_MESSAGE, (Object)("Value of Persistent Cache File: " + cachedPersistenceFileName));
        }
        return cachedPersistenceFileName;
    }

    private File getFile(String fileNameWithPath, DME2Configuration config, boolean bcreate) {
        File cachePersistentFile = null;
        try {
            try {
                cachePersistentFile = new File(fileNameWithPath);
            }
            catch (Exception e) {
                PrintWriter writer = new PrintWriter(fileNameWithPath, "UTF-8");
                writer.println("");
                writer.close();
                cachePersistentFile = new File(fileNameWithPath);
            }
            if (!cachePersistentFile.isFile() || !cachePersistentFile.exists()) {
                if (bcreate) {
                    if (cachePersistentFile.getParentFile() != null) {
                        cachePersistentFile.getParentFile().mkdirs();
                        LOGGER.debug((URI)null, "getFile", "trying to create file [{}] for cache persistence", (Object)cachePersistentFile.getName());
                        cachePersistentFile.createNewFile();
                        LOGGER.debug((URI)null, "getFile", "created file [{}] for cache persistence", (Object)cachePersistentFile.getAbsolutePath());
                    } else {
                        cachePersistentFile = new File(this.resolveCachePersistenceDirName(config).concat(fileNameWithPath));
                        if (!cachePersistentFile.isFile() || !cachePersistentFile.exists()) {
                            LOGGER.debug((URI)null, "getFile", "trying to create file [{}] for cache persistence relative to user dir", (Object)cachePersistentFile.getName());
                            cachePersistentFile.createNewFile();
                            LOGGER.debug((URI)null, "getFile", "created file [{}] for cache persistence relative to user dir", (Object)cachePersistentFile.getAbsolutePath());
                        }
                    }
                } else {
                    if (fileNameWithPath != null && !fileNameWithPath.startsWith("\\") && !fileNameWithPath.startsWith("/")) {
                        fileNameWithPath = "/".concat(fileNameWithPath);
                    }
                    cachePersistentFile = new File(this.getClass().getResource(fileNameWithPath).getFile());
                    LOGGER.debug((URI)null, "getFile", "created file [{}] for cache persistence", (Object)cachePersistentFile.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((URI)null, "getFile", "error: [{}] -- while processing cache file [{}] for persistence", (Object)(cachePersistentFile != null ? cachePersistentFile.getName() : "null"), (Object)e.getMessage());
        }
        return cachePersistentFile;
    }

    private File resolveCachePersistenceFile(DME2Cache cache, DME2Configuration config, boolean bcreate) {
        Object cachePersistenceDirName = null;
        String instanceName = cache.getCacheName();
        File cachePersistentFile = null;
        if (instanceName != null) {
            LOGGER.debug((URI)null, "resolveCachePersistenceFile", "directory name = {}", (Object)cachePersistenceDirName);
            cachePersistentFile = this.getFile(this.getCachePersistenceFileNameWithAbsolutePath(config, cache), config, bcreate);
        } else {
            cachePersistentFile = null;
            LOGGER.debug((URI)null, "resolveCachePersistenceFile", "cache name is not available in the cache {}", (Object)cache);
        }
        return cachePersistentFile;
    }

    public String hashString(String str) {
        String hexStr = null;
        try {
            if (str != null) {
                hexStr = DigestUtils.sha256Hex(str);
                LOGGER.debug((URI)null, "hashString", "Hex format of [{}] using SHA256: [{}]", (Object)str, (Object)hexStr);
                return hexStr;
            }
        }
        catch (Exception e) {
            LOGGER.debug((URI)null, "hashString", "Error [{}], converting input [{}] ", (Object)e, (Object)str);
        }
        return str;
    }

    private String resolveCachePersistenceDirName(DME2Configuration config) {
        String cachePersistenceDirName = null;
        LOGGER.debug((URI)null, "resolveCachePersistenceDirName", "cache persistence directory name being retreived from config {}", (Object)"CACHE_FILE_PERSISTENCE_DIR");
        cachePersistenceDirName = config.getProperty("CACHE_FILE_PERSISTENCE_DIR");
        if (!this.resolveDirectory(cachePersistenceDirName)) {
            LOGGER.debug(null, "resolveCachePersistenceDirName", "cache persistence directory name being retreived from the system property \"user.home\"");
            try {
                cachePersistenceDirName = System.getProperty("user.home");
            }
            catch (SecurityException se) {
                LOGGER.warn(null, "resolvePersistedFileName", "cache persistence directory property \"user.home\" as set in the system property do not have correct privilege to be retreived");
            }
            if (!this.resolveDirectory(cachePersistenceDirName)) {
                LOGGER.debug(null, "resolveCachePersistenceDirName", "default cache persistence directory \"\tmp\" is being used");
                cachePersistenceDirName = "\tmp";
                if (!this.resolveDirectory(cachePersistenceDirName)) {
                    cachePersistenceDirName = null;
                }
            }
        }
        if (cachePersistenceDirName != null && !cachePersistenceDirName.endsWith(File.separator)) {
            cachePersistenceDirName = cachePersistenceDirName.concat(File.separator);
        }
        return cachePersistenceDirName;
    }

    private boolean resolveDirectory(String dirName) {
        boolean created;
        block6: {
            created = false;
            try {
                File f = new File(dirName);
                try {
                    if (!f.exists()) {
                        LOGGER.debug((URI)null, "createDirectory", "cache persistence directory [{}] does not exist, attempting to create", (Object)dirName);
                        f.mkdirs();
                        created = true;
                        break block6;
                    }
                    if (!f.isDirectory()) {
                        LOGGER.warn((URI)null, "createDirectory", "cache persistence directory [{}] in the configuration is not a directory, probably some file exists with the same name", (Object)dirName);
                        break block6;
                    }
                    created = true;
                }
                catch (SecurityException se) {
                    LOGGER.warn((URI)null, "createDirectory", "cache persistence directory [{}] creation failed! Proper access privilege needs to be provided", (Object)dirName);
                }
            }
            catch (NullPointerException npe) {
                LOGGER.warn((URI)null, "createDirectory", "cache persistence directory - [{}] creation failed!", (Object)dirName);
            }
        }
        return created;
    }

    @Override
    public boolean isStale(DME2Cache cache, DME2Configuration config) {
        File cachePersistentFile = this.resolveCachePersistenceFile(cache, config, false);
        if (cachePersistentFile == null) {
            LOGGER.warn((URI)null, "load", "persistent store reference was not provided to check stale persistent cache []", (Object)(cache != null ? cache.getCacheName() : "null"));
        } else if (System.currentTimeMillis() - cachePersistentFile.lastModified() > config.getLong("CACHE_SERIALIZED_FILE_STALE_TIME_MS")) {
            return true;
        }
        return false;
    }

    private CacheElement.Value convertMapToJson(DME2Cache cache, Map jsonMap) {
        CacheElement.Value<Serializable> v = null;
        String json = "";
        try {
            ObjectMapper mapper = new ObjectMapper();
            json = mapper.writeValueAsString(jsonMap);
            switch (cache.getCacheConfig().getCacheType().getName()) {
                case "EndpointCache": {
                    DME2ServiceEndpointData dME3ServiceEndpointData = mapper.readValue(json, DME2ServiceEndpointData.class);
                    v = new CacheElement.Value<DME2ServiceEndpointData>(dME3ServiceEndpointData);
                    break;
                }
                case "RouteInfoCache": {
                    DME2RouteInfo dME3RouteInfo = mapper.readValue(json, DME2RouteInfo.class);
                    v = new CacheElement.Value<DME2RouteInfo>(dME3RouteInfo);
                    break;
                }
            }
        }
        catch (JsonGenerationException e) {
            throw new CacheException(CacheException.ErrorCatalogue.CACHE_023, (Throwable)e, e.getMessage());
        }
        catch (JsonMappingException e) {
            throw new CacheException(CacheException.ErrorCatalogue.CACHE_023, (Throwable)e, e.getMessage());
        }
        catch (IOException e) {
            throw new CacheException(CacheException.ErrorCatalogue.CACHE_023, (Throwable)e, e.getMessage());
        }
        return v;
    }
}

