/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.config;

import com.att.aft.dme2.internal.apache.commons.configuration.PropertiesConfiguration;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.scld.config.ConfigurationManager;
import com.att.aft.scld.config.exception.ConfigException;
import com.att.aft.scld.config.strategy.ConfigurationStrategy;
import java.net.URI;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class DME2Configuration {
    public static final String DME2_DEFAULT_CONFIG_FILE_NAME = "dme-api_defaultConfigs.properties";
    public static final String DME2_DEFAULT_CONFIG_MANAGER_NAME = "dme2_config_manager";
    private static final Logger logger = LoggerFactory.getLogger(DME2Configuration.class.getName());
    private ConfigurationManager configManager = null;
    private Properties properties = null;
    private String managerName;

    public DME2Configuration() {
        try {
            this.configManager = ConfigurationManager.getInstance(DME2_DEFAULT_CONFIG_MANAGER_NAME, DME2_DEFAULT_CONFIG_FILE_NAME);
        }
        catch (ConfigException e) {
            logger.error((URI)null, "stop", LogMessage.CONFIGURATION_ERROR, (Object)e);
        }
    }

    public DME2Configuration(String managerName) {
        try {
            this.managerName = managerName;
            this.configManager = ConfigurationManager.getInstance(managerName, DME2_DEFAULT_CONFIG_FILE_NAME);
        }
        catch (ConfigException e) {
            logger.error((URI)null, "stop", LogMessage.CONFIGURATION_ERROR, (Object)e);
        }
    }

    public DME2Configuration(String managerName, String fileName) {
        try {
            this.managerName = managerName;
            this.configManager = ConfigurationManager.getInstance(managerName, DME2_DEFAULT_CONFIG_FILE_NAME, fileName);
        }
        catch (ConfigException e) {
            logger.error((URI)null, "stop", LogMessage.CONFIGURATION_ERROR, (Object)e);
        }
    }

    public DME2Configuration(String managerName, String defaultConfigFileName, String fileName) {
        try {
            this.managerName = managerName;
            this.configManager = ConfigurationManager.getInstance(managerName, defaultConfigFileName, fileName);
        }
        catch (ConfigException e) {
            logger.error((URI)null, "stop", LogMessage.CONFIGURATION_ERROR, (Object)e);
        }
    }

    public DME2Configuration(String managerName, List<String> defaultConfigFileNames, String fileName) {
        try {
            this.managerName = managerName;
            this.configManager = ConfigurationManager.getInstance(managerName, defaultConfigFileNames, fileName, null, null);
        }
        catch (ConfigException e) {
            logger.error((URI)null, "stop", LogMessage.CONFIGURATION_ERROR, (Object)e);
        }
    }

    public DME2Configuration(String managerName, List<String> defaultConfigFileNames, String fileName, Properties properties) {
        try {
            this.managerName = managerName;
            this.properties = properties;
            PropertiesConfiguration propsConfig = new PropertiesConfiguration();
            propsConfig.setDelimiterParsingDisabled(true);
            if (properties != null) {
                Enumeration<Object> em = properties.keys();
                while (em.hasMoreElements()) {
                    String key = (String)em.nextElement();
                    propsConfig.setProperty(key, properties.getProperty(key));
                }
            }
            this.configManager = ConfigurationManager.getInstance(managerName, defaultConfigFileNames, fileName, null, propsConfig);
        }
        catch (ConfigException e) {
            logger.error((URI)null, "stop", LogMessage.CONFIGURATION_ERROR, (Object)e);
        }
    }

    public DME2Configuration(String managerName, String defaultConfigFileName, List<ConfigurationStrategy> configCommands) {
        try {
            this.managerName = managerName;
            this.configManager = ConfigurationManager.getInstance(managerName, defaultConfigFileName, configCommands);
        }
        catch (ConfigException e) {
            logger.error((URI)null, "stop", LogMessage.CONFIGURATION_ERROR, (Object)e);
        }
    }

    public DME2Configuration(String managerName, String defaultConfigFileName, PropertiesConfiguration userPropsConfig) {
        try {
            this.managerName = managerName;
            this.configManager = ConfigurationManager.getInstance(managerName, defaultConfigFileName, userPropsConfig);
        }
        catch (ConfigException e) {
            logger.error((URI)null, "stop", LogMessage.CONFIGURATION_ERROR, (Object)e);
        }
    }

    public DME2Configuration(String managerName, Properties properties) {
        try {
            this.managerName = managerName;
            this.properties = properties;
            PropertiesConfiguration propsConfig = new PropertiesConfiguration();
            propsConfig.setDelimiterParsingDisabled(true);
            Enumeration<Object> em = properties.keys();
            while (em.hasMoreElements()) {
                String key = (String)em.nextElement();
                propsConfig.setProperty(key, properties.getProperty(key));
            }
            this.configManager = ConfigurationManager.getInstance(managerName, DME2_DEFAULT_CONFIG_FILE_NAME, propsConfig);
        }
        catch (ConfigException e) {
            logger.error((URI)null, "stop", LogMessage.CONFIGURATION_ERROR, (Object)e);
            try {
                this.configManager = ConfigurationManager.getInstance(managerName);
            }
            catch (ConfigException e2) {
                logger.error((URI)null, "stop", LogMessage.CONFIGURATION_ERROR, (Object)e2);
            }
        }
    }

    public DME2Configuration(String managerName, String defaultConfigFileName, String fileName, List<ConfigurationStrategy> configCommands, PropertiesConfiguration userPropsConfig) {
        try {
            this.managerName = managerName;
            this.configManager = ConfigurationManager.getInstance(managerName, defaultConfigFileName, fileName, configCommands, userPropsConfig);
        }
        catch (ConfigException e) {
            logger.error((URI)null, "stop", LogMessage.CONFIGURATION_ERROR, (Object)e);
        }
    }

    public String getProperty(String propertyName) {
        return this.configManager.getProperty(propertyName);
    }

    public String getProperty(String propertyName, String defaultValue) {
        return this.configManager.getProperty(propertyName, defaultValue);
    }

    public int getInt(String propertyName) {
        return this.configManager.getInt(propertyName);
    }

    public int getInt(String propertyName, int defaultValue) {
        return this.configManager.getInt(propertyName, defaultValue);
    }

    public Integer getInteger(String propertyName, Integer defaultValue) {
        String value = this.configManager.getProperty(propertyName);
        if (value != null && !value.equalsIgnoreCase("")) {
            return Integer.parseInt(value);
        }
        return defaultValue;
    }

    public float getFloat(String propertyName) {
        return this.configManager.getFloat(propertyName);
    }

    public float getFloat(String propertyName, float defaultValue) {
        return this.configManager.getFloat(propertyName, defaultValue);
    }

    public long getLong(String propertyName) {
        return this.configManager.getLong(propertyName);
    }

    public long getLong(String propertyName, long defaultValue) {
        return this.configManager.getLong(propertyName, defaultValue);
    }

    public boolean getBoolean(String propertyName) {
        return this.configManager.getBoolean(propertyName);
    }

    public boolean getBoolean(String propertyName, boolean defaultValue) {
        return this.configManager.getBoolean(propertyName, defaultValue);
    }

    public Double getDouble(String propertyName) {
        return this.configManager.getDouble(propertyName);
    }

    public Double getDouble(String propertyName, double defaultValue) {
        return this.configManager.getDouble(propertyName, defaultValue);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getManagerName() {
        return this.managerName;
    }

    public void setManagerName(String managerName) {
        this.managerName = managerName;
    }

    public void setOverrideProperty(String key, String value) {
        this.configManager.setPropertyforJmx(key, value);
    }
}

