/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.event;

import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.event.DME2Event;
import com.att.aft.dme2.event.DME2EventDispatcher;
import com.att.aft.dme2.event.DME2FailoverEventProcessor;
import com.att.aft.dme2.event.DME2InitEventProcessor;
import com.att.aft.dme2.event.DME2ReplyEventProcessor;
import com.att.aft.dme2.event.DME2RequestEventProcessor;
import com.att.aft.dme2.event.EventManager;
import com.att.aft.dme2.event.EventProcessor;
import com.att.aft.dme2.event.EventQueue;
import com.att.aft.dme2.event.EventType;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class DME2EventManager
implements EventManager {
    private static final Logger logger = LoggerFactory.getLogger(DME2EventManager.class.getName());
    private DME2Configuration config;
    private EventQueue eventQueue;
    private ConcurrentHashMap<String, ArrayList<EventProcessor>> listenersMap = new ConcurrentHashMap();
    private DME2EventDispatcher dispatcher;
    private static volatile DME2EventManager INSTANCE;

    private DME2EventManager(DME2Configuration config) {
        this.config = config;
        int eventQueueSize = config.getInt("AFT_DME2_EVENT_QUEUE_SIZE");
        logger.debug((URI)null, "ctor(DME2Configuration)", "inside method DME2EventManager() - eventQueueSize : {}", (Object)eventQueueSize);
        this.eventQueue = new EventQueue(eventQueueSize);
        this.dispatcher = new DME2EventDispatcher(config, this.eventQueue);
        this.dispatcher.setEventManager(this);
    }

    public void initDME2EventManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DME2EventManager getInstance(DME2Configuration config) {
        DME2EventManager result = INSTANCE;
        if (result != null) return result;
        Class<DME2EventManager> clazz = DME2EventManager.class;
        synchronized (DME2EventManager.class) {
            result = INSTANCE;
            if (result != null) return result;
            INSTANCE = result = new DME2EventManager(config);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    public boolean isQueueEmpty() {
        long total = this.eventQueue.getSize();
        return total <= 0L;
    }

    @Override
    public void postEvent(DME2Event event) {
        try {
            logger.debug((URI)null, "postEvent", "inside method postEvent ", (Object)event);
            this.eventQueue.addEvent(event);
        }
        catch (Exception ex) {
            logger.error((URI)null, "inside method postEvent", "unknown error ", (Object)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerEventProcessor(String eventType, EventProcessor listener) {
        ConcurrentHashMap<String, ArrayList<EventProcessor>> concurrentHashMap = this.listenersMap;
        synchronized (concurrentHashMap) {
            ArrayList<EventProcessor> procesorsList = this.listenersMap.get(eventType);
            if (procesorsList == null) {
                logger.debug((URI)null, "registerEventProcessor", "inside method registerEventProcessor {}", (Object)eventType);
                procesorsList = new ArrayList();
                this.listenersMap.put(eventType, procesorsList);
            }
            if (procesorsList.size() == 0) {
                procesorsList.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unRegisterEventProcessor(String eventType, EventProcessor listener) {
        ConcurrentHashMap<String, ArrayList<EventProcessor>> concurrentHashMap = this.listenersMap;
        synchronized (concurrentHashMap) {
            ArrayList<EventProcessor> procesorsList = this.listenersMap.get(eventType);
            logger.debug((URI)null, "unRegisterEventProcessor", "inside method unRegisterEventProcessor {}", (Object)(procesorsList == null ? 0 : procesorsList.size()));
            if (procesorsList != null && listener != null) {
                logger.debug((URI)null, "unRegisterEventProcessor", "inside method unRegisterEventProcessor {}", (Object)eventType);
                procesorsList.remove(listener);
            }
        }
    }

    @Override
    public ArrayList<EventProcessor> getListeners(String eventType) {
        ArrayList<EventProcessor> procesorsList = this.listenersMap.get(eventType);
        return procesorsList;
    }

    public int getQueueSize() {
        return this.eventQueue.getSize();
    }

    public DME2EventDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public static void main(String[] args) {
        DME2Configuration config = new DME2Configuration();
        DME2EventManager eventManager = new DME2EventManager(config);
        DME2InitEventProcessor initProcessor = new DME2InitEventProcessor(config);
        DME2RequestEventProcessor reqProcessor = new DME2RequestEventProcessor(config);
        DME2ReplyEventProcessor resProcessor = new DME2ReplyEventProcessor(config);
        DME2FailoverEventProcessor failProcessor = new DME2FailoverEventProcessor(config);
        eventManager.registerEventProcessor(EventType.REQUEST_EVENT.getName(), reqProcessor);
        eventManager.registerEventProcessor(EventType.REPLY_EVENT.getName(), resProcessor);
        eventManager.registerEventProcessor(EventType.INIT_EVENT.getName(), initProcessor);
        eventManager.registerEventProcessor(EventType.FAILOVER_EVENT.getName(), failProcessor);
        HashMap<String, Object> props = null;
        for (int i = 0; i < 101; ++i) {
            try {
                int k = 0;
                DME2Event event = new DME2Event();
                event.setType(EventType.INIT_EVENT);
                event.setMessageId("" + i + ":" + k);
                event.setReqMsgSize(i);
                event.setQueueName("test");
                event.setElapsedTime(i);
                event.setElapsedTime(i);
                event.setProtocol("http");
                event.setClientAddress("clientAddress");
                event.setEventTime(System.currentTimeMillis());
                eventManager.postEvent(event);
                logger.debug((URI)null, "main", "adding event - {}:{}", (Object)i, (Object)k);
                event = new DME2Event();
                event.setType(EventType.REQUEST_EVENT);
                event.setMessageId("" + i + ":" + ++k);
                event.setReqMsgSize(i);
                event.setQueueName("test");
                event.setElapsedTime(i);
                event.setElapsedTime(i);
                event.setProtocol("http");
                event.setClientAddress("clientAddress");
                event.setEventTime(System.currentTimeMillis());
                eventManager.postEvent(event);
                logger.debug((URI)null, "main", "adding event - {}:{}", (Object)i, (Object)k);
                event = new DME2Event();
                event.setType(EventType.FAILOVER_EVENT);
                event.setMessageId("" + i + ":" + ++k);
                event.setReqMsgSize(i);
                event.setQueueName("test");
                event.setInterfacePort("9090");
                event.setElapsedTime(i);
                event.setProtocol("http");
                event.setClientAddress("clientAddress");
                event.setEventTime(System.currentTimeMillis());
                eventManager.postEvent(event);
                logger.debug((URI)null, "main", "adding event - {}:{}", (Object)i, (Object)k);
                event = new DME2Event();
                event.setMessageId("" + i + ":" + ++k);
                event.setType(EventType.REPLY_EVENT);
                event.setMessageId("" + i + ":" + k);
                event.setReplyMsgSize(i);
                event.setQueueName("test");
                event.setElapsedTime(i);
                event.setElapsedTime(i);
                event.setProtocol("http");
                event.setClientAddress("clientAddress");
                event.setEventTime(System.currentTimeMillis());
                eventManager.postEvent(event);
                event.setEventProps(props);
                eventManager.postEvent(event);
                logger.debug((URI)null, "main", "adding event - {}:{}", (Object)i, (Object)k);
                ++k;
                if (i % 100 != 1) continue;
                Thread.sleep(1000L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            Thread.sleep(1L);
            logger.debug(null, null, "main method - destroying worker threads");
            DME2EventDispatcher.setStopThreads(true);
        }
        catch (Exception e) {
            logger.error((URI)null, (String)null, "main method - destroying worker threads", (Object)e);
        }
    }
}

