/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.event;

import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.event.BaseMetricsPublisher;
import com.att.aft.dme2.event.DME2Event;
import com.att.aft.dme2.event.DME2ServiceStatManager;
import com.att.aft.dme2.event.DME2ServiceStats;
import com.att.aft.dme2.event.EventProcessingException;
import com.att.aft.dme2.event.EventProcessor;
import com.att.aft.dme2.event.EventType;
import com.att.aft.dme2.event.MetricsPublisherFactory;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.DME2Constants;
import com.att.aft.dme2.util.DME2Utils;
import java.net.URI;

public class DME2FaultEventProcessor
implements EventProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DME2FaultEventProcessor.class.getName());
    private DME2Configuration config;

    public DME2FaultEventProcessor(DME2Configuration config) {
        this.config = config;
    }

    @Override
    public void handleEvent(DME2Event event) throws EventProcessingException {
        logger.info(null, null, "enter method - handleEvent");
        try {
            if (!EventType.FAULT_EVENT.equals((Object)event.getType())) {
                return;
            }
            logger.info(null, null, "inside handleEvent of FaultEvent Type");
            this.addFaultEvent(event);
        }
        catch (Throwable e) {
            logger.error((URI)null, (String)null, "error inside Fault eventHandler ", (Object)e);
        }
        logger.info(null, null, "exit method - handleEvent");
    }

    public void addFaultEvent(DME2Event event) throws Exception {
        logger.info(null, null, "enter method - addFaultEvent");
        String queueName = event.getQueueName();
        if (!DME2Utils.isInIgnoreList(this.config, queueName)) {
            String msgId = event.getMessageId();
            long elapsed = event.getElapsedTime();
            String role = event.getRole();
            String partner = event.getPartner();
            if (partner == null) {
                partner = DME2Constants.DEFAULT_NA_VALUE;
            }
            if (role == null) {
                role = this.config.getProperty("AFT_DME2_INTERFACE_SERVER_ROLE");
            }
            logger.info((URI)null, "addFaultEvent", " inside method addFaultEvent - msgid : {}", (Object)msgId);
            String protocol = event.getProtocol();
            if (protocol == null) {
                protocol = this.config.getProperty("AFT_DME2_INTERFACE_JMS_PROTOCOL");
            }
            String port = event.getInterfacePort();
            DME2ServiceStats ss = DME2ServiceStatManager.getInstance(this.config).getServiceStats(event.getQueueName());
            if (!DME2ServiceStatManager.getInstance(this.config).isDisableMetrics()) {
                logger.debug((URI)null, "addFaultEvent", "{},{},{},{},{},{},{},{},{},{}", new Object[]{System.currentTimeMillis(), ss.service, ss.serviceVersion, role, port, protocol, EventType.REPLY_EVENT, msgId, elapsed, elapsed});
                logger.debug(null, "addFaultEvent", "MetricsCollectorFactory.getMetricsCollector containerName={},containerVersion={},containerRO={},containerEnv={},containerPlat={},containerHost={},containerPid={}", ss.containerName, ss.containerVersion, ss.containerRO, ss.containerEnv, ss.containerPlat, ss.containerHost, ss.containerPid);
                MetricsPublisherFactory.getInstance();
                BaseMetricsPublisher metricsPublisher = MetricsPublisherFactory.getBaseMetricsPublisherHandlerInstance(this.config);
                metricsPublisher.publishEvent(event, ss);
            }
        }
        logger.info(null, null, "exit method - addFaultEvent");
    }
}

