/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.event;

import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.event.DME2Event;
import com.att.aft.dme2.event.DME2ServiceStatManager;
import com.att.aft.dme2.event.DME2ServiceStats;
import com.att.aft.dme2.event.EventProcessingException;
import com.att.aft.dme2.event.EventProcessor;
import com.att.aft.dme2.event.EventType;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.DME2Utils;
import java.net.URI;

public class DME2InitEventProcessor
implements EventProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DME2InitEventProcessor.class.getName());
    private DME2Configuration config;

    public DME2InitEventProcessor(DME2Configuration config) {
        this.config = config;
    }

    @Override
    public void handleEvent(DME2Event event) throws EventProcessingException {
        logger.info(null, "handleEvent", "enter method - handleEvent");
        try {
            if (!EventType.INIT_EVENT.equals((Object)event.getType())) {
                return;
            }
            logger.info(null, "handleEvent", "inside handleEvent of Init Event Type");
            this.addInitEvent(event);
        }
        catch (Throwable e) {
            logger.error((URI)null, "handleEvent", "error inside Init handleEvent", (Object)e);
        }
        logger.info(null, "handleEvent", "exit method - handleEvent");
    }

    public void addInitEvent(DME2Event event) {
        logger.info(null, "addInitEvent", "enter method - addInitEvent");
        String queueName = event.getQueueName();
        if (!DME2Utils.isInIgnoreList(this.config, queueName)) {
            long eventTime = System.currentTimeMillis();
            DME2ServiceStats ss = DME2ServiceStatManager.getInstance(this.config).getServiceStats(event.getQueueName());
            if (ss.lastTouchedTime < eventTime) {
                logger.info(null, "addInitEvent", "inside method - addInitEvent : Changing lastTouchedTime");
                ss.lastTouchedTime = eventTime;
            }
        }
        logger.info(null, "addInitEvent", "exit method - addInitEvent");
    }
}

