/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.event;

import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.event.DME2Event;
import com.att.aft.dme2.event.DME2ServiceStats;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class DME2ServiceStatManager
implements Runnable {
    static ConcurrentHashMap<String, DME2ServiceStats> instanceMap = new ConcurrentHashMap();
    private static ArrayList<String> queueNames = new ArrayList();
    static final Map<String, DME2Event> requestMap = Collections.synchronizedMap(new HashMap());
    private DME2Configuration config;
    private long checkInterval = 120L;
    private long expiryInterval = 300L;
    private byte[] statsObjLock = new byte[0];
    private byte[] instanceObjLock = new byte[0];
    private static Logger logger = LoggerFactory.getLogger(DME2ServiceStatManager.class.getName());
    private boolean timerInitiated = false;
    private static DME2ServiceStatManager INSTANCE;
    private boolean disableMetrics = false;
    private int expiredCount;
    private boolean disableCleanup = false;
    private Timer expiredMsgs;

    public boolean isDisableCleanup() {
        return this.disableCleanup;
    }

    public void setDisableCleanup(boolean disableCleanup) {
        this.disableCleanup = disableCleanup;
    }

    public static ArrayList<String> getQueueNames() {
        return queueNames;
    }

    public static void setQueueNames(ArrayList<String> tempQueueNames) {
        queueNames = tempQueueNames;
    }

    public long getCheckInterval() {
        return this.checkInterval;
    }

    public byte[] getStatsObjLock() {
        return this.statsObjLock;
    }

    public byte[] getInstanceObjLock() {
        return this.instanceObjLock;
    }

    public boolean isTimerInitiated() {
        return this.timerInitiated;
    }

    public boolean isDisableMetrics() {
        return this.disableMetrics;
    }

    public void setDisableMetrics(boolean tempDisableMetrics) {
        this.disableMetrics = tempDisableMetrics;
    }

    public int getExpiredCount() {
        return this.expiredCount;
    }

    public void setExpiredCount(int expiredCount) {
        this.expiredCount = expiredCount;
    }

    private DME2ServiceStatManager(DME2Configuration config) {
        this.config = config;
        try {
            this.checkInterval = Long.parseLong(config.getProperty("DME2_QS_TIMER_INT"));
        }
        catch (Exception e) {
            this.checkInterval = 120L;
        }
        try {
            this.expiryInterval = Long.parseLong(config.getProperty("DME2_QS_MSGEXP_INT"));
        }
        catch (Exception e) {
            this.expiryInterval = 300L;
        }
        try {
            this.disableMetrics = Boolean.parseBoolean(config.getProperty("AFT_DME2_DISABLE_METRICS"));
            logger.debug((URI)null, "ctor(DME2Configuration)", "inside DME2ServiceStatManager - setting disableMetrics flag : {}", (Object)this.disableMetrics);
        }
        catch (Exception e) {
            this.disableMetrics = false;
        }
        if (!this.timerInitiated) {
            this.expiredMsgs = new Timer("DME2::DME2QueueStats::FindExpiredMessagesTimer", true);
            logger.debug(null, "DME2ServiceStatManager", "inside DME2ServiceStatManager - creating expiredMessageCleanup Schedule Task");
            try {
                this.expiredMsgs.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        logger.debug((URI)null, "ctor(DME2Configuration)", "inside FindExpiredMessagesTimer = checkInterval : {} - expiryInterval : {}", (Object)DME2ServiceStatManager.this.checkInterval, (Object)DME2ServiceStatManager.this.expiryInterval);
                        DME2ServiceStatManager.this.cleanUpExpiredMessage();
                    }
                }, this.checkInterval * 1000L, this.checkInterval * 1000L);
                this.timerInitiated = true;
            }
            catch (Exception e) {
                logger.error((URI)null, "ctor(DME2Configuration)", LogMessage.Q_STATS_FAILED, (Object)e);
                logger.error((URI)null, "ctor(DME2Configuration)", "Error in creating Scheduled Task", (Object)e);
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(this));
    }

    public static ArrayList<String> getServiceNames() {
        return queueNames;
    }

    public String[] diagnostics() throws Exception {
        logger.debug(null, "diagnostics", "entering diagnostics method");
        ArrayList<String> retList = new ArrayList<String>();
        Object[] retStr = null;
        try {
            Iterator<String> it = DME2ServiceStatManager.getServiceNames().iterator();
            while (it.hasNext()) {
                boolean ignoreQueue = false;
                String serviceName = it.next();
                String[] splitStr = this.config.getProperty("AFT_DME2_QLIST_IGNORE").split(",");
                for (int i = 0; i < splitStr.length; ++i) {
                    if (serviceName == null || !serviceName.contains(splitStr[i])) continue;
                    ignoreQueue = true;
                    break;
                }
                if (ignoreQueue) continue;
                DME2ServiceStats sstats = this.getServiceStats(serviceName);
                String[] statsArr = sstats.getStats();
                for (int j = 0; j < statsArr.length; ++j) {
                    retList.add(statsArr[j]);
                }
            }
        }
        catch (Exception e) {
            logger.error((URI)null, "diagnostics", "Error in diagnostics() ", (Object)e);
        }
        retStr = new String[retList.size()];
        logger.debug((URI)null, "diagnostics", "exiting diagnostics method - retStr :{}", retStr);
        return (String[])retList.toArray(retStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DME2ServiceStats getServiceStats(String serviceName) {
        ConcurrentHashMap<String, DME2ServiceStats> concurrentHashMap = instanceMap;
        synchronized (concurrentHashMap) {
            if (instanceMap.get(serviceName) != null) {
                return instanceMap.get(serviceName);
            }
            DME2ServiceStats instance = new DME2ServiceStats(this.config, serviceName);
            instanceMap.put(serviceName, instance);
            if (serviceName != null && serviceName.indexOf("service=") != -1) {
                queueNames.add(serviceName);
            }
            return instance;
        }
    }

    public long getExpiryInterval() {
        return this.expiryInterval;
    }

    public ConcurrentHashMap<String, DME2ServiceStats> getInstanceMap() {
        return instanceMap;
    }

    public Map<String, DME2Event> getRequestmap() {
        return requestMap;
    }

    public void setExpiryInterval(long tempExpiryInterval) {
        this.expiryInterval = tempExpiryInterval;
    }

    public String[] getStats(String serviceName) {
        DME2ServiceStats ss = this.getServiceStats(serviceName);
        return ss.getStats();
    }

    private boolean isCurrentHourMillis(long millis) {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        Calendar cal1 = Calendar.getInstance(TimeZone.getDefault());
        cal1.setTimeInMillis(millis);
        return cal1.get(11) == cal.get(11);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void cleanUpExpiredMessage() {
        logger.debug((URI)null, "cleanUpExpiredMessage", "entering cleanUpExpiredMessage() - disableCleanup : {}", (Object)this.disableCleanup);
        if (!this.disableCleanup) {
            byte[] byArray = this.statsObjLock;
            // MONITORENTER : this.statsObjLock
            Set<String> set = requestMap.keySet();
            logger.debug(null, "cleanUpExpiredMessage", "DME2ServiceStatManager cleanUpExpiredMessage requestMap size={}  ; expiredMessagesCount={}; hashCode={}", instanceMap.size(), this.expiredCount, instanceMap.hashCode());
            try {
                if (set != null) {
                    ArrayList<String> expiredIdList = new ArrayList<String>();
                    expiredIdList.addAll(set);
                    for (String msgId : expiredIdList) {
                        DME2Event data = requestMap.get(msgId);
                        long eventTime = data.getEventTime();
                        if (eventTime + this.expiryInterval * 1000L > System.currentTimeMillis()) continue;
                        ++this.expiredCount;
                        requestMap.remove(msgId);
                        logger.debug((URI)null, "cleanUpExpiredMessage", "inside cleanUpExpiredMessage() : incrementing expiredCount : {} and deleting msgId : {}", (Object)this.expiredCount, (Object)msgId);
                    }
                }
            }
            catch (Exception e) {
                logger.debug((URI)null, "cleanUpExpiredMessage", "AFT-DME2-1902", (Object)new ErrorContext().add("queueName", queueNames.toString()).add("extendedMessage", e.getMessage()), (Object)e);
            }
        }
        logger.debug(null, "cleanUpExpiredMessage", "exiting cleanUpExpiredMessage() ");
    }

    public static DME2ServiceStatManager getInstance(DME2Configuration config) {
        if (INSTANCE == null) {
            INSTANCE = new DME2ServiceStatManager(config);
        }
        return INSTANCE;
    }

    @Override
    public void run() {
        logger.debug(null, "run", LogMessage.METHOD_ENTER);
        if (this.expiredMsgs != null) {
            logger.debug(null, "run", "Shutting down timer task");
            this.expiredMsgs.cancel();
        }
        logger.debug(null, "run", LogMessage.METHOD_EXIT);
    }
}

