/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.event;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.event.BaseMetricsPublisher;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.net.URI;

public class MetricsPublisherFactory {
    private static String metricsPublisherHandlerClassName = null;
    private static BaseMetricsPublisher metricsPublisherHandler = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsPublisherFactory.class.getName());
    private static MetricsPublisherFactory metricsPublisherFactory = new MetricsPublisherFactory();

    public static MetricsPublisherFactory getInstance() {
        return metricsPublisherFactory;
    }

    private static BaseMetricsPublisher createMetricsPublisherFactoryHandler(DME2Configuration configuration) throws DME2Exception {
        try {
            Object metricsPublisherHandlerObject = Class.forName(metricsPublisherHandlerClassName).getDeclaredConstructor(DME2Configuration.class).newInstance(configuration);
            if (null != metricsPublisherHandlerObject && metricsPublisherHandlerObject instanceof BaseMetricsPublisher) {
                return (BaseMetricsPublisher)metricsPublisherHandlerObject;
            }
            ErrorContext ec = new ErrorContext();
            ec.add("HandlerObject must implement interface - " + BaseMetricsPublisher.class.getName(), "HandlerObject must implement interface - " + BaseMetricsPublisher.class.getName());
            LOGGER.error((URI)null, "HandlerObject must implement interface - " + BaseMetricsPublisher.class.getName(), "AFT-DME2-9000", (Object)ec);
            throw new DME2Exception("AFT-DME2-9000", ec);
        }
        catch (Exception e) {
            LOGGER.error(null, "createMetricsPublisherFactoryHandler", "{} {} {}", BaseMetricsPublisher.class.getName(), " implementation Class can't be instantiated", "AFT-DME2-9000", e);
            throw new DME2Exception(BaseMetricsPublisher.class.getName() + " implementation Class can't be instantiated", e);
        }
    }

    public static BaseMetricsPublisher getBaseMetricsPublisherHandlerInstance(DME2Configuration configuration) throws DME2Exception {
        if (null == metricsPublisherHandler && null != (metricsPublisherHandlerClassName = configuration.getProperty("METRICS_PUBLISHER_HANDLER_IMPL")) && null == metricsPublisherHandler) {
            metricsPublisherHandler = MetricsPublisherFactory.createMetricsPublisherFactoryHandler(configuration);
        }
        return metricsPublisherHandler;
    }
}

