/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.factory;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.cache.domain.CacheTypeElement;
import com.att.aft.dme2.cache.domain.CacheTypes;
import com.att.aft.dme2.cache.exception.CacheException;
import com.att.aft.dme2.cache.handler.service.CacheEventHandler;
import com.att.aft.dme2.cache.handler.service.CacheableDataHandler;
import com.att.aft.dme2.cache.service.CacheSerialization;
import com.att.aft.dme2.cache.service.DME2Cache;
import com.att.aft.dme2.cache.service.DME2CacheManager;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;

public class DME2CacheFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DME2CacheFactory.class.getName());

    private DME2CacheFactory() {
    }

    public static CacheSerialization getCacheSerializer(DME2Cache cache, DME2Configuration config, boolean isEndpointCache) throws DME2Exception {
        CacheSerialization cacheSerializationInstance = null;
        String userClass = config.getProperty("CACHE_SERIALIZER_CLASS");
        LOGGER.debug((URI)null, "getCacheSerializer", "Attempting to instantiate cache serializer{}", (Object)userClass);
        try {
            cacheSerializationInstance = (CacheSerialization)Class.forName(userClass).getDeclaredConstructor(DME2Cache.class, DME2Configuration.class, Boolean.TYPE).newInstance(cache, config, isEndpointCache);
            LOGGER.debug((URI)null, "getCacheManager", "created: cacheManagerInstance [{}];", (Object)cacheSerializationInstance);
            if (null != cacheSerializationInstance && cacheSerializationInstance instanceof CacheSerialization) {
                LOGGER.debug(null, "getCacheManager", "end:success");
                return cacheSerializationInstance;
            }
            ErrorContext ec = new ErrorContext();
            ec.add(" cache serializer Class can't be instantiated" + userClass, "cache serializer Class must implement - " + userClass);
            LOGGER.error((URI)null, "cache serializer Class must implement - " + userClass, "AFT-DME2-9000", (Object)ec);
            LOGGER.debug(null, "getCacheSerializer", "end:failure");
            throw new DME2Exception("AFT-DME2-9000", ec);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.error(null, "getCacheSerializer", "{} {} {}", userClass, " cache serializer Class can't be instantiated", "AFT-DME2-9000", e);
            LOGGER.debug(null, "getCacheSerializer", "end:failure");
            throw new DME2Exception(userClass + " cache serializer Class can't be instantiated", e);
        }
    }

    public static DME2CacheManager getCacheManager(DME2Configuration config) throws DME2Exception {
        Object cacheManagerInstance = null;
        String userCacheClass = config.getProperty("DME2_CACHE_MANAGER");
        LOGGER.debug((URI)null, "getCacheManager", "Attempting to instantiate cache {}", (Object)userCacheClass);
        try {
            Method getInstanceMethod = Class.forName(userCacheClass).getDeclaredMethod("getInstance", DME2Configuration.class);
            cacheManagerInstance = getInstanceMethod.invoke(null, config);
            LOGGER.debug((URI)null, "getCacheManager", "created: cacheManagerInstance [{}];", cacheManagerInstance);
            if (null != cacheManagerInstance && cacheManagerInstance instanceof DME2CacheManager) {
                LOGGER.debug(null, "getCacheManager", "end:success");
                return (DME2CacheManager)cacheManagerInstance;
            }
            ErrorContext ec = new ErrorContext();
            ec.add(" cache implementation Class can't be instantiated" + userCacheClass, "cache implementation Class must implement - " + userCacheClass);
            LOGGER.error((URI)null, "cache implementation Class must implement - " + userCacheClass, "AFT-DME2-9000", (Object)ec);
            LOGGER.debug(null, "getCacheManager", "end:failure");
            throw new DME2Exception("AFT-DME2-9000", ec);
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            LOGGER.error(null, "getCacheManager", "{} {} {}", userCacheClass, " cache implementation Class can't be instantiated", "AFT-DME2-9000", e);
            LOGGER.debug(null, "getCacheManager", "end:failure");
            throw new DME2Exception(userCacheClass + " cache implementation Class can't be instantiated", e);
        }
    }

    public static CacheableDataHandler getDataHandler(CacheTypeElement cacheType) {
        LOGGER.debug((URI)null, "DME2CacheFactory.getDataHandler", "start: cache [{}];", (Object)cacheType.getName());
        CacheableDataHandler dataHandler = null;
        if (cacheType != null) {
            String dataHandlerClassName = cacheType.getDataHandlerClassName();
            try {
                LOGGER.debug((URI)null, "DME2CacheFactory.getDataHandler", "cacheType.getDataHandlerClass:[{}], cache: [{}];", (Object)dataHandlerClassName, (Object)cacheType.getName());
                Object classObj = null;
                if (dataHandlerClassName != null && !dataHandlerClassName.isEmpty() && (classObj = Class.forName(dataHandlerClassName).newInstance()) instanceof CacheableDataHandler) {
                    LOGGER.debug((URI)null, "DME2CacheFactory.getDataHandler", "cacheType.obj[{}], cache: [{}];", (Object)classObj, (Object)cacheType.getName());
                    dataHandler = classObj;
                }
            }
            catch (Exception e) {
                throw new CacheException(CacheException.ErrorCatalogue.CACHE_012, e.getMessage(), cacheType.getName());
            }
            LOGGER.debug((URI)null, "DME2CacheFactory.getDataHandler", "end: cache [{}];", (Object)cacheType.getName());
        }
        return dataHandler;
    }

    public static CacheEventHandler getEventHandler(String cacheName, DME2Configuration config) {
        CacheEventHandler eventHandler = null;
        LOGGER.debug((URI)null, "DME2CacheFactory.getEventHandler", "start: [{}]", (Object)cacheName);
        CacheTypeElement cacheType = CacheTypes.getType(cacheName, config);
        if (cacheType != null) {
            String string = cacheType.getDataHandlerClassName();
        }
        LOGGER.debug((URI)null, "DME2CacheFactory.getEventHandler", "end: [{}]", (Object)cacheName);
        return eventHandler;
    }

    private static Method getMethodInstance(Object classObject, String method) {
        LOGGER.debug(null, "DME2CacheFactory.getMethodInstance", "start");
        Method methodInvoke = null;
        if (classObject != null) {
            Method[] allMethods;
            Class<?> c = classObject.getClass();
            LOGGER.debug((URI)null, "getMethodInstance", "Method: {}", (Object)c.getSimpleName());
            for (Method m : allMethods = c.getDeclaredMethods()) {
                String mname = m.getName();
                LOGGER.debug((URI)null, "DME2CacheFactory.getMethodInstance", "method: [{}]", (Object)mname);
                if (!mname.equalsIgnoreCase(method)) continue;
                LOGGER.debug((URI)null, "DME2CacheFactory.getMethodInstance", "found method [{}] as requested", (Object)method);
                m.setAccessible(true);
                methodInvoke = m;
                break;
            }
        } else {
            LOGGER.warn(null, "DME2CacheFactory.getMethodInstance", "warn - classObject is not initialized");
        }
        LOGGER.debug(null, "DME2CacheFactory.getMethodInstance", "complete");
        return methodInvoke;
    }
}

