/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.gson.internal.bind;

import com.att.aft.dme2.internal.gson.Gson;
import com.att.aft.dme2.internal.gson.JsonDeserializer;
import com.att.aft.dme2.internal.gson.JsonSerializer;
import com.att.aft.dme2.internal.gson.TypeAdapter;
import com.att.aft.dme2.internal.gson.TypeAdapterFactory;
import com.att.aft.dme2.internal.gson.annotations.JsonAdapter;
import com.att.aft.dme2.internal.gson.internal.ConstructorConstructor;
import com.att.aft.dme2.internal.gson.internal.bind.TreeTypeAdapter;
import com.att.aft.dme2.internal.gson.reflect.TypeToken;

public final class JsonAdapterAnnotationTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor constructorConstructor;

    public JsonAdapterAnnotationTypeAdapterFactory(ConstructorConstructor constructorConstructor) {
        this.constructorConstructor = constructorConstructor;
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> targetType) {
        Class<T> rawType = targetType.getRawType();
        JsonAdapter annotation = rawType.getAnnotation(JsonAdapter.class);
        if (annotation == null) {
            return null;
        }
        return this.getTypeAdapter(this.constructorConstructor, gson, targetType, annotation);
    }

    TypeAdapter<?> getTypeAdapter(ConstructorConstructor constructorConstructor, Gson gson, TypeToken<?> type, JsonAdapter annotation) {
        TypeAdapter<Object> typeAdapter;
        Object instance = constructorConstructor.get(TypeToken.get(annotation.value())).construct();
        if (instance instanceof TypeAdapter) {
            typeAdapter = (TypeAdapter)instance;
        } else if (instance instanceof TypeAdapterFactory) {
            typeAdapter = ((TypeAdapterFactory)instance).create(gson, type);
        } else if (instance instanceof JsonSerializer || instance instanceof JsonDeserializer) {
            JsonSerializer serializer = instance instanceof JsonSerializer ? (JsonSerializer)instance : null;
            JsonDeserializer deserializer = instance instanceof JsonDeserializer ? (JsonDeserializer)instance : null;
            typeAdapter = new TreeTypeAdapter(serializer, deserializer, gson, type, null);
        } else {
            throw new IllegalArgumentException("@JsonAdapter value must be TypeAdapter, TypeAdapterFactory, JsonSerializer or JsonDeserializer reference.");
        }
        if (typeAdapter != null) {
            typeAdapter = typeAdapter.nullSafe();
        }
        return typeAdapter;
    }
}

