/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.gson.internal.bind;

import com.att.aft.dme2.internal.gson.Gson;
import com.att.aft.dme2.internal.gson.JsonSyntaxException;
import com.att.aft.dme2.internal.gson.TypeAdapter;
import com.att.aft.dme2.internal.gson.TypeAdapterFactory;
import com.att.aft.dme2.internal.gson.reflect.TypeToken;
import com.att.aft.dme2.internal.gson.stream.JsonReader;
import com.att.aft.dme2.internal.gson.stream.JsonToken;
import com.att.aft.dme2.internal.gson.stream.JsonWriter;
import java.io.IOException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class TimeTypeAdapter
extends TypeAdapter<Time> {
    public static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Time.class ? new TimeTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("hh:mm:ss a");

    @Override
    public synchronized Time read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            Date date = this.format.parse(in.nextString());
            return new Time(date.getTime());
        }
        catch (ParseException e) {
            throw new JsonSyntaxException(e);
        }
    }

    @Override
    public synchronized void write(JsonWriter out, Time value) throws IOException {
        out.value(value == null ? null : this.format.format(value));
    }
}

