/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jackson.map.ser.std;

import com.att.aft.dme2.internal.jackson.JsonGenerationException;
import com.att.aft.dme2.internal.jackson.JsonGenerator;
import com.att.aft.dme2.internal.jackson.map.BeanProperty;
import com.att.aft.dme2.internal.jackson.map.JsonSerializer;
import com.att.aft.dme2.internal.jackson.map.SerializerProvider;
import com.att.aft.dme2.internal.jackson.map.TypeSerializer;
import com.att.aft.dme2.internal.jackson.map.annotate.JacksonStdImpl;
import com.att.aft.dme2.internal.jackson.map.ser.std.AsArraySerializerBase;
import com.att.aft.dme2.internal.jackson.map.ser.std.ContainerSerializerBase;
import com.att.aft.dme2.internal.jackson.type.JavaType;
import java.io.IOException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class IterableSerializer
extends AsArraySerializerBase<Iterable<?>> {
    public IterableSerializer(JavaType elemType, boolean staticTyping, TypeSerializer vts, BeanProperty property) {
        super(Iterable.class, elemType, staticTyping, vts, property, null);
    }

    @Override
    public ContainerSerializerBase<?> _withValueTypeSerializer(TypeSerializer vts) {
        return new IterableSerializer(this._elementType, this._staticTyping, vts, this._property);
    }

    @Override
    public void serializeContents(Iterable<?> value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        Iterator<?> it = value.iterator();
        if (it.hasNext()) {
            TypeSerializer typeSer = this._valueTypeSerializer;
            JsonSerializer<Object> prevSerializer = null;
            Class<?> prevClass = null;
            do {
                JsonSerializer<Object> currSerializer;
                Object elem;
                if ((elem = it.next()) == null) {
                    provider.defaultSerializeNull(jgen);
                    continue;
                }
                Class<?> cc = elem.getClass();
                if (cc == prevClass) {
                    currSerializer = prevSerializer;
                } else {
                    prevSerializer = currSerializer = provider.findValueSerializer(cc, this._property);
                    prevClass = cc;
                }
                if (typeSer == null) {
                    currSerializer.serialize(elem, jgen, provider);
                    continue;
                }
                currSerializer.serializeWithType(elem, jgen, provider, typeSer);
            } while (it.hasNext());
        }
    }
}

