/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jersey.json.impl.provider.entity;

import com.att.aft.dme2.internal.javaxwsrs.Consumes;
import com.att.aft.dme2.internal.javaxwsrs.Produces;
import com.att.aft.dme2.internal.javaxwsrs.WebApplicationException;
import com.att.aft.dme2.internal.javaxwsrs.core.MediaType;
import com.att.aft.dme2.internal.javaxwsrs.core.MultivaluedMap;
import com.att.aft.dme2.internal.jersey.json.impl.ImplMessages;
import com.att.aft.dme2.internal.jersey.json.impl.provider.entity.JSONLowLevelProvider;
import com.att.aft.dme2.internal.jettison.json.JSONArray;
import com.att.aft.dme2.internal.jettison.json.JSONException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

public class JSONArrayProvider
extends JSONLowLevelProvider<JSONArray> {
    JSONArrayProvider() {
        super(JSONArray.class);
    }

    @Override
    public JSONArray readFrom(Class<JSONArray> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            return new JSONArray(JSONArrayProvider.readFromAsString(entityStream, mediaType));
        }
        catch (JSONException je) {
            throw new WebApplicationException((Throwable)new Exception(ImplMessages.ERROR_PARSING_JSON_ARRAY(), je), 400);
        }
    }

    @Override
    public void writeTo(JSONArray t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(entityStream, JSONArrayProvider.getCharset(mediaType));
            t.write(writer);
            writer.write("\n");
            writer.flush();
        }
        catch (JSONException je) {
            throw new WebApplicationException((Throwable)new Exception(ImplMessages.ERROR_WRITING_JSON_ARRAY(), je), 500);
        }
    }

    @Produces(value={"*/*"})
    @Consumes(value={"*/*"})
    public static final class General
    extends JSONArrayProvider {
        @Override
        protected boolean isSupported(MediaType m) {
            return m.getSubtype().endsWith("+json");
        }
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public static final class App
    extends JSONArrayProvider {
    }
}

