/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.client.http;

import com.att.aft.dme2.internal.jetty.client.AbstractHttpClientTransport;
import com.att.aft.dme2.internal.jetty.client.HttpDestination;
import com.att.aft.dme2.internal.jetty.client.Origin;
import com.att.aft.dme2.internal.jetty.client.http.HttpConnectionOverHTTP;
import com.att.aft.dme2.internal.jetty.client.http.HttpDestinationOverHTTP;
import com.att.aft.dme2.internal.jetty.io.Connection;
import com.att.aft.dme2.internal.jetty.io.EndPoint;
import com.att.aft.dme2.internal.jetty.util.Promise;
import com.att.aft.dme2.internal.jetty.util.annotation.ManagedObject;
import java.io.IOException;
import java.util.Map;

@ManagedObject(value="The HTTP/1.1 client transport")
public class HttpClientTransportOverHTTP
extends AbstractHttpClientTransport {
    public HttpClientTransportOverHTTP() {
        this(Math.max(1, Runtime.getRuntime().availableProcessors() / 2));
    }

    public HttpClientTransportOverHTTP(int selectors) {
        super(selectors);
    }

    @Override
    public HttpDestination newHttpDestination(Origin origin) {
        return new HttpDestinationOverHTTP(this.getHttpClient(), origin);
    }

    @Override
    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HttpDestination destination = (HttpDestination)context.get("http.destination");
        Promise promise = (Promise)context.get("http.connection.promise");
        HttpConnectionOverHTTP connection = this.newHttpConnection(endPoint, destination, promise);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", connection);
        }
        return this.customize(connection, context);
    }

    protected HttpConnectionOverHTTP newHttpConnection(EndPoint endPoint, HttpDestination destination, Promise<com.att.aft.dme2.internal.jetty.client.api.Connection> promise) {
        return new HttpConnectionOverHTTP(endPoint, destination, promise);
    }
}

