/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.http.pathmap;

import com.att.aft.dme2.internal.jetty.http.pathmap.PathSpec;
import com.att.aft.dme2.internal.jetty.http.pathmap.RegexPathSpec;
import com.att.aft.dme2.internal.jetty.http.pathmap.ServletPathSpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;

public class PathSpecSet
implements Set<String>,
Predicate<String> {
    private final Set<PathSpec> specs = new TreeSet<PathSpec>();

    @Override
    public boolean test(String s) {
        for (PathSpec spec : this.specs) {
            if (!spec.matches(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.specs.isEmpty();
    }

    @Override
    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private Iterator<PathSpec> iter;
            {
                this.iter = PathSpecSet.this.specs.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public String next() {
                PathSpec spec = this.iter.next();
                if (spec == null) {
                    return null;
                }
                return spec.getDeclaration();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported by this Iterator");
            }
        };
    }

    @Override
    public int size() {
        return this.specs.size();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof PathSpec) {
            return this.specs.contains(o);
        }
        if (o instanceof String) {
            return this.specs.contains(this.toPathSpec((String)o));
        }
        return false;
    }

    private PathSpec asPathSpec(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof PathSpec) {
            return (PathSpec)o;
        }
        if (o instanceof String) {
            return this.toPathSpec((String)o);
        }
        return this.toPathSpec(o.toString());
    }

    private PathSpec toPathSpec(String rawSpec) {
        if (rawSpec == null || rawSpec.length() < 1) {
            throw new RuntimeException("Path Spec String must start with '^', '/', or '*.': got [" + rawSpec + "]");
        }
        if (rawSpec.charAt(0) == '^') {
            return new RegexPathSpec(rawSpec);
        }
        return new ServletPathSpec(rawSpec);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new String[this.specs.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int i = 0;
        for (PathSpec spec : this.specs) {
            a[i++] = spec.getDeclaration();
        }
        return a;
    }

    @Override
    public boolean add(String e) {
        return this.specs.add(this.toPathSpec(e));
    }

    @Override
    public boolean remove(Object o) {
        return this.specs.remove(this.asPathSpec(o));
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        for (Object o : coll) {
            if (this.specs.contains(this.asPathSpec(o))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends String> coll) {
        boolean ret = false;
        for (String string : coll) {
            ret |= this.add(string);
        }
        return ret;
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        ArrayList<PathSpec> collSpecs = new ArrayList<PathSpec>();
        for (Object o : coll) {
            collSpecs.add(this.asPathSpec(o));
        }
        return this.specs.retainAll(collSpecs);
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        ArrayList<PathSpec> collSpecs = new ArrayList<PathSpec>();
        for (Object o : coll) {
            collSpecs.add(this.asPathSpec(o));
        }
        return this.specs.removeAll(collSpecs);
    }

    @Override
    public void clear() {
        this.specs.clear();
    }
}

