/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.jaas.callback;

import com.att.aft.dme2.internal.jetty.jaas.callback.AbstractCallbackHandler;
import com.att.aft.dme2.internal.jetty.jaas.callback.ObjectCallback;
import com.att.aft.dme2.internal.jetty.jaas.callback.RequestParameterCallback;
import com.att.aft.dme2.internal.jetty.server.Request;
import com.att.aft.dme2.internal.jetty.util.security.Password;
import java.io.IOException;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class DefaultCallbackHandler
extends AbstractCallbackHandler {
    private Request _request;

    public void setRequest(Request request) {
        this._request = request;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                ((NameCallback)callbacks[i]).setName(this.getUserName());
                continue;
            }
            if (callbacks[i] instanceof ObjectCallback) {
                ((ObjectCallback)callbacks[i]).setObject(this.getCredential());
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                if (this.getCredential() instanceof Password) {
                    ((PasswordCallback)callbacks[i]).setPassword(((Password)this.getCredential()).toString().toCharArray());
                    continue;
                }
                if (this.getCredential() instanceof String) {
                    ((PasswordCallback)callbacks[i]).setPassword(((String)this.getCredential()).toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callbacks[i], "User supplied credentials cannot be converted to char[] for PasswordCallback: try using an ObjectCallback instead");
            }
            if (callbacks[i] instanceof RequestParameterCallback) {
                RequestParameterCallback callback = (RequestParameterCallback)callbacks[i];
                callback.setParameterValues(Arrays.asList(this._request.getParameterValues(callback.getParameterName())));
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }
}

