/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.util;

import com.att.aft.dme2.internal.jetty.util.log.Log;
import java.util.Objects;

public interface Promise<C> {
    public void succeeded(C var1);

    public void failed(Throwable var1);

    public static class Wrapper<W>
    implements Promise<W> {
        private final Promise<W> promise;

        public Wrapper(Promise<W> promise) {
            this.promise = Objects.requireNonNull(promise);
        }

        @Override
        public void succeeded(W result) {
            this.promise.succeeded(result);
        }

        @Override
        public void failed(Throwable x) {
            this.promise.failed(x);
        }

        public Promise<W> getPromise() {
            return this.promise;
        }

        public Promise<W> unwrap() {
            Promise<W> result = this.promise;
            while (result instanceof Wrapper) {
                result = ((Wrapper)result).unwrap();
            }
            return result;
        }
    }

    public static class Adapter<C>
    implements Promise<C> {
        @Override
        public void succeeded(C result) {
        }

        @Override
        public void failed(Throwable x) {
            Log.getLogger(this.getClass()).warn(x);
        }
    }
}

