/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.webapp;

import com.att.aft.dme2.internal.jetty.util.log.Log;
import com.att.aft.dme2.internal.jetty.util.log.Logger;
import com.att.aft.dme2.internal.jetty.util.resource.Resource;
import com.att.aft.dme2.internal.jetty.webapp.AbstractConfiguration;
import com.att.aft.dme2.internal.jetty.webapp.WebAppContext;
import com.att.aft.dme2.internal.jetty.xml.XmlConfiguration;
import java.util.Map;
import java.util.concurrent.Callable;

public class JettyWebXmlConfiguration
extends AbstractConfiguration {
    private static final Logger LOG = Log.getLogger(JettyWebXmlConfiguration.class);
    public static final String PROPERTY_THIS_WEB_INF_URL = "this.web-inf.url";
    public static final String XML_CONFIGURATION = "com.att.aft.dme2.internal.jetty.webapp.JettyWebXmlConfiguration";
    public static final String JETTY_WEB_XML = "jetty-web.xml";

    @Override
    public void configure(final WebAppContext context) throws Exception {
        if (context.isStarted()) {
            LOG.debug("Cannot configure webapp after it is started", new Object[0]);
            return;
        }
        LOG.debug("Configuring web-jetty.xml", new Object[0]);
        Resource web_inf = context.getWebInf();
        if (web_inf != null && web_inf.isDirectory()) {
            Resource jetty = web_inf.addPath("jetty8-web.xml");
            if (!jetty.exists()) {
                jetty = web_inf.addPath(JETTY_WEB_XML);
            }
            if (!jetty.exists()) {
                jetty = web_inf.addPath("web-jetty.xml");
            }
            if (jetty.exists()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Configure: " + jetty, new Object[0]);
                }
                Object xml_attr = context.getAttribute(XML_CONFIGURATION);
                context.removeAttribute(XML_CONFIGURATION);
                XmlConfiguration jetty_config = xml_attr instanceof XmlConfiguration ? (XmlConfiguration)xml_attr : new XmlConfiguration(jetty.getURI().toURL());
                this.setupXmlConfiguration(jetty_config, web_inf);
                try {
                    final XmlConfiguration config = jetty_config;
                    context.runWithoutCheckingServerClasses(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            config.configure(context);
                            return null;
                        }
                    });
                }
                catch (Exception e) {
                    LOG.warn("Error applying {}", jetty);
                    throw e;
                }
            }
        }
    }

    private void setupXmlConfiguration(XmlConfiguration jetty_config, Resource web_inf) {
        Map<String, String> props = jetty_config.getProperties();
        props.put(PROPERTY_THIS_WEB_INF_URL, String.valueOf(web_inf.getURL()));
    }
}

