/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.client.io;

import com.att.aft.dme2.internal.jetty.io.AbstractConnection;
import com.att.aft.dme2.internal.jetty.io.ByteBufferPool;
import com.att.aft.dme2.internal.jetty.io.Connection;
import com.att.aft.dme2.internal.jetty.io.EndPoint;
import com.att.aft.dme2.internal.jetty.util.BufferUtil;
import com.att.aft.dme2.internal.jetty.util.FutureCallback;
import com.att.aft.dme2.internal.jetty.util.QuotedStringTokenizer;
import com.att.aft.dme2.internal.jetty.util.log.Log;
import com.att.aft.dme2.internal.jetty.util.log.Logger;
import com.att.aft.dme2.internal.jetty.websocket.api.UpgradeException;
import com.att.aft.dme2.internal.jetty.websocket.api.WebSocketPolicy;
import com.att.aft.dme2.internal.jetty.websocket.api.extensions.ExtensionConfig;
import com.att.aft.dme2.internal.jetty.websocket.client.ClientUpgradeRequest;
import com.att.aft.dme2.internal.jetty.websocket.client.ClientUpgradeResponse;
import com.att.aft.dme2.internal.jetty.websocket.client.io.ConnectPromise;
import com.att.aft.dme2.internal.jetty.websocket.client.io.UpgradeListener;
import com.att.aft.dme2.internal.jetty.websocket.client.io.WebSocketClientConnection;
import com.att.aft.dme2.internal.jetty.websocket.common.AcceptHash;
import com.att.aft.dme2.internal.jetty.websocket.common.SessionFactory;
import com.att.aft.dme2.internal.jetty.websocket.common.WebSocketSession;
import com.att.aft.dme2.internal.jetty.websocket.common.events.EventDriver;
import com.att.aft.dme2.internal.jetty.websocket.common.extensions.ExtensionStack;
import com.att.aft.dme2.internal.jetty.websocket.common.io.http.HttpResponseHeaderParser;
import java.io.EOFException;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;

public class UpgradeConnection
extends AbstractConnection
implements Connection.UpgradeFrom {
    private static final int SWITCHING_PROTOCOLS = 101;
    private static final Logger LOG = Log.getLogger(UpgradeConnection.class);
    private final ByteBufferPool bufferPool;
    private final ConnectPromise connectPromise;
    private final HttpResponseHeaderParser parser;
    private State state = State.REQUEST;
    private ClientUpgradeRequest request;
    private ClientUpgradeResponse response;

    public UpgradeConnection(EndPoint endp, Executor executor, ConnectPromise connectPromise) {
        super(endp, executor);
        this.connectPromise = connectPromise;
        this.bufferPool = connectPromise.getClient().getBufferPool();
        this.request = connectPromise.getRequest();
        this.parser = new HttpResponseHeaderParser(new ClientUpgradeResponse());
    }

    public void disconnect(boolean onlyOutput) {
        EndPoint endPoint = this.getEndPoint();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shutting down output {}", endPoint);
        }
        endPoint.shutdownOutput();
        if (!onlyOutput) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing {}", endPoint);
            }
            endPoint.close();
        }
    }

    private void failUpgrade(Throwable cause) {
        this.close();
        this.connectPromise.failed(cause);
    }

    private void notifyConnect(ClientUpgradeResponse response) {
        this.connectPromise.setResponse(response);
        UpgradeListener handshakeListener = this.connectPromise.getUpgradeListener();
        if (handshakeListener != null) {
            handshakeListener.onHandshakeResponse(response);
        }
    }

    @Override
    public ByteBuffer onUpgradeFrom() {
        return this.connectPromise.getResponse().getRemainingBuffer();
    }

    @Override
    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onFillable", new Object[0]);
        }
        ByteBuffer buffer = this.bufferPool.acquire(this.getInputBufferSize(), false);
        BufferUtil.clear(buffer);
        try {
            this.read(buffer);
        }
        finally {
            this.bufferPool.release(buffer);
        }
        if (this.state == State.RESPONSE) {
            this.fillInterested();
        } else if (this.state == State.UPGRADE) {
            this.upgradeConnection(this.response);
        }
    }

    @Override
    public void onOpen() {
        super.onOpen();
        this.getExecutor().execute(new SendUpgradeRequest());
    }

    @Override
    public void onClose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closed connection {}", this);
        }
        super.onClose();
    }

    @Override
    protected boolean onReadTimeout() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Timeout on connection {}", this);
        }
        this.failUpgrade(new IOException("Timeout while performing WebSocket Upgrade"));
        return super.onReadTimeout();
    }

    private void read(ByteBuffer buffer) {
        EndPoint endPoint = this.getEndPoint();
        try {
            do {
                int filled;
                if ((filled = endPoint.fill(buffer)) == 0) {
                    return;
                }
                if (filled < 0) {
                    LOG.warn("read - EOF Reached", new Object[0]);
                    this.state = State.FAILURE;
                    this.failUpgrade(new EOFException("Reading WebSocket Upgrade response"));
                    return;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Filled {} bytes - {}", filled, BufferUtil.toDetailString(buffer));
                }
                this.response = (ClientUpgradeResponse)this.parser.parse(buffer);
            } while (this.response == null);
            this.validateResponse(this.response);
            this.notifyConnect(this.response);
            this.state = State.UPGRADE;
            return;
        }
        catch (HttpResponseHeaderParser.ParseException | IOException e) {
            LOG.ignore(e);
            this.state = State.FAILURE;
            UpgradeException ue = new UpgradeException(this.request.getRequestURI(), (Throwable)e);
            this.connectPromise.failed(ue);
            this.disconnect(false);
        }
        catch (UpgradeException e) {
            LOG.ignore(e);
            this.state = State.FAILURE;
            this.connectPromise.failed(e);
            this.disconnect(false);
        }
    }

    private void upgradeConnection(ClientUpgradeResponse response) {
        EndPoint endp = this.getEndPoint();
        Executor executor = this.getExecutor();
        EventDriver websocket = this.connectPromise.getDriver();
        WebSocketPolicy policy = websocket.getPolicy();
        WebSocketClientConnection connection = new WebSocketClientConnection(endp, executor, this.connectPromise, policy);
        SessionFactory sessionFactory = this.connectPromise.getClient().getSessionFactory();
        WebSocketSession session = sessionFactory.createSession(this.request.getRequestURI(), websocket, connection);
        session.setPolicy(policy);
        session.setUpgradeRequest(this.request);
        session.setUpgradeResponse(response);
        connection.addListener(session);
        this.connectPromise.setSession(session);
        ExtensionStack extensionStack = new ExtensionStack(this.connectPromise.getClient().getExtensionFactory());
        extensionStack.negotiate(response.getExtensions());
        extensionStack.configure(connection.getParser());
        extensionStack.configure(connection.getGenerator());
        connection.setNextIncomingFrames(extensionStack);
        extensionStack.setNextIncoming(session);
        session.setOutgoingHandler(extensionStack);
        extensionStack.setNextOutgoing(connection);
        session.addManaged(extensionStack);
        this.connectPromise.getClient().addManaged(session);
        endp.upgrade(connection);
    }

    private void validateResponse(ClientUpgradeResponse response) {
        if (response.getStatusCode() != 101) {
            throw new UpgradeException(this.request.getRequestURI(), response.getStatusCode(), "Didn't switch protocols, expected status <101>, but got <" + response.getStatusCode() + ">");
        }
        String connection = response.getHeader("Connection");
        if (!"upgrade".equalsIgnoreCase(connection)) {
            throw new UpgradeException(this.request.getRequestURI(), response.getStatusCode(), "Connection is " + connection + " (expected upgrade)");
        }
        String reqKey = this.request.getKey();
        String expectedHash = AcceptHash.hashKey(reqKey);
        String respHash = response.getHeader("Sec-WebSocket-Accept");
        response.setSuccess(true);
        if (!expectedHash.equalsIgnoreCase(respHash)) {
            response.setSuccess(false);
            throw new UpgradeException(this.request.getRequestURI(), response.getStatusCode(), "Invalid Sec-WebSocket-Accept hash");
        }
        ArrayList<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
        List<String> extValues = response.getHeaders("Sec-WebSocket-Extensions");
        if (extValues != null) {
            for (String extVal : extValues) {
                QuotedStringTokenizer tok = new QuotedStringTokenizer(extVal, ",");
                while (tok.hasMoreTokens()) {
                    extensions.add(ExtensionConfig.parse(tok.nextToken()));
                }
            }
        }
        response.setExtensions(extensions);
    }

    private static enum State {
        REQUEST,
        RESPONSE,
        FAILURE,
        UPGRADE;

    }

    public class SendUpgradeRequest
    extends FutureCallback
    implements Runnable {
        private final Logger LOG = Log.getLogger(SendUpgradeRequest.class);

        @Override
        public void run() {
            URI uri = UpgradeConnection.this.connectPromise.getRequest().getRequestURI();
            UpgradeConnection.this.request.setRequestURI(uri);
            UpgradeListener handshakeListener = UpgradeConnection.this.connectPromise.getUpgradeListener();
            if (handshakeListener != null) {
                handshakeListener.onHandshakeRequest(UpgradeConnection.this.request);
            }
            String rawRequest = UpgradeConnection.this.request.generate();
            ByteBuffer buf = BufferUtil.toBuffer(rawRequest, StandardCharsets.UTF_8);
            UpgradeConnection.this.getEndPoint().write(this, buf);
        }

        @Override
        public void succeeded() {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Upgrade Request Write Success", new Object[0]);
            }
            super.succeeded();
            UpgradeConnection.this.state = State.RESPONSE;
            UpgradeConnection.this.fillInterested();
        }

        @Override
        public void failed(Throwable cause) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Upgrade Request Write Failure", cause);
            }
            super.failed(cause);
            UpgradeConnection.this.state = State.FAILURE;
            UpgradeConnection.this.connectPromise.failed(cause);
        }
    }
}

