/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.common.extensions.compress;

import com.att.aft.dme2.internal.jetty.util.log.Log;
import com.att.aft.dme2.internal.jetty.util.log.Logger;
import com.att.aft.dme2.internal.jetty.websocket.api.BadPayloadException;
import com.att.aft.dme2.internal.jetty.websocket.api.BatchMode;
import com.att.aft.dme2.internal.jetty.websocket.api.WriteCallback;
import com.att.aft.dme2.internal.jetty.websocket.api.extensions.ExtensionConfig;
import com.att.aft.dme2.internal.jetty.websocket.api.extensions.Frame;
import com.att.aft.dme2.internal.jetty.websocket.common.OpCode;
import com.att.aft.dme2.internal.jetty.websocket.common.extensions.compress.ByteAccumulator;
import com.att.aft.dme2.internal.jetty.websocket.common.extensions.compress.CompressExtension;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;

public class PerMessageDeflateExtension
extends CompressExtension {
    private static final Logger LOG = Log.getLogger(PerMessageDeflateExtension.class);
    private ExtensionConfig configRequested;
    private ExtensionConfig configNegotiated;
    private boolean incomingContextTakeover = true;
    private boolean outgoingContextTakeover = true;
    private boolean incomingCompressed;

    @Override
    public String getName() {
        return "permessage-deflate";
    }

    @Override
    public void incomingFrame(Frame frame) {
        if (frame.getType().isData()) {
            this.incomingCompressed = frame.isRsv1();
        }
        if (OpCode.isControlFrame(frame.getOpCode()) || !this.incomingCompressed) {
            this.nextIncomingFrame(frame);
            return;
        }
        ByteAccumulator accumulator = this.newByteAccumulator();
        try {
            ByteBuffer payload = frame.getPayload();
            this.decompress(accumulator, payload);
            if (frame.isFin()) {
                this.decompress(accumulator, TAIL_BYTES_BUF.slice());
            }
            this.forwardIncoming(frame, accumulator);
        }
        catch (DataFormatException e) {
            throw new BadPayloadException(e);
        }
        if (frame.isFin()) {
            this.incomingCompressed = false;
        }
    }

    @Override
    protected void nextIncomingFrame(Frame frame) {
        if (frame.isFin() && !this.incomingContextTakeover) {
            LOG.debug("Incoming Context Reset", new Object[0]);
            this.decompressCount.set(0);
            this.getInflater().reset();
        }
        super.nextIncomingFrame(frame);
    }

    @Override
    protected void nextOutgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        if (frame.isFin() && !this.outgoingContextTakeover) {
            LOG.debug("Outgoing Context Reset", new Object[0]);
            this.getDeflater().reset();
        }
        super.nextOutgoingFrame(frame, callback, batchMode);
    }

    @Override
    int getRsvUseMode() {
        return 1;
    }

    @Override
    int getTailDropMode() {
        return 2;
    }

    @Override
    public void setConfig(ExtensionConfig config) {
        this.configRequested = new ExtensionConfig(config);
        this.configNegotiated = new ExtensionConfig(config.getName());
        block19: for (String key : config.getParameterKeys()) {
            switch (key = key.trim()) {
                case "client_max_window_bits": 
                case "server_max_window_bits": {
                    continue block19;
                }
                case "client_no_context_takeover": {
                    this.configNegotiated.setParameter("client_no_context_takeover");
                    switch (this.getPolicy().getBehavior()) {
                        case CLIENT: {
                            this.incomingContextTakeover = false;
                            break;
                        }
                        case SERVER: {
                            this.outgoingContextTakeover = false;
                        }
                    }
                    continue block19;
                }
                case "server_no_context_takeover": {
                    this.configNegotiated.setParameter("server_no_context_takeover");
                    switch (this.getPolicy().getBehavior()) {
                        case CLIENT: {
                            this.outgoingContextTakeover = false;
                            break;
                        }
                        case SERVER: {
                            this.incomingContextTakeover = false;
                        }
                    }
                    continue block19;
                }
            }
            throw new IllegalArgumentException();
        }
        LOG.debug("config: outgoingContextTakover={}, incomingContextTakeover={} : {}", this.outgoingContextTakeover, this.incomingContextTakeover, this);
        super.setConfig(this.configNegotiated);
    }

    @Override
    public String toString() {
        return String.format("%s[requested=\"%s\", negotiated=\"%s\"]", this.getClass().getSimpleName(), this.configRequested.getParameterizedName(), this.configNegotiated.getParameterizedName());
    }
}

