/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.core.api.io;

import com.att.aft.dme2.internal.jetty.util.FutureCallback;
import com.att.aft.dme2.internal.jetty.util.log.Log;
import com.att.aft.dme2.internal.jetty.util.log.Logger;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketConnection;
import com.att.aft.dme2.internal.jetty.websocket.core.io.WebSocketSession;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public class WebSocketBlockingConnection {
    private static final Logger LOG = Log.getLogger(WebSocketBlockingConnection.class);
    private static final String CONTEXT_BINARY = "BLOCKING_BINARY";
    private static final String CONTEXT_TEXT = "BLOCKING_TEXT";
    private final WebSocketSession conn;

    public WebSocketBlockingConnection(WebSocketConnection conn) {
        if (!(conn instanceof WebSocketSession)) {
            throw new IllegalArgumentException("WebSocketConnection must implement internal WebSocketSession interface");
        }
        this.conn = (WebSocketSession)conn;
    }

    public void write(byte[] data, int offset, int length) throws IOException {
        try {
            Blocker blocker = new Blocker();
            this.conn.write(CONTEXT_BINARY, blocker, data, offset, length);
            blocker.get();
        }
        catch (InterruptedException e) {
            throw new IOException("Blocking write failed", e);
        }
        catch (ExecutionException e) {
            FutureCallback.rethrow(e);
        }
    }

    public void write(String message) throws IOException {
        try {
            Blocker blocker = new Blocker();
            this.conn.write(CONTEXT_TEXT, blocker, message);
            blocker.get();
        }
        catch (InterruptedException e) {
            throw new IOException("Blocking write failed", e);
        }
        catch (ExecutionException e) {
            FutureCallback.rethrow(e);
        }
    }

    private static class Blocker
    extends FutureCallback<String> {
        private Blocker() {
        }

        public void completed(String context) {
            LOG.debug("completed({})", context);
            super.completed((Object)context);
        }

        public void failed(String context, Throwable cause) {
            LOG.debug("failed({},{})", context, cause);
            super.failed((Object)context, cause);
        }

        @Override
        public String toString() {
            return String.format("%s[%s]", Blocker.class.getSimpleName(), super.toString());
        }
    }
}

