/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.core.io;

import com.att.aft.dme2.internal.jetty.util.BufferUtil;
import com.att.aft.dme2.internal.jetty.util.Callback;
import com.att.aft.dme2.internal.jetty.util.log.Log;
import com.att.aft.dme2.internal.jetty.util.log.Logger;
import com.att.aft.dme2.internal.jetty.websocket.core.api.BaseConnection;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketConnection;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketException;
import com.att.aft.dme2.internal.jetty.websocket.core.api.WebSocketPolicy;
import com.att.aft.dme2.internal.jetty.websocket.core.io.IncomingFrames;
import com.att.aft.dme2.internal.jetty.websocket.core.io.OutgoingFrames;
import com.att.aft.dme2.internal.jetty.websocket.core.io.event.EventDriver;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.CloseInfo;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.ConnectionState;
import com.att.aft.dme2.internal.jetty.websocket.core.protocol.WebSocketFrame;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

public class WebSocketSession
implements WebSocketConnection,
IncomingFrames,
OutgoingFrames {
    private static final Logger LOG = Log.getLogger(WebSocketSession.class);
    private final BaseConnection baseConnection;
    private final WebSocketPolicy policy;
    private final String subprotocol;
    private final EventDriver websocket;
    private OutgoingFrames outgoing;

    public WebSocketSession(EventDriver websocket, BaseConnection connection, WebSocketPolicy policy, String subprotocol) {
        this.websocket = websocket;
        this.baseConnection = connection;
        this.policy = policy;
        this.subprotocol = subprotocol;
    }

    @Override
    public void close() {
        this.baseConnection.close();
    }

    @Override
    public void close(int statusCode, String reason) {
        this.baseConnection.close(statusCode, reason);
    }

    @Override
    public void disconnect() {
        this.baseConnection.disconnect();
    }

    public IncomingFrames getIncoming() {
        return this.websocket;
    }

    public OutgoingFrames getOutgoing() {
        return this.outgoing;
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.baseConnection.getRemoteAddress();
    }

    @Override
    public ConnectionState getState() {
        return this.baseConnection.getState();
    }

    @Override
    public String getSubProtocol() {
        return this.subprotocol;
    }

    @Override
    public void incoming(WebSocketException e) {
        if (this.baseConnection.isInputClosed()) {
            return;
        }
        this.websocket.incoming(e);
    }

    @Override
    public void incoming(WebSocketFrame frame) {
        if (this.baseConnection.isInputClosed()) {
            return;
        }
        this.websocket.incoming(frame);
    }

    @Override
    public boolean isInputClosed() {
        return this.baseConnection.isInputClosed();
    }

    @Override
    public boolean isOpen() {
        return this.baseConnection.isOpen();
    }

    @Override
    public boolean isOutputClosed() {
        return this.baseConnection.isOutputClosed();
    }

    @Override
    public boolean isReading() {
        return this.baseConnection.isReading();
    }

    @Override
    public void onCloseHandshake(boolean incoming, CloseInfo close) {
        this.baseConnection.onCloseHandshake(incoming, close);
    }

    public void onConnect() {
        LOG.debug("onConnect()", new Object[0]);
        this.websocket.setSession(this);
        this.websocket.onConnect();
    }

    @Override
    public <C> void output(C context, Callback<C> callback, WebSocketFrame frame) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("output({},{},{}) - {}", context, callback, frame, this.outgoing);
        }
        this.outgoing.output(context, callback, frame);
    }

    @Override
    public <C> void ping(C context, Callback<C> callback, byte[] payload) throws IOException {
        WebSocketFrame frame = new WebSocketFrame(9).setPayload(payload);
        frame.setFin(true);
        this.output(context, callback, frame);
    }

    public void setOutgoing(OutgoingFrames outgoing) {
        this.outgoing = outgoing;
    }

    @Override
    public BaseConnection.SuspendToken suspend() {
        return this.baseConnection.suspend();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("WebSocketSession[websocket=");
        builder.append(this.websocket);
        builder.append(",baseConnection=");
        builder.append(this.baseConnection);
        builder.append(",subprotocol=");
        builder.append(this.subprotocol);
        builder.append(",outgoing=");
        builder.append(this.outgoing);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public <C> void write(C context, Callback<C> callback, byte[] buf, int offset, int len) throws IOException {
        if (this.baseConnection.isOutputClosed()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("write(context,{},byte[],{},{})", callback, offset, len);
        }
        WebSocketFrame frame = WebSocketFrame.binary().setPayload(buf, offset, len);
        frame.setFin(true);
        this.output(context, callback, frame);
    }

    @Override
    public <C> void write(C context, Callback<C> callback, ByteBuffer buffer) throws IOException {
        if (this.baseConnection.isOutputClosed()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("write(context,{},ByteBuffer->{})", callback, BufferUtil.toDetailString(buffer));
        }
        WebSocketFrame frame = WebSocketFrame.binary().setPayload(buffer);
        frame.setFin(true);
        this.output(context, callback, frame);
    }

    @Override
    public <C> void write(C context, Callback<C> callback, String message) throws IOException {
        if (this.baseConnection.isOutputClosed()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("write(context,{},message.length:{})", callback, message.length());
        }
        WebSocketFrame frame = WebSocketFrame.text(message);
        frame.setFin(true);
        this.output(context, callback, frame);
    }
}

