/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.core.io.message;

import com.att.aft.dme2.internal.jetty.util.Utf8StringBuilder;
import com.att.aft.dme2.internal.jetty.websocket.core.io.event.EventDriver;
import com.att.aft.dme2.internal.jetty.websocket.core.io.message.MessageAppender;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SimpleTextMessage
implements MessageAppender {
    private final EventDriver onEvent;
    private final Utf8StringBuilder utf;
    private int size = 0;
    private boolean finished;

    public SimpleTextMessage(EventDriver onEvent) {
        this.onEvent = onEvent;
        this.utf = new Utf8StringBuilder();
        this.size = 0;
        this.finished = false;
    }

    @Override
    public void appendMessage(ByteBuffer payload) throws IOException {
        if (this.finished) {
            throw new IOException("Cannot append to finished buffer");
        }
        if (payload == null) {
            return;
        }
        this.onEvent.getPolicy().assertValidTextMessageSize(this.size + payload.remaining());
        this.size += payload.remaining();
        this.utf.append(payload);
    }

    @Override
    public void messageComplete() {
        this.finished = true;
        this.onEvent.onTextMessage(this.utf.toString());
    }
}

