/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.internal.jetty.websocket.server;

import com.att.aft.dme2.internal.jetty.io.ByteBufferPool;
import com.att.aft.dme2.internal.jetty.io.MappedByteBufferPool;
import com.att.aft.dme2.internal.jetty.server.Request;
import com.att.aft.dme2.internal.jetty.server.handler.HandlerWrapper;
import com.att.aft.dme2.internal.jetty.websocket.api.WebSocketBehavior;
import com.att.aft.dme2.internal.jetty.websocket.api.WebSocketPolicy;
import com.att.aft.dme2.internal.jetty.websocket.server.WebSocketServerFactory;
import com.att.aft.dme2.internal.jetty.websocket.servlet.WebSocketServletFactory;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class WebSocketHandler
extends HandlerWrapper {
    private final WebSocketServletFactory webSocketFactory;

    public WebSocketHandler() {
        this(new MappedByteBufferPool());
    }

    public WebSocketHandler(ByteBufferPool bufferPool) {
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        this.configurePolicy(policy);
        this.webSocketFactory = new WebSocketServerFactory(policy, bufferPool);
        this.addBean(this.webSocketFactory);
    }

    public abstract void configure(WebSocketServletFactory var1);

    public void configurePolicy(WebSocketPolicy policy) {
    }

    @Override
    protected void doStart() throws Exception {
        this.configure(this.webSocketFactory);
        super.doStart();
    }

    public WebSocketServletFactory getWebSocketFactory() {
        return this.webSocketFactory;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.webSocketFactory.isUpgradeRequest(request, response)) {
            if (this.webSocketFactory.acceptWebSocket(request, response)) {
                baseRequest.setHandled(true);
                return;
            }
            if (response.isCommitted()) {
                return;
            }
        }
        super.handle(target, baseRequest, request, response);
    }

    public static class Simple
    extends WebSocketHandler {
        private Class<?> websocketPojo;

        public Simple(Class<?> websocketClass) {
            this.websocketPojo = websocketClass;
        }

        @Override
        public void configure(WebSocketServletFactory factory) {
            factory.register(this.websocketPojo);
        }
    }
}

