/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.iterator;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.event.EventProcessor;
import com.att.aft.dme2.internal.google.common.collect.ArrayListMultimap;
import com.att.aft.dme2.internal.google.common.collect.ListMultimap;
import com.att.aft.dme2.iterator.domain.DME2EndpointReference;
import com.att.aft.dme2.iterator.domain.DME2RouteOffer;
import com.att.aft.dme2.iterator.domain.IteratorCreatingAttributes;
import com.att.aft.dme2.iterator.exception.IteratorException;
import com.att.aft.dme2.iterator.factory.EndpointIteratorFactory;
import com.att.aft.dme2.iterator.helper.AvailableEndpoints;
import com.att.aft.dme2.iterator.helper.EndpointPreference;
import com.att.aft.dme2.iterator.service.DME2BaseEndpointIterator;
import com.att.aft.dme2.iterator.service.DME2EndpointURLFormatter;
import com.att.aft.dme2.iterator.service.EndpointIteratorBuilder;
import com.att.aft.dme2.iterator.service.IteratorEndpointOrderHandler;
import com.att.aft.dme2.iterator.service.IteratorRouteOfferOrderHandler;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.util.ErrorContext;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;

public class DefaultEndpointIteratorBuilder
implements EndpointIteratorBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEndpointIteratorBuilder.class.getName());
    private String initialUrl;
    private Properties props;
    private List<IteratorEndpointOrderHandler> endpointOrderHandlers = new ArrayList<IteratorEndpointOrderHandler>();
    private List<IteratorRouteOfferOrderHandler> routeOfferOrderHandlers = new ArrayList<IteratorRouteOfferOrderHandler>();
    private DME2EndpointURLFormatter urlFormatter;
    private DME2Manager manager;
    private DmeUniformResource uniformResource = null;
    private String preferredRouteOffer = null;
    private String preferredUrl = null;
    private EventProcessor requestEventProcessor = null;
    private EventProcessor replyEventProcessor = null;
    private EventProcessor faultEventProcessor = null;
    private EventProcessor timeoutEventProcessor = null;
    private DME2Configuration config;
    private String preferredVersion;
    private String preferredRouteOfferForced;

    public DefaultEndpointIteratorBuilder(DME2Configuration config) {
        this.config = config;
    }

    public DmeUniformResource getUniformResource() {
        return this.uniformResource;
    }

    public void setUniformResource(DmeUniformResource uniformResource) {
        this.uniformResource = uniformResource;
    }

    public String getPreferredUrl() {
        return this.preferredUrl;
    }

    private String getDefaultPreferredUrl() {
        return EndpointPreference.resolvePreferredConnection(this.config, this.getProps());
    }

    public void setPreferredUrl(String preferredUrl) {
        this.preferredUrl = preferredUrl;
    }

    private String getDefaultRouteOfferPreference() {
        return EndpointPreference.resolvePreferredRouteOffer(this.config, this.getProps());
    }

    public String getPreferredRouteOffer() {
        return this.preferredRouteOffer;
    }

    public void setPreferredRouteOffer(String preferredRouteOffer) {
        this.preferredRouteOffer = preferredRouteOffer;
    }

    public List<IteratorRouteOfferOrderHandler> getIteratorRouteOfferOrderHandlers() {
        return this.routeOfferOrderHandlers;
    }

    public List<IteratorEndpointOrderHandler> getEndpointOrderHandlers() {
        return this.endpointOrderHandlers;
    }

    public String getInitialUrl() {
        return this.initialUrl;
    }

    @Override
    public DefaultEndpointIteratorBuilder setServiceURI(String initialUrl) {
        this.initialUrl = initialUrl;
        return this;
    }

    public Properties getProps() {
        return this.props;
    }

    @Override
    public DefaultEndpointIteratorBuilder setProps(Properties props) {
        this.props = props;
        return this;
    }

    public DME2EndpointURLFormatter getUrlFormatter() {
        return this.urlFormatter;
    }

    @Override
    public DefaultEndpointIteratorBuilder setUrlFormatter(DME2EndpointURLFormatter urlFormatter) {
        this.urlFormatter = urlFormatter;
        return this;
    }

    public DME2Manager getManager() {
        return this.manager;
    }

    @Override
    public DefaultEndpointIteratorBuilder setManager(DME2Manager manager) {
        this.manager = manager;
        return this;
    }

    @Override
    public DME2BaseEndpointIterator build() throws DME2Exception {
        return this.buildIterator();
    }

    private DME2BaseEndpointIterator buildIterator() throws DME2Exception {
        LOGGER.debug(null, "getIterator", LogMessage.METHOD_ENTER);
        long startTime = System.currentTimeMillis();
        List<DME2RouteOffer> routeOffers = null;
        DME2Endpoint[] directEndpoints = null;
        ListMultimap<Integer, DME2RouteOffer> routeOffersGroupedBySequence = null;
        SortedMap<Integer, DME2Endpoint[]> unorderedEndpointByRouteOfferSeqMap = null;
        SortedMap<Integer, Map<Double, Object>> endpointsGroupedBySequence = new TreeMap<Integer, Map<Double, DME2Endpoint[]>>();
        IteratorCreatingAttributes iteratorCreatingAttributes = new IteratorCreatingAttributes();
        LOGGER.debug(null, "getIterator", "initialized");
        this.processParamas();
        this.uniformResource = this.mapResource();
        if (this.uniformResource.getUrlType() == DmeUniformResource.DmeUrlType.SEARCHABLE) {
            routeOffers = this.manager.getActiveOffers(this.uniformResource.getRouteInfoServiceSearchKey(), this.uniformResource.getVersion(), this.uniformResource.getEnvContext(), this.uniformResource.getPartner(), this.uniformResource.getDataContext(), this.uniformResource.getStickySelectorKey(), false, this.preferredRouteOfferForced);
        } else if (this.uniformResource.getUrlType() == DmeUniformResource.DmeUrlType.RESOLVABLE || this.uniformResource.getUrlType() == DmeUniformResource.DmeUrlType.DIRECT || this.uniformResource.getUrlType() == DmeUniformResource.DmeUrlType.STANDARD) {
            if (directEndpoints == null && this.uniformResource.getUrlType() == DmeUniformResource.DmeUrlType.STANDARD && this.uniformResource.getPartner() != null) {
                routeOffers = this.manager.getActiveOffers(this.uniformResource, null);
            } else {
                directEndpoints = this.manager.getEndpoints(this.uniformResource);
            }
        }
        if (routeOffers != null && routeOffers.size() > 0) {
            LOGGER.debug((URI)null, "buildIterator", "Found {} route offers", (Object)routeOffers.size());
            this.routeOfferOrderHandlers.add(0, EndpointIteratorFactory.getDefaultRouteOfferOrderHandler(routeOffers));
            for (IteratorRouteOfferOrderHandler iteratorRouteOfferOrderHandler : this.routeOfferOrderHandlers) {
                if (iteratorRouteOfferOrderHandler == null) continue;
                routeOffersGroupedBySequence = iteratorRouteOfferOrderHandler.order(routeOffersGroupedBySequence);
            }
            unorderedEndpointByRouteOfferSeqMap = AvailableEndpoints.findByRouteOffer(this.config, routeOffersGroupedBySequence, this.manager, this.uniformResource);
        } else {
            LOGGER.debug(null, "buildIterator", "No route offers found, going direct path");
            directEndpoints = AvailableEndpoints.findUnorderedEndpoints(this.manager, this.uniformResource);
            if (directEndpoints != null && directEndpoints.length > 0) {
                LOGGER.debug((URI)null, "buildIterator", "Found {} direct endpoints", (Object)directEndpoints.length);
                DME2RouteOffer routeOffer = new DME2RouteOffer(this.uniformResource.getService(), this.uniformResource.getVersion(), this.uniformResource.getEnvContext(), this.uniformResource.getRouteOffer(), null, this.manager);
                routeOffersGroupedBySequence = ArrayListMultimap.create();
                routeOffersGroupedBySequence.put(1, routeOffer);
                unorderedEndpointByRouteOfferSeqMap = new TreeMap<Integer, DME2Endpoint[]>();
                unorderedEndpointByRouteOfferSeqMap.put(1, directEndpoints);
            } else {
                LOGGER.debug(null, "buildIterator", "No direct endpoints found");
            }
        }
        if (unorderedEndpointByRouteOfferSeqMap != null && unorderedEndpointByRouteOfferSeqMap.size() > 0) {
            LOGGER.debug((URI)null, "buildIterator", "Found {} endpoints", (Object)unorderedEndpointByRouteOfferSeqMap.size());
            for (Map.Entry<Integer, DME2Endpoint[]> entry : unorderedEndpointByRouteOfferSeqMap.entrySet()) {
                Integer sequence = entry.getKey();
                DME2Endpoint[] endpoints = entry.getValue();
                if (endpoints != null && endpoints.length > 0) {
                    for (DME2Endpoint endpoint : endpoints) {
                        if (endpoint != null) {
                            LOGGER.debug((URI)null, "buildIterator", "Sequence: {} Endpoint Service Name: {} ", (Object)sequence, (Object)endpoint.getServiceName());
                            continue;
                        }
                        LOGGER.debug((URI)null, "buildIterator", "Sequence: {} Endpoint null", (Object)sequence);
                    }
                    continue;
                }
                LOGGER.debug((URI)null, "buildIterator", "No endpoints found for sequence {}", (Object)sequence);
            }
        } else {
            LOGGER.debug(null, "buildIterator", "No endpoints found");
        }
        int idx = 0;
        this.endpointOrderHandlers.add(idx++, EndpointIteratorFactory.getDefaultEndpointOrderHandler(unorderedEndpointByRouteOfferSeqMap, this.getManager()));
        if (this.getPreferredRouteOffer() != null) {
            this.endpointOrderHandlers.add(idx++, EndpointIteratorFactory.getEndpointPreferredRouteOfferOrderHandler(this.getPreferredRouteOffer()));
        }
        if (this.getPreferredUrl() != null) {
            this.endpointOrderHandlers.add(idx++, EndpointIteratorFactory.getEndpointPreferredUrlOrderHandler(this.getPreferredUrl(), this.getUrlFormatter()));
        }
        for (IteratorEndpointOrderHandler endpointOrderHandler : this.endpointOrderHandlers) {
            if (endpointOrderHandler == null) continue;
            endpointsGroupedBySequence = (SortedMap)endpointOrderHandler.order(endpointsGroupedBySequence);
        }
        List<DME2EndpointReference> list = AvailableEndpoints.createOrderedEndpointHolders(this.manager, routeOffersGroupedBySequence, endpointsGroupedBySequence);
        StringBuffer routeOfferNames = new StringBuffer();
        if (routeOffersGroupedBySequence != null) {
            for (DME2RouteOffer ro : routeOffersGroupedBySequence.values()) {
                if (ro.getRouteOffer() == null) continue;
                routeOfferNames.append(ro.getRouteOffer().getName()).append(":");
            }
        }
        iteratorCreatingAttributes.setManager(this.manager);
        iteratorCreatingAttributes.setEndpointHolders(list);
        iteratorCreatingAttributes.setQueryParamMinActiveEndPoint(this.uniformResource.getQueryParamsMap().get("minActiveEndPoints"));
        iteratorCreatingAttributes.setRequestEventProcessor(this.requestEventProcessor);
        iteratorCreatingAttributes.setReplyEventProcessor(this.replyEventProcessor);
        iteratorCreatingAttributes.setFaultEventProcessor(this.faultEventProcessor);
        iteratorCreatingAttributes.setTimeoutEventProcessor(this.timeoutEventProcessor);
        iteratorCreatingAttributes.setConfig(this.config);
        DME2BaseEndpointIterator endpointIterator = EndpointIteratorFactory.getDefaultIterator(iteratorCreatingAttributes);
        if (list != null && list.size() <= 0) {
            endpointIterator.setRouteOffersTried(routeOfferNames.toString());
        }
        LOGGER.debug((URI)null, "buildIterator", "end; elapsed time:{}ms", (Object)(System.currentTimeMillis() - startTime));
        LOGGER.debug(null, "buildIterator", LogMessage.METHOD_EXIT);
        return endpointIterator;
    }

    private void processParamas() throws DME2Exception {
        this.assignDefaults();
        this.verify();
    }

    private void verify() throws DME2Exception {
        if (this.config == null) {
            throw new IteratorException(IteratorException.IteratorErrorCatalogue.ITERATOR_004, new Object[0]);
        }
        this.verifyUrl();
    }

    private void assignDefaults() throws DME2Exception {
        if (this.manager == null) {
            this.manager = new DME2Manager();
        }
        if (this.getPreferredRouteOffer() == null) {
            String defaultRouteOfferPreference = this.getDefaultRouteOfferPreference();
            this.setPreferredRouteOffer(defaultRouteOfferPreference != null && !defaultRouteOfferPreference.isEmpty() ? defaultRouteOfferPreference : null);
        }
        if (this.getPreferredUrl() == null) {
            String defaultPreferredUrl = this.getDefaultPreferredUrl();
            this.setPreferredUrl(defaultPreferredUrl != null && !defaultPreferredUrl.isEmpty() ? defaultPreferredUrl : null);
        }
        if (this.getPreferredVersion() == null) {
            this.setPreferredVersion(this.resolvePreferredVersion());
        }
        if (this.getPreferredRouteOfferForced() == null) {
            this.setPreferredRouteOfferForced(this.resolvePreferredRouteOfferOverride());
        }
    }

    private void verifyUrl() throws DME2Exception {
        if (this.initialUrl == null) {
            ErrorContext ec = new ErrorContext();
            ec.add("searchString", this.initialUrl);
            ec.add("errorDetail", "Lookup URL String cannot be null.");
            LOGGER.error((URI)null, "verifyUrl", "AFT-DME2-9000: {}", (Object)ec);
            throw new DME2Exception("AFT-DME2-9000", ec);
        }
    }

    private DmeUniformResource mapResource() throws DME2Exception {
        DmeUniformResource uniformResource = null;
        try {
            if (this.initialUrl.startsWith("dme2://")) {
                this.initialUrl = this.initialUrl.replace("dme2://", "http://");
            } else if (this.initialUrl.startsWith("ws://")) {
                this.initialUrl = this.initialUrl.replace("ws://", "http://");
            } else if (this.initialUrl.startsWith("wss://")) {
                this.initialUrl = this.initialUrl.replace("wss://", "http://");
            }
            uniformResource = new DmeUniformResource(this.config, this.initialUrl);
        }
        catch (MalformedURLException e) {
            throw new DME2Exception("AFT-DME2-0607", new ErrorContext().add("extendedMessage", e.getMessage()).add("URL", this.initialUrl), (Throwable)e);
        }
        return uniformResource;
    }

    private List<DME2RouteOffer> getActiveRouteOffers() throws DME2Exception {
        LOGGER.debug(null, "getActiveRouteOffers", LogMessage.METHOD_ENTER);
        LOGGER.debug((URI)null, "getActiveRouteOffers", "DMEUrlType is {}. Resolving RouteOffers.", (Object)this.uniformResource.getUrl());
        switch (this.uniformResource.getUrlType()) {
            case SEARCHABLE: {
                LOGGER.debug((URI)null, "getActiveRouteOffers", LogMessage.DEBUG_MESSAGE, (Object)String.format("DMEUrlType is %s. Resolving RouteOffers.", new Object[]{this.uniformResource.getUrlType()}));
                return this.manager.getActiveOffers(this.uniformResource.getRouteInfoServiceSearchKey(), this.uniformResource.getVersion(), this.uniformResource.getEnvContext(), this.uniformResource.getPartner(), this.uniformResource.getDataContext(), this.uniformResource.getStickySelectorKey(), false, this.preferredRouteOfferForced);
            }
            case STANDARD: {
                LOGGER.debug((URI)null, "getActiveRouteOffers", LogMessage.DEBUG_MESSAGE, (Object)String.format("DMEUrlType is %s. Resolving Endpoints directly.", new Object[]{this.uniformResource.getUrlType()}));
                if (this.uniformResource.getPartner() == null) break;
                LOGGER.debug((URI)null, "getActiveRouteOffers", "Used for getting active offers DMEUrlType option url type: {}. partner: {}", (Object)this.uniformResource.getUrlType(), (Object)this.uniformResource.getPartner());
                return this.manager.getActiveOffers(this.uniformResource, null);
            }
        }
        LOGGER.debug((URI)null, "getActiveRouteOffers", "Not serviced DMEUrlType option {}. ", (Object)this.uniformResource.getUrlType());
        LOGGER.debug(null, "getActiveRouteOffers", LogMessage.METHOD_EXIT);
        return null;
    }

    @Override
    public EndpointIteratorBuilder addIteratorEndpointOrderHandler(IteratorEndpointOrderHandler iteratorEndpointOrderHandler) {
        this.endpointOrderHandlers.add(iteratorEndpointOrderHandler);
        return this;
    }

    @Override
    public EndpointIteratorBuilder addIteratorRouteOfferOrderHandler(IteratorRouteOfferOrderHandler iteratorRouteOfferOrderHandler) {
        this.routeOfferOrderHandlers.add(iteratorRouteOfferOrderHandler);
        return this;
    }

    @Override
    public EndpointIteratorBuilder setIteratorEndpointOrderHandlers(List<IteratorEndpointOrderHandler> iteratorEndpointOrderHandlers) {
        this.endpointOrderHandlers.addAll(iteratorEndpointOrderHandlers);
        return this;
    }

    @Override
    public EndpointIteratorBuilder setIteratorRouteOfferOrderHandlers(List<IteratorRouteOfferOrderHandler> iteratorRouteOfferOrderHandlers) {
        this.routeOfferOrderHandlers.addAll(iteratorRouteOfferOrderHandlers);
        return this;
    }

    @Override
    public EndpointIteratorBuilder setRequestEventProcessor(EventProcessor requestEventProcessor) {
        this.requestEventProcessor = requestEventProcessor;
        return this;
    }

    @Override
    public EndpointIteratorBuilder setReplyEventProcessor(EventProcessor replyEventProcessor) {
        this.replyEventProcessor = replyEventProcessor;
        return this;
    }

    @Override
    public EndpointIteratorBuilder setFaultEventProcessor(EventProcessor faultEventProcessor) {
        this.faultEventProcessor = faultEventProcessor;
        return this;
    }

    @Override
    public EndpointIteratorBuilder setTimeoutEventProcessor(EventProcessor timeoutEventProcessor) {
        this.timeoutEventProcessor = timeoutEventProcessor;
        return this;
    }

    private String resolvePreferredVersion() {
        return System.getProperty("AFT_DME2_PREFERRED_VERSION", this.config.getProperty("AFT_DME2_PREFERRED_VERSION"));
    }

    private String resolvePreferredRouteOfferOverride() {
        String preferredRouteOfferForced = null;
        if (this.getPreferredRouteOffer() != null && this.config.getBoolean("AFT_DME2_FORCE_PREFERRED_ROUTE_OFFER")) {
            preferredRouteOfferForced = this.getPreferredRouteOffer();
        }
        return preferredRouteOfferForced;
    }

    public String getPreferredVersion() {
        return this.preferredVersion;
    }

    public void setPreferredVersion(String preferredVersion) {
        this.preferredVersion = preferredVersion;
    }

    public String getPreferredRouteOfferForced() {
        return this.preferredRouteOfferForced;
    }

    public void setPreferredRouteOfferForced(String preferredRouteOfferForced) {
        this.preferredRouteOfferForced = preferredRouteOfferForced;
    }
}

