/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.iterator.domain;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.iterator.helper.AvailableEndpoints;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import com.att.aft.dme2.types.RouteOffer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class DME2RouteOffer
implements Serializable {
    private static final long serialVersionUID = -6514516982372370452L;
    private String envContext;
    private String fqName;
    private DME2Endpoint[] hardCodedEndpoints;
    private RouteOffer routeOffer;
    private String service;
    private String version;
    private boolean searchWithWildcard;
    private String searchFilter;
    private DME2Manager manager;

    public DME2RouteOffer(String service, String version, String envContext, RouteOffer routeOffer, String fqName, DME2Manager manager) {
        this(service, version, envContext, fqName, routeOffer.getName(), routeOffer, null, manager);
    }

    public DME2RouteOffer(String service, String version, String envContext, String fqName, DME2Endpoint[] endpoints, DME2Manager manager) {
        this(service, version, envContext, fqName, fqName, null, endpoints, manager);
    }

    private DME2RouteOffer(String service, String version, String envContext, String fqName, String searchFilter, RouteOffer routeOffer, DME2Endpoint[] endpoints, DME2Manager manager) {
        this.service = service;
        this.version = version;
        this.envContext = envContext;
        this.fqName = fqName;
        this.hardCodedEndpoints = endpoints;
        this.manager = manager;
        this.searchFilter = searchFilter;
        this.routeOffer = routeOffer;
    }

    private DME2RouteOffer() {
    }

    public DME2Manager getManager() {
        return this.manager;
    }

    public String getEnvContext() {
        return this.envContext;
    }

    public String getFqName() {
        return this.fqName;
    }

    public RouteOffer getRouteOffer() {
        return this.routeOffer;
    }

    public Integer getSequence() {
        if (this.routeOffer == null) {
            return 1;
        }
        return this.routeOffer.getSequence();
    }

    public boolean equals(DME2RouteOffer o) {
        return o != null && this.searchFilter.equals(o.searchFilter);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getService() {
        return this.service;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean isActive() {
        if (this.routeOffer == null) {
            return true;
        }
        return this.routeOffer.isActive();
    }

    public String toExplodedString() {
        DME2Endpoint[][] eps;
        StringBuffer buffer = new StringBuffer();
        buffer.append("SERVICE=" + this.getService() + "; VERSION=" + this.getVersion() + "; ENV=" + this.getEnvContext() + "; ROUTEOFFER=" + this.getFqName() + "; SEQUENCE=" + this.getSequence() + "\n");
        try {
            eps = AvailableEndpoints.find(this, true, this.getManager());
        }
        catch (DME2Exception e) {
            buffer.append("  |-- ERROR: " + e.toString());
            return buffer.toString();
        }
        int counter = 0;
        boolean started = false;
        for (DME2Endpoint[] band : eps) {
            if (band.length == 0) {
                ++counter;
                continue;
            }
            if (started) {
                buffer.append("\n");
            } else {
                started = true;
            }
            buffer.append("  |-- BAND=" + counter + "\n");
            for (DME2Endpoint element : band) {
                buffer.append("      |-- EP=" + element);
            }
            ++counter;
        }
        return buffer.toString();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Service=" + this.getService() + "; Version=" + this.getVersion() + "; env=" + this.getEnvContext() + "; RouteOfferFilter=" + this.getSearchFilter() + "; Sequence=" + this.getSequence());
        return buffer.toString();
    }

    public DME2RouteOffer withSearchFilter(String newSearchFilter) {
        return new DME2RouteOffer(this.service, this.version, this.envContext, this.fqName, newSearchFilter, this.routeOffer, this.hardCodedEndpoints, this.manager);
    }

    public String getSearchFilter() {
        return this.searchFilter;
    }

    public DME2RouteOffer clone() {
        return new DME2RouteOffer(this.service, this.version, this.envContext, this.fqName, this.searchFilter, this.routeOffer, this.hardCodedEndpoints, this.manager);
    }

    public DME2Endpoint[] getHardCodedEndpoints() {
        return this.hardCodedEndpoints;
    }

    public boolean isSearchWithWildcard() {
        return this.searchWithWildcard;
    }

    public void setSearchWithWildcard(boolean searchWithWildcard) {
        this.searchWithWildcard = searchWithWildcard;
    }

    public DME2Endpoint[][] getAvailableEndpoints(boolean useVersionRange) throws DME2Exception {
        String serviceKey = null;
        serviceKey = this.searchWithWildcard ? this.getService() + "*" : this.getService();
        DME2Endpoint[] eps = this.hardCodedEndpoints != null ? this.hardCodedEndpoints : this.manager.findEndpoints(serviceKey, this.getVersion(), this.envContext, this.searchFilter, useVersionRange);
        return this.organize(eps);
    }

    public DME2Endpoint[][] organize(DME2Endpoint[] eps) {
        HashMap bandLists = new HashMap();
        double[] bands = this.manager.getDistanceBands();
        for (int i = 0; i < bands.length; ++i) {
            bandLists.put(i, new ArrayList());
        }
        block1: for (DME2Endpoint ep : eps) {
            double distance = ep.getDistance();
            for (int i = 0; i < bands.length; ++i) {
                if (!(distance < bands[i])) continue;
                ((List)bandLists.get(i)).add(ep);
                continue block1;
            }
        }
        DME2Endpoint[][] bandedEps = new DME2Endpoint[bands.length][0];
        int counter = 0;
        for (List list : bandLists.values()) {
            Collections.shuffle(list);
            bandedEps[counter] = list.toArray(new DME2Endpoint[list.size()]);
            ++counter;
        }
        return bandedEps;
    }
}

