/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.iterator.helper;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.apache.commons.lang.StringUtils;
import com.att.aft.dme2.internal.google.common.collect.ListMultimap;
import com.att.aft.dme2.iterator.domain.DME2EndpointReference;
import com.att.aft.dme2.iterator.domain.DME2RouteOffer;
import com.att.aft.dme2.iterator.helper.EndpointsByDistance;
import com.att.aft.dme2.iterator.helper.StaleProcessor;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.util.DME2URIUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class AvailableEndpoints {
    private static final Logger LOGGER = LoggerFactory.getLogger(AvailableEndpoints.class.getName());

    public static DME2Endpoint[][] find(DME2RouteOffer dme2RouteOffer, boolean useVersionRange, DME2Manager manager) throws DME2Exception {
        String serviceKey = dme2RouteOffer.isSearchWithWildcard() ? dme2RouteOffer.getService().concat("*") : dme2RouteOffer.getService();
        DME2Endpoint[] eps = dme2RouteOffer.getHardCodedEndpoints() != null ? dme2RouteOffer.getHardCodedEndpoints() : manager.findEndpoints(serviceKey, dme2RouteOffer.getVersion(), dme2RouteOffer.getEnvContext(), dme2RouteOffer.getSearchFilter(), useVersionRange);
        return EndpointsByDistance.organize(manager, eps);
    }

    public static DME2Endpoint[] findUnorderedEndpoints(DME2Manager manager, DmeUniformResource uniformResource) throws DME2Exception {
        DME2Endpoint[] eps = manager.getEndpoints(uniformResource);
        LOGGER.debug((URI)null, "findUnorderedEndpoints", "end: endpoints count #{}", (Object)(eps != null ? eps.length : -1));
        return eps;
    }

    public static SortedMap<Integer, DME2Endpoint[]> findByRouteOffer(DME2Configuration config, ListMultimap<Integer, DME2RouteOffer> routeOffersGroupedBySequence, DME2Manager manager, DmeUniformResource resource) {
        TreeMap<Integer, DME2Endpoint[]> endpointMap = new TreeMap<Integer, DME2Endpoint[]>();
        try {
            for (Integer sequence : routeOffersGroupedBySequence.keySet()) {
                for (DME2RouteOffer routeOffer : routeOffersGroupedBySequence.get(sequence)) {
                    DME2Endpoint[] endpoints;
                    String searchKey = resource.getRegistryFindEndpointSearchKey();
                    if (searchKey == null) {
                        searchKey = routeOffer.getService();
                    }
                    if (StaleProcessor.containsStaleRouteOffer(config, routeOffer, manager)) {
                        LOGGER.debug((URI)null, "findByRouteOffer", "RouteOffer was previously marked stale: {}", (Object)routeOffer.getRouteOffer().getName());
                        continue;
                    }
                    String versionToUse = config.getProperty("AFT_DME2_PREFERRED_VERSION");
                    if (StringUtils.isEmpty(versionToUse)) {
                        versionToUse = routeOffer.getVersion();
                    }
                    if ((endpoints = manager.findEndpoints(searchKey, versionToUse, routeOffer.getEnvContext(), routeOffer.getSearchFilter(), resource.isUsingVersionRanges())).length == 0) {
                        manager.addStaleRouteOffer(DME2URIUtils.buildServiceURIString(searchKey, routeOffer.getVersion(), routeOffer.getEnvContext(), routeOffer.getRouteOffer().getName()), 0L);
                        LOGGER.debug((URI)null, "findByRouteOffer", "0 Endpoints were returned for routeOffer, marking stale: {}", (Object)routeOffer.getRouteOffer().getName());
                    }
                    LOGGER.debug((URI)null, "findByRouteOffer", "Number of Endpoints returned for routeOffer {}: {}", (Object)routeOffer.getSearchFilter(), (Object)endpoints.length);
                    endpointMap.put(sequence, endpoints);
                }
            }
        }
        catch (DME2Exception e) {
            LOGGER.error((URI)null, "findByRouteOffer", "DME2Exception:{}", (Object)e);
        }
        return endpointMap;
    }

    public static List<DME2EndpointReference> createOrderedEndpointHolders(DME2Manager manager, ListMultimap<Integer, DME2RouteOffer> routeOffersGroupedBySeqence, Map<Integer, Map<Double, DME2Endpoint[]>> endpointsGroupedBySequence) {
        ArrayList<DME2EndpointReference> endpointReference = new ArrayList<DME2EndpointReference>();
        Set<Integer> endpointSequences = endpointsGroupedBySequence.keySet();
        for (Integer sequence : endpointSequences) {
            Map<Double, DME2Endpoint[]> bandedEndpoints = endpointsGroupedBySequence.get(sequence);
            Set<Double> endpointDistanceBands = bandedEndpoints.keySet();
            for (Double distanceBand : endpointDistanceBands) {
                DME2Endpoint[] endpoints;
                for (DME2Endpoint endpoint : endpoints = bandedEndpoints.get(distanceBand)) {
                    DME2RouteOffer routeOfferHolder = AvailableEndpoints.getRouteOfferForEndpoint(routeOffersGroupedBySeqence, endpoint, sequence);
                    DME2EndpointReference reference = new DME2EndpointReference().setSequence(sequence).setDistanceBand(distanceBand).setRouteOffer(routeOfferHolder).setEndpoint(endpoint).setManager(manager);
                    endpointReference.add(reference);
                }
            }
        }
        return endpointReference;
    }

    public static DME2RouteOffer getRouteOfferForEndpoint(ListMultimap<Integer, DME2RouteOffer> routeOfferMultiMap, DME2Endpoint endpoint, Integer sequence) {
        if (routeOfferMultiMap == null || endpoint == null || sequence == null) {
            return null;
        }
        List<DME2RouteOffer> routeOffers = routeOfferMultiMap.get(sequence);
        DME2RouteOffer tempRouteOffer = null;
        if (endpoint.getRouteOffer() != null) {
            block0: for (DME2RouteOffer routeOffer : routeOffers) {
                String[] tokens;
                if (routeOffer == null || routeOffer.getSearchFilter() == null) continue;
                for (String tok : tokens = routeOffer.getSearchFilter().split("~")) {
                    if (!endpoint.getRouteOffer().contains(tok) && !tok.contains("DEFAULT")) continue;
                    tempRouteOffer = routeOffer;
                    continue block0;
                }
            }
        }
        return tempRouteOffer;
    }
}

