/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.iterator.helper;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.google.common.collect.ListMultimap;
import com.att.aft.dme2.iterator.domain.DME2RouteOffer;
import com.att.aft.dme2.iterator.helper.StaleProcessor;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.util.DME2URIUtils;
import java.net.URI;
import java.util.Map;
import java.util.TreeMap;

public class EndpointByRouteOffer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointByRouteOffer.class.getName());

    private EndpointByRouteOffer() {
    }

    public static Map<Integer, DME2Endpoint[]> find(DME2Configuration config, ListMultimap<Integer, DME2RouteOffer> routeOffersGroupedBySequence, DME2Manager manager, DmeUniformResource resource) {
        TreeMap<Integer, DME2Endpoint[]> endpointMap = new TreeMap<Integer, DME2Endpoint[]>();
        try {
            for (Integer sequence : routeOffersGroupedBySequence.keySet()) {
                for (DME2RouteOffer routeOffer : routeOffersGroupedBySequence.get(sequence)) {
                    String searchKey = resource.getRegistryFindEndpointSearchKey();
                    if (searchKey == null) {
                        searchKey = routeOffer.getService();
                    }
                    if (StaleProcessor.containsStaleRouteOffer(config, routeOffer, manager)) {
                        LOGGER.info((URI)null, "find", "RouteOffer was previously marked stale: {}", (Object)routeOffer.getRouteOffer().getName());
                        continue;
                    }
                    DME2Endpoint[] endpoints = manager.findEndpoints(searchKey, routeOffer.getVersion(), routeOffer.getEnvContext(), routeOffer.getSearchFilter(), resource.isUsingVersionRanges());
                    if (endpoints.length == 0) {
                        manager.addStaleRouteOffer(DME2URIUtils.buildServiceURIString(searchKey, routeOffer.getVersion(), routeOffer.getEnvContext(), routeOffer.getRouteOffer().getName()), 0L);
                        LOGGER.info((URI)null, "find", "0 Endpoints were returned for routeOffer, marking stale: {}", (Object)routeOffer.getRouteOffer().getName());
                    }
                    LOGGER.info((URI)null, "find", "Number of Endpoints returned for routeOffer {}: {}", (Object)routeOffer.getSearchFilter(), (Object)endpoints.length);
                    endpointMap.put(sequence, endpoints);
                }
            }
        }
        catch (DME2Exception e) {
            LOGGER.info((URI)null, "find", "DME2Exception:{}", (Object)e);
        }
        return endpointMap;
    }
}

