/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.iterator.metrics;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.event.DME2CancelRequestEventProcessor;
import com.att.aft.dme2.event.DME2Event;
import com.att.aft.dme2.event.DME2EventManager;
import com.att.aft.dme2.event.DME2FaultEventProcessor;
import com.att.aft.dme2.event.DME2ReplyEventProcessor;
import com.att.aft.dme2.event.DME2RequestEventProcessor;
import com.att.aft.dme2.event.EventType;
import com.att.aft.dme2.iterator.domain.DME2EndpointReference;
import com.att.aft.dme2.iterator.domain.IteratorCreatingAttributes;
import com.att.aft.dme2.iterator.domain.IteratorMetricsEvent;
import com.att.aft.dme2.iterator.domain.IteratorMetricsEventHolder;
import com.att.aft.dme2.iterator.exception.IteratorException;
import com.att.aft.dme2.iterator.metrics.AbstractEndpointIteratorMetricsCollection;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.DME2Constants;
import com.att.aft.dme2.util.ScheduledExecution;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;

public class DefaultEndpointIteratorMetricsCollection
extends AbstractEndpointIteratorMetricsCollection {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultEndpointIteratorMetricsCollection.class.getName());
    private DME2Configuration config;
    private static String DEFAULT_EVENT_ROLE;
    private static String DEFAULT_EVENT_PROTOCOL;
    private static int MAX_THREAD_COUNT_TIMEOUT_CHECKER;
    private static long EVENT_TIMEOUT_TOTAL_WAITING_MS;
    private static long EVENT_CHECKER_SCHEDULER_DELAY_MS;
    private static Boolean DISABLE_METRICS;
    private DME2EventManager eventManager;
    private ScheduledFuture<?> eventTimeoutCheckerHandle = null;
    private String uniqueId = null;
    private long startTime = System.currentTimeMillis();
    private Map<String, IteratorMetricsEventHolder> startEventMap = new ConcurrentHashMap<String, IteratorMetricsEventHolder>();

    public DefaultEndpointIteratorMetricsCollection(DME2Manager manager, List<DME2EndpointReference> endpointReferenceList, String queryParamMinActiveEndPoint) throws DME2Exception {
        this.config = manager.getConfig();
        if (null != this.config) {
            throw new IteratorException(IteratorException.IteratorErrorCatalogue.ITERATOR_004, new Object[0]);
        }
        IteratorCreatingAttributes iteratorCreatingAttributes = new IteratorCreatingAttributes();
        this.init(iteratorCreatingAttributes);
    }

    public DefaultEndpointIteratorMetricsCollection(IteratorCreatingAttributes iteratorCreatingAttributes) {
        if (iteratorCreatingAttributes.getConfig() == null) {
            throw new IteratorException(IteratorException.IteratorErrorCatalogue.ITERATOR_004, new Object[0]);
        }
        this.config = iteratorCreatingAttributes.getConfig();
        this.init(iteratorCreatingAttributes);
    }

    private void init(IteratorCreatingAttributes iteratorCreatingAttributes) {
        if (DISABLE_METRICS == null) {
            DISABLE_METRICS = this.config.getBoolean(DME2Constants.AFT_DME2_DISABLE_METRICS);
        }
        if (!DISABLE_METRICS.booleanValue()) {
            DEFAULT_EVENT_ROLE = this.config.getProperty("AFT_DME2_INTERFACE_SERVER_ROLE");
            DEFAULT_EVENT_PROTOCOL = this.config.getProperty("AFT_DME2_INTERFACE_HTTP_PROTOCOL");
            MAX_THREAD_COUNT_TIMEOUT_CHECKER = this.config.getInt("MAX_THREAD_COUNT_TIMEOUT_CHECKER");
            EVENT_TIMEOUT_TOTAL_WAITING_MS = this.config.getLong("EVENT_TIMEOUT_TOTAL_WAITING_MS");
            EVENT_CHECKER_SCHEDULER_DELAY_MS = this.config.getLong("EVENT_CHECKER_SCHEDULER_DELAY_MS");
            this.eventManager = DME2EventManager.getInstance(this.config);
            this.registerEventHandlers(iteratorCreatingAttributes);
            this.generateUniqueTransactionReference();
            this.scheduleEventTimeoutChecker();
        }
    }

    private IteratorMetricsEventHolder getIteratorMetricsEventHolder(IteratorMetricsEvent iteratorMetricsEvent) {
        IteratorMetricsEventHolder iteratorMetricsEventHolder = new IteratorMetricsEventHolder();
        iteratorMetricsEventHolder.setIteratorMetricsEvent(iteratorMetricsEvent);
        return iteratorMetricsEventHolder;
    }

    @Override
    public void start(IteratorMetricsEvent iteratorMetricsEvent) {
        if (!DISABLE_METRICS.booleanValue()) {
            IteratorMetricsEventHolder iteratorMetricsEventHolder = this.getIteratorMetricsEventHolder(iteratorMetricsEvent);
            try {
                this.verify(iteratorMetricsEventHolder);
                this.assignStartEventDefaults(iteratorMetricsEventHolder);
                this.cancelActiveEvents();
                this.startEventMap.put(iteratorMetricsEventHolder.getIteratorMetricsEvent().getServiceUri(), iteratorMetricsEventHolder);
                this.startTime = System.currentTimeMillis();
                this.createEvent(iteratorMetricsEventHolder);
            }
            catch (Exception e) {
                LOGGER.warn((URI)null, "start", "error while creating event: ", (Object)iteratorMetricsEvent);
                throw e;
            }
        }
    }

    @Override
    public void endSuccess(IteratorMetricsEvent iteratorMetricsEvent) {
        if (!DISABLE_METRICS.booleanValue()) {
            IteratorMetricsEventHolder iteratorMetricsEventHolder = this.getIteratorMetricsEventHolder(iteratorMetricsEvent);
            this.verify(iteratorMetricsEventHolder);
            this.assignEndSuccesEventDefaults(iteratorMetricsEventHolder);
            this.end(iteratorMetricsEventHolder);
        }
    }

    @Override
    public void endFailure(IteratorMetricsEvent iteratorMetricsEvent) {
        if (!DISABLE_METRICS.booleanValue()) {
            IteratorMetricsEventHolder iteratorMetricsEventHolder = this.getIteratorMetricsEventHolder(iteratorMetricsEvent);
            this.verify(iteratorMetricsEventHolder);
            this.assignEndFailureEventDefaults(iteratorMetricsEventHolder);
            this.end(iteratorMetricsEventHolder);
        }
    }

    private void assignStartEventDefaults(IteratorMetricsEventHolder iteratorMetricsEventHolder) {
        iteratorMetricsEventHolder.setEventType(EventType.REQUEST_EVENT);
        this.assignEventDefaults(iteratorMetricsEventHolder);
    }

    private void assignEndSuccesEventDefaults(IteratorMetricsEventHolder iteratorMetricsEventHolder) {
        iteratorMetricsEventHolder.setEventType(EventType.REPLY_EVENT);
        this.assignEventDefaults(iteratorMetricsEventHolder);
    }

    private void assignEndFailureEventDefaults(IteratorMetricsEventHolder iteratorMetricsEventHolder) {
        iteratorMetricsEventHolder.setEventType(EventType.FAULT_EVENT);
        this.assignEventDefaults(iteratorMetricsEventHolder);
    }

    private void assignTimeoutEventDefaults(IteratorMetricsEventHolder iteratorMetricsEventHolder) {
        iteratorMetricsEventHolder.setEventType(EventType.TIMEOUT_EVENT);
        iteratorMetricsEventHolder.setElapsedTime(System.currentTimeMillis() - iteratorMetricsEventHolder.getIteratorMetricsEvent().getEventTime());
        iteratorMetricsEventHolder.getIteratorMetricsEvent().setEventTime(System.currentTimeMillis());
    }

    private void assignEventDefaults(IteratorMetricsEventHolder iteratorMetricsEventHolder) {
        if (iteratorMetricsEventHolder.getIteratorMetricsEvent().getClientIp() == null || iteratorMetricsEventHolder.getIteratorMetricsEvent().getClientIp().isEmpty()) {
            iteratorMetricsEventHolder.getIteratorMetricsEvent().setClientIp(this.getIpAddr());
        }
        if (iteratorMetricsEventHolder.getIteratorMetricsEvent().getEventTime() == -1L) {
            iteratorMetricsEventHolder.getIteratorMetricsEvent().setEventTime(System.currentTimeMillis());
        }
        iteratorMetricsEventHolder.setElapsedTime(System.currentTimeMillis() - this.startTime);
        if (iteratorMetricsEventHolder.getIteratorMetricsEvent().getProtocol() == null || iteratorMetricsEventHolder.getIteratorMetricsEvent().getProtocol().isEmpty()) {
            iteratorMetricsEventHolder.getIteratorMetricsEvent().setProtocol(DEFAULT_EVENT_PROTOCOL);
        }
        if (iteratorMetricsEventHolder.getIteratorMetricsEvent().getRole() == null || iteratorMetricsEventHolder.getIteratorMetricsEvent().getRole().isEmpty()) {
            iteratorMetricsEventHolder.getIteratorMetricsEvent().setRole(DEFAULT_EVENT_ROLE);
        }
    }

    private void end(IteratorMetricsEventHolder iteratorMetricsEventHolder) {
        try {
            this.verifyStartInvoked(iteratorMetricsEventHolder.getIteratorMetricsEvent().getServiceUri());
            this.createEvent(iteratorMetricsEventHolder);
            this.startEventMap.remove(iteratorMetricsEventHolder.getIteratorMetricsEvent().getServiceUri());
        }
        catch (Exception e) {
            LOGGER.warn((URI)null, "end", "error while creating event: [{}]", (Object)iteratorMetricsEventHolder);
        }
    }

    private void timedOut(String serviceUri) {
        IteratorMetricsEventHolder iteratorMetricsEventHolder = null;
        try {
            LOGGER.info((URI)null, "timedOut", "start:service URI [{}]", (Object)serviceUri);
            iteratorMetricsEventHolder = this.startEventMap.get(serviceUri);
            this.assignTimeoutEventDefaults(iteratorMetricsEventHolder);
            this.createEvent(iteratorMetricsEventHolder);
            LOGGER.info((URI)null, "timedOut", "end:service URI [{}]", (Object)serviceUri);
        }
        catch (Exception e) {
            LOGGER.warn((URI)null, "timedOut", "error while creating event: [{}]", (Object)iteratorMetricsEventHolder);
        }
    }

    private void verifyStartInvoked(String serviceUri) {
        if (!this.startEventMap.containsKey(serviceUri)) {
            LOGGER.warn((URI)null, "verifyStartInvoked", "Iterator metrics collection was never started for this service URI [{}]", (Object)serviceUri);
        }
    }

    private void createEvent(IteratorMetricsEventHolder iteratorMetricsEventHolder) {
        LOGGER.info((URI)null, "createEvent", "creating event: [{}]", (Object)iteratorMetricsEventHolder);
        DME2Event event = new DME2Event();
        event.setEventTime(iteratorMetricsEventHolder.getIteratorMetricsEvent().getEventTime());
        event.setType(iteratorMetricsEventHolder.getEventType());
        event.setQueueName(iteratorMetricsEventHolder.getIteratorMetricsEvent().getServiceUri());
        event.setElapsedTime(iteratorMetricsEventHolder.getElapsedTime());
        event.setMessageId(iteratorMetricsEventHolder.getIteratorMetricsEvent().getConversationId());
        event.setClientAddress(iteratorMetricsEventHolder.getIteratorMetricsEvent().getClientIp());
        event.setRole(iteratorMetricsEventHolder.getIteratorMetricsEvent().getRole());
        event.setProtocol(iteratorMetricsEventHolder.getIteratorMetricsEvent().getProtocol());
        event.setPartner(iteratorMetricsEventHolder.getIteratorMetricsEvent().getPartner());
        this.eventManager.postEvent(event);
    }

    private void cancelActiveEvents() {
        LOGGER.info(null, "cancelExistingEvents", "start");
        LOGGER.debug((URI)null, "cancelExistingEvents", " before: [{}]", (Object)this.startEventMap.toString());
        try {
            for (Map.Entry<String, IteratorMetricsEventHolder> entry : this.startEventMap.entrySet()) {
                LOGGER.debug((URI)null, "cancelExistingEvents", "[{}]", (Object)entry.getValue());
                this.cancelEvent(entry.getValue());
            }
            this.startEventMap.clear();
        }
        catch (Exception e) {
            LOGGER.warn((URI)null, "cancelExistingEvents", "error: [{}]", (Object)e.getMessage());
        }
        LOGGER.debug((URI)null, "cancelExistingEvents", "after: [{}]", (Object)this.startEventMap.toString());
        LOGGER.info(null, "cancelExistingEvents", "end");
    }

    private void cancelEvent(IteratorMetricsEventHolder iteratorMetricsEventHolder) {
        LOGGER.info((URI)null, "createEvent", "creating event: [{}]", (Object)iteratorMetricsEventHolder);
        DME2Event event = new DME2Event();
        event.setType(EventType.CANCEL_REQUEST_EVENT);
        event.setElapsedTime(System.currentTimeMillis() - iteratorMetricsEventHolder.getIteratorMetricsEvent().getEventTime());
        event.setEventTime(System.currentTimeMillis());
        event.setQueueName(iteratorMetricsEventHolder.getIteratorMetricsEvent().getServiceUri());
        event.setMessageId(iteratorMetricsEventHolder.getIteratorMetricsEvent().getConversationId());
        event.setClientAddress(iteratorMetricsEventHolder.getIteratorMetricsEvent().getClientIp());
        event.setRole(iteratorMetricsEventHolder.getIteratorMetricsEvent().getRole());
        event.setProtocol(iteratorMetricsEventHolder.getIteratorMetricsEvent().getProtocol());
        event.setPartner(iteratorMetricsEventHolder.getIteratorMetricsEvent().getPartner());
        this.eventManager.postEvent(event);
    }

    private String getIpAddr() {
        String ip = null;
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            LOGGER.debug(null, "getIpAddr", "cannot resolve local host address");
        }
        return ip;
    }

    private void registerEventHandlers(IteratorCreatingAttributes iteratorCreatingAttributes) {
        if (iteratorCreatingAttributes != null) {
            if (iteratorCreatingAttributes.getRequestEventProcessor() != null) {
                this.eventManager.registerEventProcessor(EventType.REQUEST_EVENT.getName(), iteratorCreatingAttributes.getRequestEventProcessor());
            } else {
                this.eventManager.registerEventProcessor(EventType.REQUEST_EVENT.getName(), new DME2RequestEventProcessor(this.config));
            }
            if (iteratorCreatingAttributes.getReplyEventProcessor() != null) {
                this.eventManager.registerEventProcessor(EventType.REPLY_EVENT.getName(), iteratorCreatingAttributes.getReplyEventProcessor());
            } else {
                this.eventManager.registerEventProcessor(EventType.REPLY_EVENT.getName(), new DME2ReplyEventProcessor(this.config));
            }
            if (iteratorCreatingAttributes.getFaultEventProcessor() != null) {
                this.eventManager.registerEventProcessor(EventType.FAULT_EVENT.getName(), iteratorCreatingAttributes.getFaultEventProcessor());
            } else {
                this.eventManager.registerEventProcessor(EventType.FAULT_EVENT.getName(), new DME2FaultEventProcessor(this.config));
            }
            if (iteratorCreatingAttributes.getTimeoutEventProcessor() != null) {
                this.eventManager.registerEventProcessor(EventType.TIMEOUT_EVENT.getName(), iteratorCreatingAttributes.getTimeoutEventProcessor());
            } else {
                this.eventManager.registerEventProcessor(EventType.TIMEOUT_EVENT.getName(), new DME2FaultEventProcessor(this.config));
            }
            if (iteratorCreatingAttributes.getCancelRequestEventProcessor() != null) {
                this.eventManager.registerEventProcessor(EventType.CANCEL_REQUEST_EVENT.getName(), iteratorCreatingAttributes.getCancelRequestEventProcessor());
            } else {
                this.eventManager.registerEventProcessor(EventType.CANCEL_REQUEST_EVENT.getName(), new DME2CancelRequestEventProcessor(this.config));
            }
        } else {
            LOGGER.error(null, "registerEventHandlers", "iteratorCreatingAttributes is null");
        }
    }

    private void verify(IteratorMetricsEventHolder iteratorMetricsEventHolder) {
        if (iteratorMetricsEventHolder.getIteratorMetricsEvent().getServiceUri() == null) {
            throw new IteratorException(IteratorException.IteratorErrorCatalogue.ITERATOR_001, new Object[0]);
        }
        if (iteratorMetricsEventHolder.getIteratorMetricsEvent().getConversationId() == null || iteratorMetricsEventHolder.getIteratorMetricsEvent().getConversationId().isEmpty()) {
            if (this.uniqueId == null || this.uniqueId.isEmpty()) {
                LOGGER.error(null, "verify", "Conversation Id is null");
                throw new IteratorException(IteratorException.IteratorErrorCatalogue.ITERATOR_003, new Object[0]);
            }
            iteratorMetricsEventHolder.getIteratorMetricsEvent().setConversationId(this.uniqueId);
        }
    }

    private String generateUniqueTransactionReference() {
        StringBuffer uniqueReference = new StringBuffer();
        uniqueReference.append(this.hashCode());
        uniqueReference.append("-");
        uniqueReference.append(UUID.randomUUID().toString());
        return uniqueReference.toString();
    }

    private void timeoutAllServicesIfExpired(boolean awaitExpiration) {
        LOGGER.info(null, "timeoutAllServicesIfExpired", "start");
        LOGGER.debug((URI)null, "timeoutAllServicesIfExpired", " before: [{}]", (Object)this.startEventMap.toString());
        try {
            ArrayList<String> keysToRemove = new ArrayList<String>();
            for (Map.Entry<String, IteratorMetricsEventHolder> entry : this.startEventMap.entrySet()) {
                LOGGER.debug((URI)null, "timeoutAllServicesIfExpired", "awaitExpiration:[{}], timeout check for serviceUri [{}]", (Object)awaitExpiration, (Object)entry.getKey());
                if (awaitExpiration) {
                    if (entry.getValue().getIteratorMetricsEvent().getTimeOutMS() == -1L) {
                        LOGGER.debug(null, "timeoutAllServicesIfExpired", "Default Timeout:[{}], Service Uri: [{}], Active time: [{}]", EVENT_TIMEOUT_TOTAL_WAITING_MS, entry.getKey(), System.currentTimeMillis() - entry.getValue().getIteratorMetricsEvent().getEventTime());
                        if (System.currentTimeMillis() - entry.getValue().getIteratorMetricsEvent().getEventTime() >= EVENT_TIMEOUT_TOTAL_WAITING_MS) {
                            this.timedOut(entry.getKey());
                            keysToRemove.add(entry.getKey());
                            continue;
                        }
                        LOGGER.debug((URI)null, "timeoutAllServicesIfExpired", "serviceUri [{}] is active", (Object)entry.getKey());
                        continue;
                    }
                    LOGGER.debug(null, "timeoutAllServicesIfExpired", "Client timeout:[{}], Service Uri: [{}], Active time: [{}]", entry.getValue().getIteratorMetricsEvent().getTimeOutMS(), entry.getKey(), System.currentTimeMillis() - entry.getValue().getIteratorMetricsEvent().getEventTime());
                    if (System.currentTimeMillis() - entry.getValue().getIteratorMetricsEvent().getEventTime() >= entry.getValue().getIteratorMetricsEvent().getTimeOutMS()) {
                        this.timedOut(entry.getKey());
                        keysToRemove.add(entry.getKey());
                        continue;
                    }
                    LOGGER.debug((URI)null, "timeoutAllServicesIfExpired", "serviceUri [{}] is active", (Object)entry.getKey());
                    continue;
                }
                this.timedOut(entry.getKey());
                keysToRemove.add(entry.getKey());
            }
            for (String keyToRemove : keysToRemove) {
                LOGGER.info((URI)null, "timeoutAllServicesIfExpired", "serviceUri [{}] is active", (Object)keysToRemove);
                this.startEventMap.remove(keyToRemove);
            }
            keysToRemove.clear();
        }
        catch (Exception e) {
            LOGGER.warn((URI)null, "timeoutAllServicesIfExpired", "error: [{}]", (Object)e.getMessage());
        }
        LOGGER.debug((URI)null, "timeoutAllServicesIfExpired", "after: [{}]", (Object)this.startEventMap.toString());
        LOGGER.info(null, "timeoutAllServicesIfExpired", "end");
    }

    private void scheduleEventTimeoutChecker() {
        LOGGER.info(null, "scheduleEventTimeoutChecker", "timeout check");
        Runnable timeoutChecker = new Runnable(){

            @Override
            public void run() {
                LOGGER.info(null, "scheduleEventTimeoutChecker", "start timeout checker");
                DefaultEndpointIteratorMetricsCollection.this.timeoutAllServicesIfExpired(true);
                LOGGER.info(null, "scheduleEventTimeoutChecker", "complete timeout checker");
            }
        };
        this.eventTimeoutCheckerHandle = ScheduledExecution.schedule("iterator-metricsevent-timeoutchecker", MAX_THREAD_COUNT_TIMEOUT_CHECKER, timeoutChecker, EVENT_CHECKER_SCHEDULER_DELAY_MS);
    }

    protected void finalize() throws Throwable {
        LOGGER.info(null, "finalize", "checking timedout start events");
        try {
            this.eventTimeoutCheckerHandle.cancel(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.timeoutAllServicesIfExpired(false);
    }

    @Override
    public Set<String> getActiveServices() {
        return this.startEventMap != null ? this.startEventMap.keySet() : new HashSet();
    }

    @Override
    public void setMetricsConversationId(String uniqueId) {
        this.uniqueId = uniqueId;
    }
}

