/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.iterator.util;

import com.att.aft.dme2.api.DME2Exception;
import com.att.aft.dme2.api.DME2Manager;
import com.att.aft.dme2.internal.google.common.base.Function;
import com.att.aft.dme2.internal.google.common.collect.ArrayListMultimap;
import com.att.aft.dme2.internal.google.common.collect.ListMultimap;
import com.att.aft.dme2.internal.google.common.collect.Multimaps;
import com.att.aft.dme2.iterator.domain.DME2EndpointReference;
import com.att.aft.dme2.iterator.domain.DME2RouteOffer;
import com.att.aft.dme2.iterator.service.DME2EndpointURLFormatter;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.manager.registry.DME2Endpoint;
import com.att.aft.dme2.manager.registry.DME2JDBCEndpoint;
import com.att.aft.dme2.request.DmeUniformResource;
import com.att.aft.dme2.util.DME2Utils;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class DME2CollectionUtils {
    private static final Logger logger = LoggerFactory.getLogger(DME2CollectionUtils.class.getName());

    public static ListMultimap<Integer, DME2RouteOffer> organizeRouteOffersBySequence(List<DME2RouteOffer> routeOffers) {
        Function<DME2RouteOffer, Integer> keyFun = new Function<DME2RouteOffer, Integer>(){

            @Override
            public Integer apply(DME2RouteOffer routeOffer) {
                return routeOffer.getSequence();
            }
        };
        return ArrayListMultimap.create(Multimaps.index(routeOffers, keyFun));
    }

    public static Map<Integer, Map<Double, DME2Endpoint[]>> findDME2EndpointByRouteOffer(ListMultimap<Integer, DME2RouteOffer> routeOfferMultimap, DME2Manager manager, DmeUniformResource resource) {
        TreeMap<Integer, Map<Double, DME2Endpoint[]>> endpointsGroupedBySequence = new TreeMap<Integer, Map<Double, DME2Endpoint[]>>();
        try {
            for (Integer sequence : routeOfferMultimap.keySet()) {
                List<DME2RouteOffer> routeOffers = routeOfferMultimap.get(sequence);
                for (DME2RouteOffer routeOffer : routeOffers) {
                    String searchKey = resource.getRegistryFindEndpointSearchKey();
                    if (searchKey == null) {
                        searchKey = routeOffer.getService();
                    }
                    if (DME2CollectionUtils.containsStaleRouteOffer(routeOffer, manager)) {
                        logger.debug((URI)null, "findDME2EndpointByRouteOffer", "RouteOffer was previously marked stale: {}", (Object)routeOffer.getRouteOffer().getName());
                        continue;
                    }
                    DME2Endpoint[] endpoints = manager.findEndpoints(searchKey, routeOffer.getVersion(), routeOffer.getEnvContext(), routeOffer.getSearchFilter(), resource.isUsingVersionRanges());
                    if (endpoints.length == 0) {
                        manager.addStaleRouteOffer(DME2Utils.buildServiceURIString(searchKey, routeOffer.getVersion(), routeOffer.getEnvContext(), routeOffer.getRouteOffer().getName()), 0L);
                        logger.debug((URI)null, "findDME2EndpointByRouteOffer", "0 Endpoints were returned for routeOffer, marking stale: {}", (Object)routeOffer.getRouteOffer().getName());
                    }
                    logger.debug((URI)null, "findDME2EndpointByRouteOffer", "Number of Endpoints returned for routeOffer {}: {}", (Object)routeOffer.getSearchFilter(), (Object)endpoints.length);
                    SortedMap<Double, DME2Endpoint[]> distanceToEndpointMap = DME2CollectionUtils.organizeEndpoints(endpoints);
                    endpointsGroupedBySequence.put(sequence, distanceToEndpointMap);
                }
            }
        }
        catch (DME2Exception e) {
            logger.debug((URI)null, "findDME2EndpointByRouteOffer", "DME2Exception", (Object)e);
        }
        return endpointsGroupedBySequence;
    }

    public static SortedMap<Double, DME2Endpoint[]> organizeEndpoints(DME2Endpoint[] endpoints) throws DME2Exception {
        TreeMap bandToEndpointMap = new TreeMap();
        TreeMap<Double, DME2Endpoint[]> map = new TreeMap<Double, DME2Endpoint[]>();
        double[] distanceBands = DME2Manager.getDefaultInstance().getDistanceBands();
        for (double distanceBand : distanceBands) {
            bandToEndpointMap.put(distanceBand, new ArrayList());
        }
        block1: for (double endpoint : (Object)endpoints) {
            double endpointDistance = endpoint.getDistance();
            for (Double band : bandToEndpointMap.keySet()) {
                if (!(endpointDistance < band)) continue;
                ((List)bandToEndpointMap.get(band)).add(endpoint);
                continue block1;
            }
        }
        Object object = bandToEndpointMap.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            double band = (Double)entry.getKey();
            List endpointListUnshuffled = (List)entry.getValue();
            if (endpointListUnshuffled.size() <= 0) continue;
            List<DME2Endpoint> endpointList = DME2CollectionUtils.randomizeEndpoints(endpointListUnshuffled);
            DME2Endpoint[] endpointArray = endpointList.toArray(new DME2Endpoint[endpointList.size()]);
            map.put(band, endpointArray);
        }
        return map;
    }

    private static List<DME2Endpoint> randomizeEndpoints(List<DME2Endpoint> endpoints) {
        Random random = new Random();
        ArrayList<DME2Endpoint> newList = new ArrayList<DME2Endpoint>();
        newList.addAll(endpoints);
        Collections.shuffle(newList, random);
        return newList;
    }

    public static List<String> randomizeURLs(List<String> endpoints) {
        Random random = new Random();
        ArrayList<String> newList = new ArrayList<String>();
        newList.addAll(endpoints);
        Collections.shuffle(newList, random);
        return newList;
    }

    public static DME2RouteOffer getRouteOfferForEndpoint(ListMultimap<Integer, DME2RouteOffer> routeOfferMultiMap, DME2Endpoint endpoint, Integer sequence) {
        if (routeOfferMultiMap == null || endpoint == null || sequence == null) {
            return null;
        }
        List<DME2RouteOffer> routeOffers = routeOfferMultiMap.get(sequence);
        DME2RouteOffer tempRouteOffer = null;
        if (endpoint.getRouteOffer() != null) {
            block0: for (DME2RouteOffer routeOffer : routeOffers) {
                String[] tokens;
                for (String tok : tokens = routeOffer.getSearchFilter().split("~")) {
                    if (!endpoint.getRouteOffer().contains(tok) && !tok.contains("DEFAULT")) continue;
                    tempRouteOffer = routeOffer;
                    continue block0;
                }
            }
        }
        return tempRouteOffer;
    }

    public static List<DME2EndpointReference> createDME2EndpointReferences(DME2Manager manager, ListMultimap<Integer, DME2RouteOffer> routeOffersGroupedBySeqence, Map<Integer, Map<Double, DME2Endpoint[]>> endpointsGroupedBySequence) {
        ArrayList<DME2EndpointReference> endpointReference = new ArrayList<DME2EndpointReference>();
        Set<Integer> endpointSequences = endpointsGroupedBySequence.keySet();
        for (Integer sequence : endpointSequences) {
            Map<Double, DME2Endpoint[]> bandedEndpoints = endpointsGroupedBySequence.get(sequence);
            Set<Double> endpointDistanceBands = bandedEndpoints.keySet();
            for (Double distanceBand : endpointDistanceBands) {
                DME2Endpoint[] endpoints;
                for (DME2Endpoint endpoint : endpoints = bandedEndpoints.get(distanceBand)) {
                    DME2RouteOffer routeOffer = DME2CollectionUtils.getRouteOfferForEndpoint(routeOffersGroupedBySeqence, endpoint, sequence);
                    DME2EndpointReference reference = new DME2EndpointReference(manager, endpoint);
                    reference.setSequence(sequence);
                    reference.setDistanceBand(distanceBand);
                    reference.setRouteOffer(routeOffer);
                    endpointReference.add(reference);
                }
            }
        }
        return endpointReference;
    }

    public static boolean containsPreferredRouteOffer(ListMultimap<Integer, DME2RouteOffer> routeOfferMultiMap, String preferredRouteOffer) {
        Set sequences = routeOfferMultiMap.keySet();
        for (Integer sequence : sequences) {
            List<DME2RouteOffer> routeOfferList = routeOfferMultiMap.get(sequence);
            for (DME2RouteOffer routeOffer : routeOfferList) {
                if (!routeOffer.getSearchFilter().contains(preferredRouteOffer)) continue;
                routeOfferMultiMap.put(-1, routeOffer);
                return true;
            }
        }
        return false;
    }

    public static void organizeEndpointsByPreferredRouteOffer(Map<Integer, Map<Double, DME2Endpoint[]>> sequenceToEndpointMap, String preferredRouteOffer) {
        if (sequenceToEndpointMap != null) {
            ArrayList<DME2Endpoint> preferredEndpointsList = new ArrayList<DME2Endpoint>();
            Set<Integer> sequences = sequenceToEndpointMap.keySet();
            for (Integer sequence : sequences) {
                Map<Double, DME2Endpoint[]> distanceBandsToEndpoints = sequenceToEndpointMap.get(sequence);
                Set<Double> distanceBands = distanceBandsToEndpoints.keySet();
                for (Double distanceBand : distanceBands) {
                    DME2Endpoint[] eps;
                    for (DME2Endpoint ep : eps = distanceBandsToEndpoints.get(distanceBand)) {
                        if (!ep.getRouteOffer().equals(preferredRouteOffer)) continue;
                        preferredEndpointsList.add(ep);
                    }
                }
            }
            if (!preferredEndpointsList.isEmpty()) {
                HashMap<Double, DME2Endpoint[]> preferredEndpointsMap = new HashMap<Double, DME2Endpoint[]>();
                DME2Endpoint[] preferredEndpointArray = new DME2Endpoint[preferredEndpointsList.size()];
                preferredEndpointsList.toArray(preferredEndpointArray);
                preferredEndpointsMap.put(0.0, preferredEndpointArray);
                sequenceToEndpointMap.put(-1, preferredEndpointsMap);
            }
        }
    }

    public static boolean containsPreferredURL(Map<Integer, Map<Double, DME2Endpoint[]>> sequenceToEndpointMap, String preferredURL, DME2EndpointURLFormatter urlFormatter) {
        Set<Integer> sequences = sequenceToEndpointMap.keySet();
        for (Integer sequence : sequences) {
            Map<Double, DME2Endpoint[]> distanceBandsToEndpoints = sequenceToEndpointMap.get(sequence);
            Set<Double> distanceBands = distanceBandsToEndpoints.keySet();
            for (Double distanceBand : distanceBands) {
                DME2Endpoint[] eps;
                for (DME2Endpoint ep : eps = distanceBandsToEndpoints.get(distanceBand)) {
                    String finalURLString = null;
                    if (urlFormatter != null) {
                        finalURLString = urlFormatter.formatURL(ep);
                        if (ep instanceof DME2JDBCEndpoint && finalURLString.startsWith("jdbc:dme2jdbc")) {
                            finalURLString = finalURLString.substring(9);
                        }
                    } else {
                        finalURLString = ep.toURLString();
                    }
                    if (!finalURLString.equals(preferredURL)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void organizeEndpointsByPreferredURL(Map<Integer, Map<Double, DME2Endpoint[]>> sequenceToEndpointMap, String preferredURL, DME2EndpointURLFormatter urlFormatter) {
        DME2Endpoint endpointWithPreferredURL = null;
        boolean preferredURLFound = false;
        if (sequenceToEndpointMap != null) {
            Set<Integer> sequences = sequenceToEndpointMap.keySet();
            for (Integer sequence : sequences) {
                Map<Double, DME2Endpoint[]> distanceBandsToEndpoints = sequenceToEndpointMap.get(sequence);
                Set<Double> distanceBands = distanceBandsToEndpoints.keySet();
                for (Double distanceBand : distanceBands) {
                    DME2Endpoint[] eps;
                    for (DME2Endpoint ep : eps = distanceBandsToEndpoints.get(distanceBand)) {
                        String finalURLString = null;
                        if (urlFormatter != null) {
                            finalURLString = urlFormatter.formatURL(ep);
                            if (ep instanceof DME2JDBCEndpoint && finalURLString.startsWith("jdbc:dme2jdbc")) {
                                finalURLString = finalURLString.substring(9);
                            }
                        } else {
                            finalURLString = ep.toURLString();
                        }
                        if (!finalURLString.equals(preferredURL)) continue;
                        endpointWithPreferredURL = ep;
                        preferredURLFound = true;
                        break;
                    }
                    if (!preferredURLFound) continue;
                    break;
                }
                if (!preferredURLFound) continue;
                break;
            }
            if (preferredURLFound && endpointWithPreferredURL != null) {
                DME2Endpoint[] endpointArray = new DME2Endpoint[]{endpointWithPreferredURL};
                HashMap<Double, DME2Endpoint[]> map = new HashMap<Double, DME2Endpoint[]>();
                map.put(0.0, endpointArray);
                sequenceToEndpointMap.put(-1, map);
            }
        }
    }

    private static boolean containsStaleRouteOffer(DME2RouteOffer offer, DME2Manager mgr) {
        String[] routeOffers;
        logger.debug((URI)null, "containsStaleRouteOffer", "Checking for stale RouteOffers using search filter: {}", (Object)offer.getSearchFilter());
        int staleCount = 0;
        for (String routeOffer : routeOffers = offer.getSearchFilter().split("~")) {
            String serviceURI = null;
            if (routeOffer.equals(DmeUniformResource.DmeUrlType.DIRECT.toString()) || !mgr.isRouteOfferStale(serviceURI = DME2Utils.buildServiceURIString(offer.getService(), offer.getVersion(), offer.getEnvContext(), routeOffer))) continue;
            ++staleCount;
        }
        if (staleCount == routeOffers.length) {
            String msg = String.format("All RouteOffers for service %s were previously marked stale. The number of RouteOffers in the search filter was: %s.", offer.getService(), routeOffers.length);
            logger.debug(null, "containsStaleRouteOffer", msg);
            return true;
        }
        return false;
    }
}

