/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms;

import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.internal.jetty.continuation.Continuation;
import com.att.aft.dme2.jms.DME2JMSException;
import com.att.aft.dme2.jms.DME2JMSManager;
import com.att.aft.dme2.jms.DME2JMSMessage;
import com.att.aft.dme2.jms.DME2JMSQueue;
import com.att.aft.dme2.jms.DME2JMSTextMessage;
import com.att.aft.dme2.logging.LogMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.DME2Constants;
import com.att.aft.dme2.util.ErrorContext;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.servlet.http.HttpServletResponse;

public class DME2JMSContinuationQueue
extends DME2JMSQueue {
    private static final long serialVersionUID = 1L;
    private final Map<String, Continuation> continuations = Collections.synchronizedMap(new HashMap());
    private final Map<String, String> requestInfo = Collections.synchronizedMap(new HashMap());
    private static final Logger logger = LoggerFactory.getLogger(DME2JMSContinuationQueue.class.getName());
    private final DME2JMSManager manager;
    private DME2Configuration config;
    private static final int CONSTANT_100 = 100;
    private static final String HASHCODE = "; hashCode=";
    private static final String REQUESTCODE = "requestQueue";
    private static final String CODE = "Code";
    private static final String RESULT = "Result";
    private static final String EXTENDEDMESSAGE = "extendedMessage";
    public static final String CONTENT_LENGTH_LABEL = "Content-Length";
    public static final String ENABLE_CONTENT_LENGTH_LABEL = "AFT_DME2_SET_RESLEN";

    public DME2JMSContinuationQueue(DME2JMSManager manager, URI name) throws JMSException {
        super(manager, name);
        this.manager = manager;
        logger.debug((URI)null, "DME2JMSContinuationQueue", "Creating contQueue {};uri={}", (Object)this, (Object)name.getPath());
    }

    public synchronized void addContinuation(String correlationID, Continuation continuation, String requestQueueName, String requestPartnerName) {
        logger.debug(null, "addContinuation", "Adding correlationID {} {} {}; contQueue={}", correlationID, HASHCODE, correlationID.hashCode(), this);
        this.continuations.put(correlationID, continuation);
        this.requestInfo.put(correlationID, System.currentTimeMillis() + DME2Constants.LOGRECORDSEP + requestQueueName + DME2Constants.LOGRECORDSEP + (requestPartnerName != null ? requestPartnerName : ""));
        this.manager.addContinuation(correlationID, this);
        logger.debug((URI)null, "addContinuation", "Added correlationID {}; Continuation Object={}", (Object)correlationID, (Object)continuation);
    }

    @Override
    public void put(DME2JMSMessage m) throws JMSException {
        String contentType;
        DME2JMSTextMessage tm;
        logger.debug(null, "put", LogMessage.METHOD_ENTER);
        boolean replySuccessful = false;
        boolean failover = false;
        boolean failed = false;
        long msgSize = 0L;
        long elapsedTime = 0L;
        String reqQueue = null;
        String requestPartner = null;
        String msgId = m.getJMSCorrelationID();
        String conversationId = m.getStringProperty("JMSConversationID");
        String requestQueue = m.getStringProperty(REQUESTCODE);
        String trackingId = msgId + (conversationId == null ? "" : "(" + conversationId + ")");
        if (requestQueue != null) {
            DME2Constants.setContext(requestQueue + DME2Constants.LOGRECORDSEP + trackingId, null);
        } else {
            DME2Constants.setContext(trackingId, null);
        }
        Properties debugProps = m.getProperties();
        StringBuffer debugSB = new StringBuffer();
        Enumeration<?> e = debugProps.propertyNames();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = debugProps.get(key);
            if (debugSB.length() > 1) {
                debugSB.append(",");
            }
            debugSB.append(key);
            debugSB.append("=");
            debugSB.append(value);
            logger.debug((URI)null, "put", "put:{}", (Object)debugSB);
        }
        m.setJMSDestination((Destination)this);
        String value = this.requestInfo.get(m.getJMSCorrelationID());
        if (value != null) {
            try {
                String[] values = value.split("\\" + DME2Constants.LOGRECORDSEP);
                long time = Long.parseLong(values[0]);
                reqQueue = values[1];
                elapsedTime = System.currentTimeMillis() - time;
                if (values.length >= 3) {
                    requestPartner = values[2];
                }
            }
            catch (Exception e1) {
                logger.debug((URI)null, "put", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e1);
            }
        }
        if (m != null && m instanceof DME2JMSTextMessage && (tm = (DME2JMSTextMessage)m).getText() != null) {
            msgSize = tm.getText().length();
        }
        logger.debug(null, "put", "Continuations get {}; contQueue={} {} {}; hmsize={}; containsKey={}", m.getJMSCorrelationID(), this, HASHCODE, m.getJMSCorrelationID().hashCode(), this.continuations.size(), this.continuations.get(m.getJMSCorrelationID()));
        Continuation c = this.continuations.get(m.getJMSCorrelationID());
        logger.debug(null, "put", "Continuations get returned for {}; Continuation={}; contQueue={}{}{}", m.getJMSCorrelationID(), c, this, HASHCODE, m.getJMSCorrelationID().hashCode());
        if (c == null) {
            Thread.yield();
            try {
                Thread.sleep(100L);
            }
            catch (Exception e1) {
                logger.debug((URI)null, "put", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e1);
            }
            logger.debug((URI)null, "put", "Continuations get after sleep {} {}", (Object)m.getJMSCorrelationID(), (Object)Thread.currentThread().getName());
            c = this.continuations.get(m.getJMSCorrelationID());
            if (c == null) {
                throw new DME2JMSException("AFT-DME2-5105", new ErrorContext().add(REQUESTCODE, reqQueue));
            }
        }
        while (c.isSuspended() && c.isResumed()) {
            logger.debug(null, "put", "Continuation suspended : {}|{};Continuation={}{}{}", m.getJMSMessageID(), m.getJMSReplyTo(), c, HASHCODE, m.getJMSCorrelationID().hashCode());
            try {
                Thread.yield();
            }
            catch (Exception e1) {
                logger.debug((URI)null, "put", LogMessage.DEBUG_MESSAGE, (Object)"Exception", (Object)e1);
            }
        }
        HttpServletResponse resp = (HttpServletResponse)c.getServletResponse();
        String charset = m.getStringProperty("com.att.aft.dme2.jms.charset");
        if ((charset == null || "null".equalsIgnoreCase(charset)) && ((charset = this.manager.getDME2Manager().getCharacterSet()) == null || "null".equalsIgnoreCase(charset))) {
            charset = "ISO-8859-1";
        }
        if ((contentType = m.getStringProperty("com.att.aft.dme2.jms.contentType")) != null) {
            resp.setContentType(contentType + "; charset=" + charset);
        } else if (charset != null) {
            resp.setContentType("text/plain; charset=".concat(charset));
        }
        if (m.getBooleanProperty("JMSXDME2ForceFailoverFlag")) {
            int failoverCode = m.getIntProperty("JMSXDME2ForceFailoverCode");
            String failoverMessage = m.getStringProperty("JMSXDME2ForceFailoverMessage");
            if (failoverCode < 404) {
                failoverCode = 503;
            }
            if (failoverMessage == null || failoverMessage.length() == 0) {
                failoverMessage = "SERVICE IMPLEMENTATION IS UNAVAILABLE";
            }
            try {
                this.continuations.remove(m.getJMSCorrelationID());
                this.requestInfo.remove(m.getJMSCorrelationID());
                logger.warn((URI)null, "put", "AFT-DME2-5102", (Object)new ErrorContext().add(CODE, "Server.Reply.Failover").add(RESULT, "503").add("FailoverMessage", failoverMessage));
                failover = true;
                resp.sendError(failoverCode, failoverMessage);
            }
            catch (IOException e1) {
                failed = true;
                logger.warn((URI)null, "put", "AFT-DME2-5103", (Object)new ErrorContext().add(CODE, "Server.Reply").add(RESULT, "FailoverFault").add(EXTENDEDMESSAGE, e1.getMessage()).add("Elapsed", elapsedTime + ""), (Object)e1);
            }
        } else {
            Enumeration<?> e1 = m.getPropertyNames();
            while (e1.hasMoreElements()) {
                String key = (String)e1.nextElement();
                String debugValue = m.getStringProperty(key);
                resp.setHeader(key, debugValue);
            }
            m.genID();
            DME2Configuration config = this.manager.getDME2Manager().getConfig();
            resp.setHeader(config.getProperty("DME2_HEADER_PREFIX") + "JMSMessageID", m.getJMSMessageID());
            resp.setHeader(config.getProperty("DME2_HEADER_PREFIX") + "JMSCorrelationID", m.getJMSCorrelationID());
            resp.setHeader(config.getProperty("DME2_HEADER_PREFIX") + "JMSType", m.getJMSType());
            resp.setHeader(config.getProperty("DME2_HEADER_PREFIX") + "JMSDeliveryMode", "" + m.getJMSDeliveryMode());
            resp.setHeader(config.getProperty("DME2_HEADER_PREFIX") + "JMSExpiration", "" + m.getJMSExpiration());
            resp.setHeader(config.getProperty("DME2_HEADER_PREFIX") + "JMSPriority", "" + m.getJMSPriority());
            resp.setHeader(config.getProperty("DME2_HEADER_PREFIX") + "JMSTimestamp", "" + m.getJMSTimestamp());
            Queue queue = (Queue)m.getJMSDestination();
            resp.setHeader(config.getProperty("DME2_HEADER_PREFIX") + "JMSDestination", queue.getQueueName());
            boolean enableContentLength = config.getBoolean(ENABLE_CONTENT_LENGTH_LABEL);
            byte[] rawBytes = null;
            if (m instanceof DME2JMSTextMessage) {
                DME2JMSTextMessage m1 = (DME2JMSTextMessage)m;
                if (m1.getText() != null) {
                    logger.debug((URI)null, "put", "Response Data= {}| ResponseLength={}", (Object)m1.getText(), (Object)m1.getText().length());
                    try {
                        rawBytes = m1.getText().getBytes(charset);
                        logger.debug((URI)null, "put", "raw bytes size = {}", (Object)rawBytes.length);
                    }
                    catch (UnsupportedEncodingException e11) {
                        throw new DME2JMSException("AFT-DME2-5106", new ErrorContext().add(REQUESTCODE, reqQueue).add("replyQueue", queue.getQueueName()).add("messageID", m.getJMSMessageID()).add("correlationID", m.getJMSCorrelationID()));
                    }
                }
                if (enableContentLength && rawBytes != null) {
                    resp.setContentLength(rawBytes.length);
                    resp.setIntHeader(CONTENT_LENGTH_LABEL, rawBytes.length);
                }
            }
            try {
                if (rawBytes != null) {
                    resp.getOutputStream().write(rawBytes);
                }
                replySuccessful = true;
                logger.debug(null, "put", "Continuation reply successful : {}|{};replySuccessful={}", m.getJMSMessageID(), m.getJMSReplyTo(), replySuccessful);
            }
            catch (IOException io) {
                failed = true;
                logger.error((URI)null, "put", "AFT-DME2-5104 {}", (Object)new ErrorContext().add(CODE, "Server.Reply").add(RESULT, "Failed").add(EXTENDEDMESSAGE, io.getMessage()).add("Elapsed", elapsedTime + ""), (Object)io);
                JMSException je = new JMSException("Response send failed");
                je.initCause((Throwable)io);
                throw new DME2JMSException("AFT-DME2-5105", new ErrorContext().add(EXTENDEDMESSAGE, io.getMessage()).add(REQUESTCODE, reqQueue), (Throwable)je);
            }
            finally {
                this.manager.removeContinuation(m.getJMSCorrelationID());
                if (replySuccessful) {
                    logger.info((URI)null, "put", "AFT-DME2-5100 {}", (Object)new ErrorContext().add(CODE, "Server.Reply").add(RESULT, "Success").add("Elapsed", elapsedTime + ""));
                    if (m != null) {
                        this.createSuccessResponseMetricsEvent(msgSize, reqQueue, elapsedTime, m, requestPartner);
                    }
                }
            }
        }
        if (failed) {
            try {
                this.createErrorResponseMetricsEvent(msgSize, reqQueue, elapsedTime, m, requestPartner);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (failover) {
            try {
                this.createFailoverRequestMetricsEvent(msgSize, reqQueue, elapsedTime, m, requestPartner);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (c.isSuspended()) {
            logger.debug((URI)null, "put", "Continuation completed for : {}|{}", (Object)m.getJMSMessageID(), (Object)m.getJMSReplyTo());
            c.complete();
        }
        logger.debug(null, "put", "Continuation state for : {}|{} {} {} {}", m.getJMSMessageID(), m.getJMSReplyTo(), c.isExpired(), c.isInitial(), c.isResumed());
        this.continuations.remove(m.getJMSCorrelationID());
        this.requestInfo.remove(m.getJMSCorrelationID());
        logger.debug(null, "put", LogMessage.METHOD_EXIT);
    }

    private void createSuccessResponseMetricsEvent(long msgSize, String reqQueue, long elapsedTime, DME2JMSMessage m, String requestPartner) {
        try {
            this.createMetricsEvent(msgSize, reqQueue, elapsedTime, m, requestPartner, "REPLY_EVENT", "EventProcessor.Success");
        }
        catch (Exception e11) {
            logger.debug((URI)null, "put", "AFT-DME2-5101", (Object)new ErrorContext().add(CODE, "EventProcessor.Fault").add(EXTENDEDMESSAGE, e11.getMessage()));
        }
    }

    private void createErrorResponseMetricsEvent(long msgSize, String reqQueue, long elapsedTime, DME2JMSMessage m, String requestPartner) throws JMSException {
        this.createMetricsEvent(msgSize, reqQueue, elapsedTime, m, requestPartner, "FAULT_EVENT", "EventProcessor.Failed");
    }

    private void createFailoverRequestMetricsEvent(long msgSize, String reqQueue, long elapsedTime, DME2JMSMessage m, String requestPartner) throws JMSException {
        this.createMetricsEvent(msgSize, reqQueue, elapsedTime, m, requestPartner, "FAILOVER_EVENT", "EventProcessor.Failover");
    }

    private void createMetricsEvent(long msgSize, String reqQueue, long elapsedTime, DME2JMSMessage m, String requestPartner, String eventType, String errorCode) throws JMSException {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("MSG_SIZE", msgSize);
        props.put("EVENT_TIME", System.currentTimeMillis());
        props.put(eventType, true);
        props.put("QUEUE_NAME", reqQueue);
        props.put("ELAPSED_TIME", elapsedTime);
        if (m.getJMSCorrelationID() != null) {
            props.put("MESSAGE_ID", m.getJMSCorrelationID());
        } else {
            props.put("MESSAGE_ID", m.getJMSMessageID());
        }
        if (requestPartner != null && requestPartner.length() > 0) {
            props.put("DME2_REQUEST_PARTNER", requestPartner);
        }
        props.put("DME2_INTERFACE_PORT", this.manager.getDME2Manager().getPort() + "");
        props.put("DME2_INTERFACE_PROTOCOL", this.config.getProperty("AFT_DME2_INTERFACE_JMS_PROTOCOL"));
        try {
            this.manager.getDME2Manager().postStatEvent(props);
        }
        catch (Exception e1) {
            logger.debug((URI)null, "put", "AFT-DME2-5101", (Object)new ErrorContext().add(CODE, errorCode).add(EXTENDEDMESSAGE, e1.getMessage()));
        }
    }

    public String toString() {
        try {
            return "ContinuationQueue: " + this.getQueueName();
        }
        catch (JMSException e) {
            return "ContinuationQueue";
        }
    }
}

