/*
 * Decompiled with CFR 0.152.
 */
package com.att.aft.dme2.jms;

import com.att.aft.dme2.config.DME2Configuration;
import com.att.aft.dme2.jms.DME2JMSContinuationQueue;
import com.att.aft.dme2.jms.DME2JMSException;
import com.att.aft.dme2.jms.DME2JMSManager;
import com.att.aft.dme2.jms.DME2JMSMessage;
import com.att.aft.dme2.jms.DME2JMSQueue;
import com.att.aft.dme2.jms.DME2JMSTextMessage;
import com.att.aft.dme2.logging.Logger;
import com.att.aft.dme2.logging.LoggerFactory;
import com.att.aft.dme2.util.ErrorContext;
import java.lang.management.ManagementFactory;
import java.net.URI;
import java.util.Enumeration;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;

public class DME2JMSDefaultListener
extends Thread
implements MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(DME2JMSDefaultListener.class.getName());
    private long listener_id = 0L;
    private static long counter = 0L;
    private Message msg = null;
    private boolean active = false;
    private final DME2JMSManager manager;
    private DME2Configuration config;
    private int maxRetry = 0;
    private static final int CONSTANT_MAXSLEEP = 5;
    private static final int CONSTANT_MAXRETRY = 3;
    private static final int CONSTANT_JMSXDME2FORCEFAILOVERCODE = 222;
    private long maxSleep = 5L;

    public DME2JMSDefaultListener(DME2JMSManager manager, Queue serverDest) {
        this.manager = manager;
        this.config = manager.getDME2Manager().getConfig();
        if (counter == Long.MAX_VALUE) {
            counter = 0L;
        }
        this.listener_id = counter++;
        ManagementFactory.getRuntimeMXBean().getName();
        try {
            this.maxRetry = Integer.parseInt(this.config.getProperty("AFT_DME2_RECEIVE_MAX_RETRY"));
            this.maxSleep = Integer.parseInt(this.config.getProperty("AFT_DME2_RETRY_SLEEP"));
        }
        catch (Exception e) {
            this.maxRetry = 3;
        }
    }

    public long getID() {
        return this.listener_id;
    }

    /*
     * Exception decompiling
     */
    public void onMessage(Message message) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message get(long timeout, String filter) throws JMSException {
        try {
            DME2JMSDefaultListener dME2JMSDefaultListener = this;
            synchronized (dME2JMSDefaultListener) {
                this.active = true;
                long start = System.currentTimeMillis();
                try {
                    this.wait(timeout);
                    logger.debug(null, "onMessage", "JMSDefaultListener wait ended, messageID: ", this.msg == null ? this.msg : this.msg.getJMSMessageID(), " active: ", this.active, ", wait time: ", System.currentTimeMillis() - start, " ms, listenerID: ", this.listener_id);
                }
                catch (InterruptedException e1) {
                    this.active = false;
                }
                this.active = false;
            }
        }
        catch (Exception e) {
            throw new DME2JMSException("AFT-DME2-5200", new ErrorContext().add("extendedMessage", e.getMessage()).add("manager", this.manager.getDME2Manager().getName()), (Throwable)e);
        }
        return this.msg;
    }

    private void forceFailover(Message message, String failoverMsg) throws Exception {
        logger.warn((URI)null, "forceFailover", "AFT-DME2-5201", (Object)new ErrorContext().add("Code", "Server.Reply.Failover").add("Result", "503").add("FailoverMessage", failoverMsg));
        message.setBooleanProperty("JMSXDME2ForceFailoverFlag", true);
        message.setIntProperty("JMSXDME2ForceFailoverCode", 222);
        message.setStringProperty("JMSXDME2ForceFailoverMessage", failoverMsg);
        message.setJMSCorrelationID(message.getJMSMessageID());
        DME2JMSContinuationQueue replyToQueue = (DME2JMSContinuationQueue)message.getJMSReplyTo();
        replyToQueue.put((DME2JMSMessage)message);
    }

    private boolean retryMessage(Message message) throws Exception {
        String queueName = message.getStringProperty("requestQueue");
        DME2JMSQueue requestQueue = this.manager.getQueue("http://DME2LOCAL" + queueName);
        if (requestQueue == null) {
            this.forceFailover(message, "Request queue not found");
            return true;
        }
        Thread.yield();
        Thread.sleep(this.maxSleep);
        try {
            requestQueue.put((DME2JMSMessage)message);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public DME2JMSTextMessage copy(DME2JMSMessage message) throws JMSException {
        DME2JMSTextMessage copy = new DME2JMSTextMessage();
        Properties properties = message.getProperties();
        Enumeration<?> propertyNames = message.getPropertyNames();
        while (propertyNames.hasMoreElements()) {
            String name = propertyNames.nextElement().toString();
            String value = properties.getProperty(name);
            copy.setStringProperty(name, value);
        }
        if (message instanceof DME2JMSTextMessage) {
            copy.setText(((DME2JMSTextMessage)message).getText());
        }
        if (message.getJMSCorrelationID() != null) {
            copy.setJMSCorrelationID(message.getJMSCorrelationID());
        }
        if (message.getJMSCorrelationIDAsBytes() != null) {
            copy.setJMSCorrelationIDAsBytes(message.getJMSCorrelationIDAsBytes());
        }
        copy.setJMSDeliveryMode(message.getJMSDeliveryMode());
        if (message.getJMSDestination() != null) {
            copy.setJMSDestination(message.getJMSDestination());
        }
        copy.setJMSExpiration(message.getJMSExpiration());
        if (message.getJMSMessageID() != null) {
            copy.setJMSMessageID(message.getJMSMessageID());
        }
        copy.setJMSPriority(message.getJMSPriority());
        copy.setJMSRedelivered(message.getJMSRedelivered());
        if (message.getJMSReplyTo() != null) {
            copy.setJMSReplyTo(message.getJMSReplyTo());
        }
        copy.setJMSTimestamp(message.getJMSTimestamp());
        if (message.getJMSType() != null) {
            copy.setJMSType(message.getJMSType());
        }
        return copy;
    }
}

